/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.Expression;
import org.apache.camel.Traceable;
import org.apache.camel.processor.BaseProcessorSupport;

public class EvaluateExpressionProcessor
extends BaseProcessorSupport
implements Traceable {
    private final Expression expression;

    public EvaluateExpressionProcessor(Expression expression) {
        this.expression = expression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            Object result = this.expression.evaluate(exchange, Object.class);
            exchange.setProperty(ExchangePropertyKey.EVALUATE_EXPRESSION_RESULT, result);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        finally {
            callback.done(true);
        }
        return true;
    }

    public String toString() {
        return "EvalExpression[" + String.valueOf(this.expression) + "]";
    }

    public String getTraceLabel() {
        return "eval[" + String.valueOf(this.expression) + "]";
    }
}

