# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

# NOTE! THIS FILE IS AUTOMATICALLY GENERATED AND WILL BE OVERWRITTEN!
#
# IF YOU WANT TO MODIFY THIS FILE, YOU SHOULD MODIFY THE TEMPLATE
# `get_provider_info_TEMPLATE.py.jinja2` IN the `dev/breeze/src/airflow_breeze/templates` DIRECTORY


def get_provider_info():
    return {
        "package-name": "apache-airflow-providers-keycloak",
        "name": "Keycloak",
        "description": "``Keycloak Provider``\n",
        "auth-managers": [
            "airflow.providers.keycloak.auth_manager.keycloak_auth_manager.KeycloakAuthManager"
        ],
        "config": {
            "keycloak_auth_manager": {
                "description": "This section contains settings for Keycloak auth manager integration.",
                "options": {
                    "client_id": {
                        "description": "Client ID configured in Keycloak to integrate with Airflow.\nThis client must follow the standard OpenID Connect authentication flow.\n",
                        "type": "string",
                        "version_added": "0.0.1",
                        "example": None,
                        "default": None,
                    },
                    "client_secret": {
                        "description": "Secret associated to the client configured in Keycloak to integrate with Airflow.\n",
                        "type": "string",
                        "version_added": "0.0.1",
                        "example": None,
                        "default": None,
                    },
                    "realm": {
                        "description": "Realm configured in Keycloak associated to Airflow.\nThis realm define all users, roles and groups used in Airflow.\n",
                        "type": "string",
                        "version_added": "0.0.1",
                        "example": None,
                        "default": None,
                    },
                    "server_url": {
                        "description": 'Keycloak server URL.\nThis server URL is used by the Airflow API server to communicate with Keycloak.\nIf the Airflow API server and Keycloak are running in Docker,\nset "http://host.docker.internal:<PORT>" (default value).\n',
                        "type": "string",
                        "version_added": "0.0.1",
                        "example": None,
                        "default": "http://host.docker.internal:48080",
                    },
                },
            }
        },
    }
