/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.operations;

import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.stress.Operation;
import org.apache.cassandra.stress.WorkManager;
import org.apache.cassandra.stress.generate.Distribution;
import org.apache.cassandra.stress.generate.PartitionGenerator;
import org.apache.cassandra.stress.generate.PartitionIterator;
import org.apache.cassandra.stress.generate.RatioDistribution;
import org.apache.cassandra.stress.generate.RatioDistributionFactory;
import org.apache.cassandra.stress.generate.Seed;
import org.apache.cassandra.stress.generate.SeedManager;
import org.apache.cassandra.stress.report.Timer;
import org.apache.cassandra.stress.settings.OptionRatioDistribution;
import org.apache.cassandra.stress.settings.StressSettings;

public abstract class PartitionOperation
extends Operation {
    protected final DataSpec spec;
    private static final RatioDistribution defaultRowPopulationRatio = ((RatioDistributionFactory)OptionRatioDistribution.BUILDER.apply((Object)"fixed(1)/1")).get();
    private final List<PartitionIterator> partitionCache = new ArrayList<PartitionIterator>();
    protected List<PartitionIterator> partitions;

    public PartitionOperation(Timer timer, StressSettings settings, DataSpec spec) {
        super(timer, settings);
        this.spec = spec;
    }

    @Override
    public int ready(WorkManager permits) {
        int i;
        int partitionCount = (int)this.spec.partitionCount.next();
        if (partitionCount <= 0) {
            return 0;
        }
        if ((partitionCount = permits.takePermits(partitionCount)) <= 0) {
            return 0;
        }
        boolean success = true;
        for (i = 0; i < partitionCount && success; ++i) {
            Seed seed;
            if (i >= this.partitionCache.size()) {
                this.partitionCache.add(PartitionIterator.get(this.spec.partitionGenerator, this.spec.seedManager));
            }
            success = false;
            while (!success && (seed = this.spec.seedManager.next(this)) != null) {
                success = this.reset(seed, this.partitionCache.get(i));
            }
        }
        partitionCount = i;
        this.partitions = this.partitionCache.subList(0, partitionCount);
        return this.partitions.size();
    }

    protected boolean reset(Seed seed, PartitionIterator iterator) {
        if (this.spec.useRatio == null) {
            return iterator.reset(seed, this.spec.targetCount, this.spec.rowPopulationRatio.next(), this.isWrite());
        }
        return iterator.reset(seed, this.spec.useRatio.next(), this.spec.rowPopulationRatio.next(), this.isWrite());
    }

    @Override
    public String key() {
        ArrayList<String> keys = new ArrayList<String>();
        for (PartitionIterator partition : this.partitions) {
            keys.add(partition.getKeyAsString());
        }
        return ((Object)keys).toString();
    }

    public static final class DataSpec {
        public final PartitionGenerator partitionGenerator;
        final SeedManager seedManager;
        final Distribution partitionCount;
        final RatioDistribution useRatio;
        final RatioDistribution rowPopulationRatio;
        final Integer targetCount;

        public DataSpec(PartitionGenerator partitionGenerator, SeedManager seedManager, Distribution partitionCount, RatioDistribution rowPopulationRatio, Integer targetCount) {
            this(partitionGenerator, seedManager, partitionCount, null, rowPopulationRatio, targetCount);
        }

        public DataSpec(PartitionGenerator partitionGenerator, SeedManager seedManager, Distribution partitionCount, RatioDistribution useRatio, RatioDistribution rowPopulationRatio) {
            this(partitionGenerator, seedManager, partitionCount, useRatio, rowPopulationRatio, null);
        }

        private DataSpec(PartitionGenerator partitionGenerator, SeedManager seedManager, Distribution partitionCount, RatioDistribution useRatio, RatioDistribution rowPopulationRatio, Integer targetCount) {
            this.partitionGenerator = partitionGenerator;
            this.seedManager = seedManager;
            this.partitionCount = partitionCount;
            this.useRatio = useRatio;
            this.rowPopulationRatio = rowPopulationRatio == null ? defaultRowPopulationRatio : rowPopulationRatio;
            this.targetCount = targetCount;
        }
    }
}

