/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.ds.tree.trie;

import org.psjava.ds.tree.trie.TrieNode;
import org.psjava.ds.tree.trie.TrieNodeFactory;
import org.psjava.util.DataFilter;
import org.psjava.util.FilteredIterable;
import org.psjava.util.VarargsIterable;

public final class TrieNodeFactoryForBooleanKey {
    public static TrieNodeFactory<Boolean> getInstance() {
        return new TrieNodeFactory<Boolean>(){

            @Override
            public TrieNode<Boolean> create() {
                return new BooleanTrieNode();
            }
        };
    }

    private TrieNodeFactoryForBooleanKey() {
    }

    private static class BooleanTrieNode
    implements TrieNode<Boolean> {
        private TrieNode<Boolean> zero;
        private TrieNode<Boolean> one;

        private BooleanTrieNode() {
        }

        @Override
        public void putChild(Boolean ch, TrieNode<Boolean> node) {
            if (ch.booleanValue()) {
                this.one = node;
            } else {
                this.zero = node;
            }
        }

        @Override
        public boolean hasChild(Boolean ch) {
            return (ch != false ? this.one : this.zero) != null;
        }

        @Override
        public Iterable<Boolean> getEdges() {
            return FilteredIterable.create(VarargsIterable.create(false, true), new DataFilter<Boolean>(){

                @Override
                public boolean isAccepted(Boolean v) {
                    return BooleanTrieNode.this.hasChild(v);
                }
            });
        }

        @Override
        public int getChildCount() {
            return (this.one == null ? 0 : 1) + (this.zero == null ? 0 : 1);
        }

        @Override
        public TrieNode<Boolean> getChild(Boolean ch) {
            TrieNode<Boolean> cand = this.getChildOrNull(ch);
            if (cand == null) {
                throw new RuntimeException();
            }
            return cand;
        }

        @Override
        public TrieNode<Boolean> getChildOrNull(Boolean ch) {
            TrieNode<Boolean> candOrNull = ch != false ? this.one : this.zero;
            return candOrNull;
        }
    }
}

