/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.LongBinaryOperator;
import java.util.function.LongPredicate;
import java.util.function.LongUnaryOperator;
import org.agrona.BitUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;
import org.agrona.collections.LongLongConsumer;
import org.agrona.collections.LongLongFunction;
import org.agrona.collections.LongLongPredicate;

public class Long2LongHashMap
implements Map<Long, Long> {
    static final int MIN_CAPACITY = 8;
    private final float loadFactor;
    private final long missingValue;
    private int resizeThreshold;
    private int size = 0;
    private final boolean shouldAvoidAllocation;
    private long[] entries;
    private KeySet keySet;
    private ValueCollection values;
    private EntrySet entrySet;

    public Long2LongHashMap(long missingValue) {
        this(8, 0.65f, missingValue);
    }

    public Long2LongHashMap(int initialCapacity, float loadFactor, long missingValue) {
        this(initialCapacity, loadFactor, missingValue, true);
    }

    public Long2LongHashMap(int initialCapacity, float loadFactor, long missingValue, boolean shouldAvoidAllocation) {
        CollectionUtil.validateLoadFactor(loadFactor);
        this.loadFactor = loadFactor;
        this.missingValue = missingValue;
        this.shouldAvoidAllocation = shouldAvoidAllocation;
        this.capacity(BitUtil.findNextPositivePowerOfTwo(Math.max(8, initialCapacity)));
    }

    public long missingValue() {
        return this.missingValue;
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int capacity() {
        return this.entries.length >> 1;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size;
    }

    public long getOrDefault(long key, long defaultValue) {
        long value = this.get(key);
        return this.missingValue != value ? value : defaultValue;
    }

    public long get(long key) {
        long value;
        long missingValue = this.missingValue;
        long[] entries = this.entries;
        int mask = entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        while (missingValue != (value = entries[index + 1]) && key != entries[index]) {
            index = Long2LongHashMap.next(index, mask);
        }
        return value;
    }

    @Override
    public long put(long key, long value) {
        long oldValue;
        long missingValue = this.missingValue;
        if (missingValue == value) {
            throw new IllegalArgumentException("cannot accept missingValue");
        }
        long[] entries = this.entries;
        int mask = entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        while (missingValue != (oldValue = entries[index + 1]) && key != entries[index]) {
            index = Long2LongHashMap.next(index, mask);
        }
        if (missingValue == oldValue) {
            ++this.size;
            entries[index] = key;
        }
        entries[index + 1] = value;
        this.increaseCapacity();
        return oldValue;
    }

    @Override
    public long putIfAbsent(long key, long value) {
        long oldValue;
        long missingValue = this.missingValue;
        if (missingValue == value) {
            throw new IllegalArgumentException("cannot accept missingValue");
        }
        long[] entries = this.entries;
        int mask = entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        while (missingValue != (oldValue = entries[index + 1])) {
            if (key == entries[index]) {
                return oldValue;
            }
            index = Long2LongHashMap.next(index, mask);
        }
        ++this.size;
        entries[index] = key;
        entries[index + 1] = value;
        this.increaseCapacity();
        return oldValue;
    }

    private void increaseCapacity() {
        if (this.size > this.resizeThreshold) {
            int newCapacity = this.entries.length;
            this.rehash(newCapacity);
        }
    }

    private void rehash(int newCapacity) {
        long missingValue = this.missingValue;
        long[] oldEntries = this.entries;
        int length = oldEntries.length;
        this.capacity(newCapacity);
        long[] newEntries = this.entries;
        int mask = newEntries.length - 1;
        for (int keyIndex = 0; keyIndex < length; keyIndex += 2) {
            long value = oldEntries[keyIndex + 1];
            if (missingValue == value) continue;
            long key = oldEntries[keyIndex];
            int index = Hashing.evenHash(key, mask);
            while (missingValue != newEntries[index + 1]) {
                index = Long2LongHashMap.next(index, mask);
            }
            newEntries[index] = key;
            newEntries[index + 1] = value;
        }
    }

    @Deprecated
    public void longForEach(LongLongConsumer consumer) {
        this.forEachLong(consumer);
    }

    public void forEachLong(LongLongConsumer consumer) {
        Objects.requireNonNull(consumer);
        long missingValue = this.missingValue;
        long[] entries = this.entries;
        int length = entries.length;
        int remaining = this.size;
        for (int valueIndex = 1; remaining > 0 && valueIndex < length; valueIndex += 2) {
            if (missingValue == entries[valueIndex]) continue;
            consumer.accept(entries[valueIndex - 1], entries[valueIndex]);
            --remaining;
        }
    }

    public boolean containsKey(long key) {
        return this.missingValue != this.get(key);
    }

    public boolean containsValue(long value) {
        boolean found = false;
        long missingValue = this.missingValue;
        if (missingValue != value) {
            long[] entries = this.entries;
            int length = entries.length;
            int remaining = this.size;
            for (int valueIndex = 1; remaining > 0 && valueIndex < length; valueIndex += 2) {
                long existingValue = entries[valueIndex];
                if (missingValue == existingValue) continue;
                if (existingValue == value) {
                    found = true;
                    break;
                }
                --remaining;
            }
        }
        return found;
    }

    @Override
    public void clear() {
        if (this.size > 0) {
            Arrays.fill(this.entries, this.missingValue);
            this.size = 0;
        }
    }

    public void compact() {
        int idealCapacity = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(Math.max(8, idealCapacity)));
    }

    public long computeIfAbsent(long key, LongUnaryOperator mappingFunction) {
        long value;
        Objects.requireNonNull(mappingFunction);
        long missingValue = this.missingValue;
        long[] entries = this.entries;
        int mask = entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        while (missingValue != (value = entries[index + 1]) && key != entries[index]) {
            index = Long2LongHashMap.next(index, mask);
        }
        if (missingValue == value && missingValue != (value = mappingFunction.applyAsLong(key))) {
            entries[index] = key;
            entries[index + 1] = value;
            ++this.size;
            this.increaseCapacity();
        }
        return value;
    }

    public long computeIfPresent(long key, LongBinaryOperator remappingFunction) {
        long value;
        Objects.requireNonNull(remappingFunction);
        long missingValue = this.missingValue;
        long[] entries = this.entries;
        int mask = entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        while (missingValue != (value = entries[index + 1]) && key != entries[index]) {
            index = Long2LongHashMap.next(index, mask);
        }
        if (missingValue != value) {
            entries[index + 1] = value = remappingFunction.applyAsLong(key, value);
            if (value == missingValue) {
                --this.size;
                this.compactChain(index);
            }
        }
        return value;
    }

    public long compute(long key, LongBinaryOperator remappingFunction) {
        long oldValue;
        Objects.requireNonNull(remappingFunction);
        long missingValue = this.missingValue;
        long[] entries = this.entries;
        int mask = entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        while (missingValue != (oldValue = entries[index + 1]) && key != entries[index]) {
            index = Long2LongHashMap.next(index, mask);
        }
        long newValue = remappingFunction.applyAsLong(key, oldValue);
        if (missingValue != newValue) {
            entries[index + 1] = newValue;
            if (oldValue == missingValue) {
                entries[index] = key;
                ++this.size;
                this.increaseCapacity();
            }
        } else if (missingValue != oldValue) {
            entries[index + 1] = missingValue;
            --this.size;
            this.compactChain(index);
        }
        return newValue;
    }

    @Override
    public Long get(Object key) {
        return this.valOrNull(this.get((Long)key));
    }

    @Override
    public Long put(Long key, Long value) {
        return this.valOrNull(this.put((long)key, (long)value));
    }

    @Override
    public void forEach(BiConsumer<? super Long, ? super Long> action) {
        this.forEachLong(action::accept);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsKey((Long)key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.containsValue((Long)value);
    }

    @Override
    public void putAll(Map<? extends Long, ? extends Long> map) {
        for (Map.Entry<? extends Long, ? extends Long> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public void putAll(Long2LongHashMap map) {
        EntryIterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            it.findNext();
            this.put(it.getLongKey(), it.getLongValue());
        }
    }

    @Override
    public Long putIfAbsent(Long key, Long value) {
        return this.valOrNull(this.putIfAbsent((long)key, (long)value));
    }

    @Override
    public Long replace(Long key, Long value) {
        return this.valOrNull(this.replace((long)key, (long)value));
    }

    @Override
    public boolean replace(Long key, Long oldValue, Long newValue) {
        return this.replace((long)key, (long)oldValue, (long)newValue);
    }

    @Override
    public void replaceAll(BiFunction<? super Long, ? super Long, ? extends Long> function) {
        this.replaceAllLong(function::apply);
    }

    public KeySet keySet() {
        if (null == this.keySet) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public ValueCollection values() {
        if (null == this.values) {
            this.values = new ValueCollection();
        }
        return this.values;
    }

    public EntrySet entrySet() {
        if (null == this.entrySet) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    public Long remove(Object key) {
        return this.valOrNull(this.remove((Long)key));
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.remove((Long)key, (Long)value);
    }

    public long remove(long key) {
        long oldValue;
        long missingValue = this.missingValue;
        long[] entries = this.entries;
        int mask = entries.length - 1;
        int keyIndex = Hashing.evenHash(key, mask);
        while (missingValue != (oldValue = entries[keyIndex + 1])) {
            if (key == entries[keyIndex]) {
                entries[keyIndex + 1] = missingValue;
                --this.size;
                this.compactChain(keyIndex);
                break;
            }
            keyIndex = Long2LongHashMap.next(keyIndex, mask);
        }
        return oldValue;
    }

    public boolean remove(long key, long value) {
        long oldValue;
        long missingValue = this.missingValue;
        long[] entries = this.entries;
        int mask = entries.length - 1;
        int keyIndex = Hashing.evenHash(key, mask);
        while (missingValue != (oldValue = entries[keyIndex + 1])) {
            if (key == entries[keyIndex]) {
                if (value != oldValue) break;
                entries[keyIndex + 1] = missingValue;
                --this.size;
                this.compactChain(keyIndex);
                return true;
            }
            keyIndex = Long2LongHashMap.next(keyIndex, mask);
        }
        return false;
    }

    public long merge(long key, long value, LongLongFunction remappingFunction) {
        long newValue;
        long oldValue;
        Objects.requireNonNull(remappingFunction);
        long missingValue = this.missingValue;
        if (missingValue == value) {
            throw new IllegalArgumentException("cannot accept missingValue");
        }
        long[] entries = this.entries;
        int mask = entries.length - 1;
        int index = Hashing.evenHash(key, mask);
        while (missingValue != (oldValue = entries[index + 1]) && key != entries[index]) {
            index = Long2LongHashMap.next(index, mask);
        }
        long l = newValue = missingValue == oldValue ? value : remappingFunction.apply(oldValue, value);
        if (missingValue != newValue) {
            entries[index + 1] = newValue;
            if (oldValue == missingValue) {
                entries[index] = key;
                ++this.size;
                this.increaseCapacity();
            }
        } else {
            entries[index + 1] = missingValue;
            --this.size;
            this.compactChain(index);
        }
        return newValue;
    }

    private void compactChain(int deleteKeyIndex) {
        long value;
        long missingValue = this.missingValue;
        long[] entries = this.entries;
        int mask = entries.length - 1;
        int keyIndex = deleteKeyIndex;
        while (missingValue != (value = entries[(keyIndex = Long2LongHashMap.next(keyIndex, mask)) + 1])) {
            long key = entries[keyIndex];
            int hash = Hashing.evenHash(key, mask);
            if ((keyIndex >= hash || hash > deleteKeyIndex && deleteKeyIndex > keyIndex) && (hash > deleteKeyIndex || deleteKeyIndex > keyIndex)) continue;
            entries[deleteKeyIndex] = key;
            entries[deleteKeyIndex + 1] = value;
            entries[keyIndex + 1] = missingValue;
            deleteKeyIndex = keyIndex;
        }
    }

    public long minValue() {
        long missingValue = this.missingValue;
        long min = 0 == this.size ? missingValue : Long.MAX_VALUE;
        long[] entries = this.entries;
        int length = entries.length;
        for (int valueIndex = 1; valueIndex < length; valueIndex += 2) {
            long value = entries[valueIndex];
            if (missingValue == value) continue;
            min = Math.min(min, value);
        }
        return min;
    }

    public long maxValue() {
        long missingValue = this.missingValue;
        long max = 0 == this.size ? missingValue : Long.MIN_VALUE;
        long[] entries = this.entries;
        int length = entries.length;
        for (int valueIndex = 1; valueIndex < length; valueIndex += 2) {
            long value = entries[valueIndex];
            if (missingValue == value) continue;
            max = Math.max(max, value);
        }
        return max;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        EntryIterator entryIterator = new EntryIterator();
        entryIterator.reset();
        StringBuilder sb = new StringBuilder().append('{');
        while (true) {
            entryIterator.next();
            sb.append(entryIterator.getLongKey()).append('=').append(entryIterator.getLongValue());
            if (!entryIterator.hasNext()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public long replace(long key, long value) {
        long oldValue;
        long missingValue = this.missingValue;
        long[] entries = this.entries;
        int mask = entries.length - 1;
        int keyIndex = Hashing.evenHash(key, mask);
        while (missingValue != (oldValue = entries[keyIndex + 1])) {
            if (key == entries[keyIndex]) {
                entries[keyIndex + 1] = value;
                break;
            }
            keyIndex = Long2LongHashMap.next(keyIndex, mask);
        }
        return oldValue;
    }

    @Override
    public boolean replace(long key, long oldValue, long newValue) {
        long value;
        long missingValue = this.missingValue;
        long[] entries = this.entries;
        int mask = entries.length - 1;
        int keyIndex = Hashing.evenHash(key, mask);
        while (missingValue != (value = entries[keyIndex + 1])) {
            if (key == entries[keyIndex]) {
                if (oldValue != value) break;
                entries[keyIndex + 1] = newValue;
                return true;
            }
            keyIndex = Long2LongHashMap.next(keyIndex, mask);
        }
        return false;
    }

    public void replaceAllLong(LongLongFunction function) {
        Objects.requireNonNull(function);
        long missingValue = this.missingValue;
        long[] entries = this.entries;
        int length = entries.length;
        int remaining = this.size;
        for (int valueIndex = 1; remaining > 0 && valueIndex < length; valueIndex += 2) {
            long existingValue = entries[valueIndex];
            if (missingValue == existingValue) continue;
            long newValue = function.apply(entries[valueIndex - 1], existingValue);
            if (missingValue == newValue) {
                throw new IllegalArgumentException("cannot replace with a missingValue");
            }
            entries[valueIndex] = newValue;
            --remaining;
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map that = (Map)o;
        return this.size == that.size() && this.entrySet().equals(that.entrySet());
    }

    @Override
    public int hashCode() {
        return this.entrySet().hashCode();
    }

    private static int next(int index, int mask) {
        return index + 2 & mask;
    }

    private void capacity(int newCapacity) {
        int entriesLength = newCapacity * 2;
        if (entriesLength < 0) {
            throw new IllegalStateException("max capacity reached at size=" + this.size);
        }
        this.resizeThreshold = (int)((float)newCapacity * this.loadFactor);
        this.entries = new long[entriesLength];
        Arrays.fill(this.entries, this.missingValue);
    }

    private Long valOrNull(long value) {
        return this.missingValue == value ? null : Long.valueOf(value);
    }

    public final class EntrySet
    extends AbstractSet<Map.Entry<Long, Long>> {
        private final EntryIterator entryIterator;

        public EntrySet() {
            this.entryIterator = Long2LongHashMap.this.shouldAvoidAllocation ? new EntryIterator() : null;
        }

        public EntryIterator iterator() {
            EntryIterator entryIterator = this.entryIterator;
            if (null == entryIterator) {
                entryIterator = new EntryIterator();
            }
            entryIterator.reset();
            return entryIterator;
        }

        @Override
        public int size() {
            return Long2LongHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return Long2LongHashMap.this.isEmpty();
        }

        @Override
        public void clear() {
            Long2LongHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Long value = Long2LongHashMap.this.get(entry.getKey());
            return value != null && value.equals(entry.getValue());
        }

        public boolean removeIfLong(LongLongPredicate filter) {
            boolean removed = false;
            EntryIterator iterator = this.iterator();
            while (iterator.hasNext()) {
                iterator.findNext();
                if (!filter.test(iterator.getLongKey(), iterator.getLongValue())) continue;
                iterator.remove();
                removed = true;
            }
            return removed;
        }

        @Override
        public Object[] toArray() {
            return this.toArray(new Object[this.size()]);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            T[] array = a.length >= Long2LongHashMap.this.size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), Long2LongHashMap.this.size);
            EntryIterator it = this.iterator();
            for (int i = 0; i < array.length; ++i) {
                if (!it.hasNext()) {
                    array[i] = null;
                    break;
                }
                it.next();
                array[i] = it.allocateDuplicateEntry();
            }
            return array;
        }
    }

    public final class ValueCollection
    extends AbstractCollection<Long> {
        private final ValueIterator valueIterator;

        public ValueCollection() {
            this.valueIterator = Long2LongHashMap.this.shouldAvoidAllocation ? new ValueIterator() : null;
        }

        public ValueIterator iterator() {
            ValueIterator valueIterator = this.valueIterator;
            if (null == valueIterator) {
                valueIterator = new ValueIterator();
            }
            valueIterator.reset();
            return valueIterator;
        }

        @Override
        public int size() {
            return Long2LongHashMap.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return this.contains((Long)o);
        }

        public boolean contains(long value) {
            return Long2LongHashMap.this.containsValue(value);
        }

        public boolean removeIfLong(LongPredicate filter) {
            boolean removed = false;
            ValueIterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (!filter.test(iterator.nextValue())) continue;
                iterator.remove();
                removed = true;
            }
            return removed;
        }
    }

    public final class KeySet
    extends AbstractSet<Long> {
        private final KeyIterator keyIterator;

        public KeySet() {
            this.keyIterator = Long2LongHashMap.this.shouldAvoidAllocation ? new KeyIterator() : null;
        }

        public KeyIterator iterator() {
            KeyIterator keyIterator = this.keyIterator;
            if (null == keyIterator) {
                keyIterator = new KeyIterator();
            }
            keyIterator.reset();
            return keyIterator;
        }

        @Override
        public int size() {
            return Long2LongHashMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return Long2LongHashMap.this.isEmpty();
        }

        @Override
        public void clear() {
            Long2LongHashMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            return this.contains((Long)o);
        }

        public boolean contains(long key) {
            return Long2LongHashMap.this.containsKey(key);
        }

        public boolean removeIfLong(LongPredicate filter) {
            boolean removed = false;
            KeyIterator iterator = this.iterator();
            while (iterator.hasNext()) {
                if (!filter.test(iterator.nextValue())) continue;
                iterator.remove();
                removed = true;
            }
            return removed;
        }
    }

    public final class EntryIterator
    extends AbstractIterator
    implements Iterator<Map.Entry<Long, Long>>,
    Map.Entry<Long, Long> {
        @Override
        public Long getKey() {
            return this.getLongKey();
        }

        public long getLongKey() {
            return Long2LongHashMap.this.entries[this.keyPosition()];
        }

        @Override
        public Long getValue() {
            return this.getLongValue();
        }

        public long getLongValue() {
            return Long2LongHashMap.this.entries[this.keyPosition() + 1];
        }

        @Override
        public Long setValue(Long value) {
            return this.setValue((long)value);
        }

        @Override
        public long setValue(long value) {
            if (!this.isPositionValid) {
                throw new IllegalStateException();
            }
            if (Long2LongHashMap.this.missingValue == value) {
                throw new IllegalArgumentException("cannot accept missingValue");
            }
            int keyPosition = this.keyPosition();
            long[] entries = Long2LongHashMap.this.entries;
            long prevValue = entries[keyPosition + 1];
            entries[keyPosition + 1] = value;
            return prevValue;
        }

        @Override
        public Map.Entry<Long, Long> next() {
            this.findNext();
            if (Long2LongHashMap.this.shouldAvoidAllocation) {
                return this;
            }
            return this.allocateDuplicateEntry();
        }

        private Map.Entry<Long, Long> allocateDuplicateEntry() {
            return new MapEntry(this.getLongKey(), this.getLongValue());
        }

        @Override
        public int hashCode() {
            return Long.hashCode(this.getLongKey()) ^ Long.hashCode(this.getLongValue());
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry that = (Map.Entry)o;
            return Objects.equals(this.getKey(), that.getKey()) && Objects.equals(this.getValue(), that.getValue());
        }

        public final class MapEntry
        implements Map.Entry<Long, Long> {
            private final long k;
            private final long v;

            public MapEntry(long k, long v) {
                this.k = k;
                this.v = v;
            }

            @Override
            public Long getKey() {
                return this.k;
            }

            @Override
            public Long getValue() {
                return this.v;
            }

            @Override
            public Long setValue(Long value) {
                return Long2LongHashMap.this.put(this.k, (long)value);
            }

            @Override
            public int hashCode() {
                return Long.hashCode(EntryIterator.this.getLongKey()) ^ Long.hashCode(EntryIterator.this.getLongValue());
            }

            @Override
            public boolean equals(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry e = (Map.Entry)o;
                return e.getKey() != null && e.getValue() != null && e.getKey().equals(this.k) && e.getValue().equals(this.v);
            }

            public String toString() {
                return this.k + "=" + this.v;
            }
        }
    }

    public final class ValueIterator
    extends AbstractIterator
    implements Iterator<Long> {
        @Override
        public Long next() {
            return this.nextValue();
        }

        public long nextValue() {
            this.findNext();
            return Long2LongHashMap.this.entries[this.keyPosition() + 1];
        }
    }

    public final class KeyIterator
    extends AbstractIterator
    implements Iterator<Long> {
        @Override
        public Long next() {
            return this.nextValue();
        }

        public long nextValue() {
            this.findNext();
            return Long2LongHashMap.this.entries[this.keyPosition()];
        }
    }

    abstract class AbstractIterator {
        protected boolean isPositionValid = false;
        private int remaining;
        private int positionCounter;
        private int stopCounter;

        AbstractIterator() {
        }

        final void reset() {
            int capacity;
            this.isPositionValid = false;
            this.remaining = Long2LongHashMap.this.size;
            long missingValue = Long2LongHashMap.this.missingValue;
            long[] entries = Long2LongHashMap.this.entries;
            int keyIndex = capacity = entries.length;
            if (missingValue != entries[capacity - 1]) {
                for (int i = 1; i < capacity; i += 2) {
                    if (missingValue != entries[i]) continue;
                    keyIndex = i - 1;
                    break;
                }
            }
            this.stopCounter = keyIndex;
            this.positionCounter = keyIndex + capacity;
        }

        protected final int keyPosition() {
            return this.positionCounter & Long2LongHashMap.this.entries.length - 1;
        }

        public int remaining() {
            return this.remaining;
        }

        public boolean hasNext() {
            return this.remaining > 0;
        }

        protected final void findNext() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            long[] entries = Long2LongHashMap.this.entries;
            long missingValue = Long2LongHashMap.this.missingValue;
            int mask = entries.length - 1;
            int stop = this.stopCounter;
            for (int keyIndex = this.positionCounter - 2; keyIndex >= stop; keyIndex -= 2) {
                int index = keyIndex & mask;
                if (missingValue == entries[index + 1]) continue;
                this.isPositionValid = true;
                this.positionCounter = keyIndex;
                --this.remaining;
                return;
            }
            this.isPositionValid = false;
            throw new IllegalStateException();
        }

        public void remove() {
            if (!this.isPositionValid) {
                throw new IllegalStateException();
            }
            int position = this.keyPosition();
            ((Long2LongHashMap)Long2LongHashMap.this).entries[position + 1] = Long2LongHashMap.this.missingValue;
            --Long2LongHashMap.this.size;
            Long2LongHashMap.this.compactChain(position);
            this.isPositionValid = false;
        }
    }
}

