/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.gms;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;

public class GossipShutdown {
    public static final Serializer serializer = new Serializer();
    public final EndpointState state;

    public GossipShutdown(EndpointState state) {
        this.state = state;
    }

    public static final class Serializer
    implements IVersionedSerializer<Object> {
        @Override
        public void serialize(Object t, DataOutputPlus out, int version) throws IOException {
            if (version < 13) {
                return;
            }
            GossipShutdown shutdown = (GossipShutdown)t;
            EndpointState.serializer.serialize(shutdown.state, out, version);
        }

        @Override
        @Nullable
        public Object deserialize(DataInputPlus in, int version) throws IOException {
            if (version < 13) {
                return null;
            }
            return new GossipShutdown((EndpointState)EndpointState.serializer.deserialize(in, version));
        }

        @Override
        public long serializedSize(Object t, int version) {
            if (version < 13) {
                return 0L;
            }
            GossipShutdown shutdown = (GossipShutdown)t;
            return EndpointState.serializer.serializedSize(shutdown.state, version);
        }
    }
}

