/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.index.sai.disk.v1.bbtree;

import java.nio.ByteBuffer;
import org.apache.cassandra.index.sai.disk.v1.bbtree.BlockBalancedTreeReader;
import org.apache.cassandra.index.sai.plan.Expression;
import org.apache.cassandra.index.sai.utils.IndexTermType;
import org.apache.cassandra.utils.ByteArrayUtil;
import org.apache.lucene.index.PointValues;

public class BlockBalancedTreeQueries {
    private static final BlockBalancedTreeReader.IntersectVisitor MATCH_ALL = new BlockBalancedTreeReader.IntersectVisitor(){

        @Override
        public boolean contains(byte[] packedValue) {
            return true;
        }

        @Override
        public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
            return PointValues.Relation.CELL_INSIDE_QUERY;
        }
    };

    public static BlockBalancedTreeReader.IntersectVisitor balancedTreeQueryFrom(Expression expression, int bytesPerValue) {
        if (expression.lower() == null && expression.upper() == null) {
            return MATCH_ALL;
        }
        Bound lower = null;
        if (expression.lower() != null) {
            byte[] lowerBound = BlockBalancedTreeQueries.toComparableBytes(bytesPerValue, expression.lower().value.encoded, expression.getIndexTermType());
            lower = new Bound(lowerBound, !expression.lower().inclusive);
        }
        Bound upper = null;
        if (expression.upper() != null) {
            byte[] upperBound = BlockBalancedTreeQueries.toComparableBytes(bytesPerValue, expression.upper().value.encoded, expression.getIndexTermType());
            upper = new Bound(upperBound, !expression.upper().inclusive);
        }
        return new RangeQueryVisitor(lower, upper);
    }

    private static byte[] toComparableBytes(int bytesPerDim, ByteBuffer value, IndexTermType indexTermType) {
        byte[] buffer = new byte[indexTermType.fixedSizeOf()];
        assert (buffer.length == bytesPerDim);
        indexTermType.toComparableBytes(value, buffer);
        return buffer;
    }

    private static class RangeQueryVisitor
    implements BlockBalancedTreeReader.IntersectVisitor {
        private final Bound lower;
        private final Bound upper;

        private RangeQueryVisitor(Bound lower, Bound upper) {
            this.lower = lower;
            this.upper = upper;
        }

        @Override
        public boolean contains(byte[] packedValue) {
            if (this.lower != null && this.lower.greaterThan(packedValue)) {
                return false;
            }
            if (this.upper != null) {
                return !this.upper.smallerThan(packedValue);
            }
            return true;
        }

        @Override
        public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
            boolean crosses = false;
            if (this.lower != null) {
                if (this.lower.greaterThan(maxPackedValue)) {
                    return PointValues.Relation.CELL_OUTSIDE_QUERY;
                }
                crosses = this.lower.greaterThan(minPackedValue);
            }
            if (this.upper != null) {
                if (this.upper.smallerThan(minPackedValue)) {
                    return PointValues.Relation.CELL_OUTSIDE_QUERY;
                }
                crosses |= this.upper.smallerThan(maxPackedValue);
            }
            return crosses ? PointValues.Relation.CELL_CROSSES_QUERY : PointValues.Relation.CELL_INSIDE_QUERY;
        }
    }

    private static class Bound {
        private final byte[] bound;
        private final boolean exclusive;

        Bound(byte[] bound, boolean exclusive) {
            this.bound = bound;
            this.exclusive = exclusive;
        }

        boolean smallerThan(byte[] packedValue) {
            int cmp = this.compareTo(packedValue);
            return cmp < 0 || cmp == 0 && this.exclusive;
        }

        boolean greaterThan(byte[] packedValue) {
            int cmp = this.compareTo(packedValue);
            return cmp > 0 || cmp == 0 && this.exclusive;
        }

        private int compareTo(byte[] packedValue) {
            return ByteArrayUtil.compareUnsigned(this.bound, 0, packedValue, 0, this.bound.length);
        }
    }
}

