/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import com.google.common.annotations.VisibleForTesting;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.cassandra.config.CassandraRelevantProperties;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.locator.InetAddressAndPort;
import org.apache.cassandra.locator.SeedProvider;
import org.apache.cassandra.utils.FBUtilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSeedProvider
implements SeedProvider {
    private static final Logger logger = LoggerFactory.getLogger(SimpleSeedProvider.class);
    @VisibleForTesting
    public static final String SEEDS_KEY = "seeds";
    @VisibleForTesting
    public static final String RESOLVE_MULTIPLE_IP_ADDRESSES_PER_DNS_RECORD_KEY = "resolve_multiple_ip_addresses_per_dns_record";
    private static final int SEED_COUNT_WARN_THRESHOLD = CassandraRelevantProperties.SEED_COUNT_WARN_THRESHOLD.getInt(20);
    private final String[] defaultSeeds = new String[]{FBUtilities.getLocalAddressAndPort().getHostAddress(true)};

    public SimpleSeedProvider(Map<String, String> args) {
    }

    @Override
    public List<InetAddressAndPort> getSeeds() {
        String[] hosts;
        boolean resolveMultipleIps;
        Config conf;
        try {
            conf = DatabaseDescriptor.loadConfig();
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        assert (conf.seed_provider != null) : "conf.seed_provider is null!";
        Map<String, String> parameters = conf.seed_provider.parameters;
        if (parameters == null) {
            resolveMultipleIps = false;
            hosts = this.defaultSeeds;
        } else {
            hosts = parameters.getOrDefault(SEEDS_KEY, this.defaultSeeds[0]).split(",", -1);
            resolveMultipleIps = Boolean.parseBoolean(parameters.getOrDefault(RESOLVE_MULTIPLE_IP_ADDRESSES_PER_DNS_RECORD_KEY, Boolean.FALSE.toString()));
        }
        ArrayList<InetAddressAndPort> seeds = new ArrayList<InetAddressAndPort>(hosts.length);
        for (String host : hosts) {
            try {
                if (host.trim().isEmpty()) continue;
                if (resolveMultipleIps) {
                    List<InetAddressAndPort> resolvedSeeds = InetAddressAndPort.getAllByName(host.trim());
                    seeds.addAll(resolvedSeeds);
                    logger.debug("{} resolves to {}", (Object)host, resolvedSeeds);
                    continue;
                }
                InetAddressAndPort addressAndPort = InetAddressAndPort.getByName(host.trim());
                seeds.add(addressAndPort);
                logger.debug("Only resolving one IP per DNS record - {} resolves to {}", (Object)host, (Object)addressAndPort);
            }
            catch (UnknownHostException ex) {
                logger.warn("Seed provider couldn't lookup host {}", (Object)host);
            }
        }
        if (seeds.size() > SEED_COUNT_WARN_THRESHOLD) {
            logger.warn("Seed provider returned more than {} seeds. A large seed list may impact effectiveness of the third gossip round.", (Object)SEED_COUNT_WARN_THRESHOLD);
        }
        return Collections.unmodifiableList(seeds);
    }
}

