/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.metrics;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.github.benmanes.caffeine.cache.stats.StatsCounter;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.apache.cassandra.sidecar.metrics.DeltaGauge;
import org.apache.cassandra.sidecar.metrics.NamedMetric;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

public class CacheStatsCounter
implements StatsCounter {
    public static final String CACHE_PREFIX = "Sidecar.Cache";
    protected final MetricRegistry metricRegistry;
    protected final NamedMetric<DeltaGauge> hits;
    protected final NamedMetric<DeltaGauge> misses;
    protected final NamedMetric<Timer> loadSuccess;
    protected final NamedMetric<Timer> loadFailure;
    protected final NamedMetric<DeltaGauge> evictions;
    protected final LongAdder totalLoadTimeNanos = new LongAdder();

    public CacheStatsCounter(MetricRegistry metricRegistry, String cacheName) {
        this.metricRegistry = Objects.requireNonNull(metricRegistry, "Metric registry can not be null");
        String domain = "Sidecar.Cache." + cacheName;
        this.hits = NamedMetric.builder(name -> (DeltaGauge)metricRegistry.gauge(name, DeltaGauge::new)).withDomain(domain).withName("Hits").build();
        this.misses = NamedMetric.builder(name -> (DeltaGauge)metricRegistry.gauge(name, DeltaGauge::new)).withDomain(domain).withName("Misses").build();
        this.loadSuccess = NamedMetric.builder(arg_0 -> ((MetricRegistry)metricRegistry).timer(arg_0)).withDomain(domain).withName("LoadSuccess").build();
        this.loadFailure = NamedMetric.builder(arg_0 -> ((MetricRegistry)metricRegistry).timer(arg_0)).withDomain(domain).withName("LoadFailure").build();
        this.evictions = NamedMetric.builder(name -> (DeltaGauge)metricRegistry.gauge(name, DeltaGauge::new)).withDomain(domain).withName("Evictions").build();
    }

    public void recordHits(@NonNegative int count) {
        ((DeltaGauge)this.hits.metric).update(count);
    }

    public void recordMisses(@NonNegative int count) {
        ((DeltaGauge)this.misses.metric).update(count);
    }

    public void recordLoadSuccess(@NonNegative long loadTime) {
        ((Timer)this.loadSuccess.metric).update(loadTime, TimeUnit.NANOSECONDS);
        this.totalLoadTimeNanos.add(loadTime);
    }

    public void recordLoadFailure(@NonNegative long loadTime) {
        ((Timer)this.loadFailure.metric).update(loadTime, TimeUnit.NANOSECONDS);
        this.totalLoadTimeNanos.add(loadTime);
    }

    public void recordEviction() {
        this.recordEviction(1);
    }

    @Deprecated
    public void recordEviction(int weight) {
        ((DeltaGauge)this.evictions.metric).update(weight);
    }

    public @NonNull CacheStats snapshot() {
        return CacheStats.of((long)((DeltaGauge)this.hits.metric).getValue(), (long)((DeltaGauge)this.misses.metric).getValue(), (long)((Timer)this.loadSuccess.metric).getCount(), (long)((Timer)this.loadFailure.metric).getCount(), (long)this.totalLoadTimeNanos.sum(), (long)((DeltaGauge)this.evictions.metric).getValue(), (long)0L);
    }

    public String toString() {
        return this.snapshot().toString();
    }
}

