//Licensed to the Apache Software Foundation (ASF) under one
//or more contributor license agreements.  See the NOTICE file
//distributed with this work for additional information
//regarding copyright ownership.  The ASF licenses this file
//to you under the Apache License, Version 2.0 (the
//"License"); you may not use this file except in compliance
//with the License.  You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing,
//software distributed under the License is distributed on an
//"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
//KIND, either express or implied.  See the License for the
//specific language governing permissions and limitations
//under the License.
package org.apache.cloudstack.api.response;

import com.cloud.serializer.Param;
import com.google.gson.annotations.SerializedName;

import org.apache.cloudstack.api.BaseResponse;

import java.math.BigDecimal;
import java.util.Date;

public class QuotaCreditsResponse extends BaseResponse {

    @SerializedName("credit")
    @Param(description = "The credit deposited.")
    private BigDecimal credit;

    @SerializedName("creditoruserid")
    @Param(description = "ID of the creditor user.")
    private String creditorUserId;

    @SerializedName("creditorusername")
    @Param(description = "Username of the creditor user.")
    private String creditorUsername;

    @SerializedName("creditedon")
    @Param(description = "When the credit was added.")
    private Date creditedOn;

    @SerializedName("currency")
    @Param(description = "Credit's currency.")
    private String currency;

    public BigDecimal getCredit() {
        return credit;
    }

    public void setCredit(BigDecimal credit) {
        this.credit = credit;
    }

    public String getCreditorUserId() {
        return creditorUserId;
    }

    public void setCreditorUserId(String creditorUserId) {
        this.creditorUserId = creditorUserId;
    }

    public String getCreditorUsername() {
        return creditorUsername;
    }

    public void setCreditorUsername(String creditorUsername) {
        this.creditorUsername = creditorUsername;
    }

    public Date getCreditedOn() {
        return creditedOn;
    }

    public void setCreditedOn(Date creditedOn) {
        this.creditedOn = creditedOn;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }
}
