/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model;

import java.util.Locale;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.Variables;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.NodePointerFactory;
import org.apache.commons.jxpath.ri.model.VariablePointer;

public class VariablePointerFactory
implements NodePointerFactory {
    public static final int VARIABLE_POINTER_FACTORY_ORDER = 890;

    public static VariableContextWrapper contextWrapper(JXPathContext context) {
        return new VariableContextWrapper(context);
    }

    @Override
    public NodePointer createNodePointer(NodePointer parent, QName qName, Object object) {
        return this.createNodePointer(qName, object, null);
    }

    @Override
    public NodePointer createNodePointer(QName qName, Object object, Locale locale) {
        if (object instanceof VariableContextWrapper) {
            for (JXPathContext varCtx = ((VariableContextWrapper)object).getContext(); varCtx != null; varCtx = varCtx.getParentContext()) {
                Variables vars = varCtx.getVariables();
                if (!vars.isDeclaredVariable(qName.toString())) continue;
                return new VariablePointer(vars, qName);
            }
            return new VariablePointer(qName);
        }
        return null;
    }

    @Override
    public int getOrder() {
        return 890;
    }

    public static final class VariableContextWrapper {
        private final JXPathContext context;

        private VariableContextWrapper(JXPathContext context) {
            this.context = context;
        }

        public JXPathContext getContext() {
            return this.context;
        }
    }
}

