/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import org.apache.commons.text.similarity.LevenshteinDistance;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class LevenshteinDistanceTest {
    private static final LevenshteinDistance UNLIMITED_DISTANCE = new LevenshteinDistance();

    @Test
    public void testGetLevenshteinDistance_StringString() {
        Assertions.assertThat((Integer)UNLIMITED_DISTANCE.apply((CharSequence)"", (CharSequence)"")).isEqualTo(0);
        Assertions.assertThat((Integer)UNLIMITED_DISTANCE.apply((CharSequence)"", (CharSequence)"a")).isEqualTo(1);
        Assertions.assertThat((Integer)UNLIMITED_DISTANCE.apply((CharSequence)"aaapppp", (CharSequence)"")).isEqualTo(7);
        Assertions.assertThat((Integer)UNLIMITED_DISTANCE.apply((CharSequence)"frog", (CharSequence)"fog")).isEqualTo(1);
        Assertions.assertThat((Integer)UNLIMITED_DISTANCE.apply((CharSequence)"fly", (CharSequence)"ant")).isEqualTo(3);
        Assertions.assertThat((Integer)UNLIMITED_DISTANCE.apply((CharSequence)"elephant", (CharSequence)"hippo")).isEqualTo(7);
        Assertions.assertThat((Integer)UNLIMITED_DISTANCE.apply((CharSequence)"hippo", (CharSequence)"elephant")).isEqualTo(7);
        Assertions.assertThat((Integer)UNLIMITED_DISTANCE.apply((CharSequence)"hippo", (CharSequence)"zzzzzzzz")).isEqualTo(8);
        Assertions.assertThat((Integer)UNLIMITED_DISTANCE.apply((CharSequence)"zzzzzzzz", (CharSequence)"hippo")).isEqualTo(8);
        Assertions.assertThat((Integer)UNLIMITED_DISTANCE.apply((CharSequence)"hello", (CharSequence)"hallo")).isEqualTo(1);
    }

    @Test
    public void testGetLevenshteinDistance_NullString() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> UNLIMITED_DISTANCE.apply((CharSequence)"a", null));
    }

    @Test
    public void testGetLevenshteinDistance_StringNull() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> UNLIMITED_DISTANCE.apply(null, (CharSequence)"a"));
    }

    @Test
    public void testGetLevenshteinDistance_StringStringInt() {
        Assertions.assertThat((Integer)new LevenshteinDistance(Integer.valueOf(0)).apply((CharSequence)"", (CharSequence)"")).isEqualTo(0);
        Assertions.assertThat((Integer)new LevenshteinDistance(Integer.valueOf(8)).apply((CharSequence)"aaapppp", (CharSequence)"")).isEqualTo(7);
        Assertions.assertThat((Integer)new LevenshteinDistance(Integer.valueOf(7)).apply((CharSequence)"aaapppp", (CharSequence)"")).isEqualTo(7);
        Assertions.assertThat((Integer)new LevenshteinDistance(Integer.valueOf(6)).apply((CharSequence)"aaapppp", (CharSequence)"")).isEqualTo(-1);
        Assertions.assertThat((Integer)new LevenshteinDistance(Integer.valueOf(0)).apply((CharSequence)"b", (CharSequence)"a")).isEqualTo(-1);
        Assertions.assertThat((Integer)new LevenshteinDistance(Integer.valueOf(0)).apply((CharSequence)"a", (CharSequence)"b")).isEqualTo(-1);
        Assertions.assertThat((Integer)new LevenshteinDistance(Integer.valueOf(0)).apply((CharSequence)"aa", (CharSequence)"aa")).isEqualTo(0);
        Assertions.assertThat((Integer)new LevenshteinDistance(Integer.valueOf(2)).apply((CharSequence)"aa", (CharSequence)"aa")).isEqualTo(0);
        Assertions.assertThat((Integer)new LevenshteinDistance(Integer.valueOf(2)).apply((CharSequence)"aaa", (CharSequence)"bbb")).isEqualTo(-1);
        Assertions.assertThat((Integer)new LevenshteinDistance(Integer.valueOf(3)).apply((CharSequence)"aaa", (CharSequence)"bbb")).isEqualTo(3);
        Assertions.assertThat((Integer)new LevenshteinDistance(Integer.valueOf(10)).apply((CharSequence)"aaaaaa", (CharSequence)"b")).isEqualTo(6);
        Assertions.assertThat((Integer)new LevenshteinDistance(Integer.valueOf(8)).apply((CharSequence)"aaapppp", (CharSequence)"b")).isEqualTo(7);
        Assertions.assertThat((Integer)new LevenshteinDistance(Integer.valueOf(4)).apply((CharSequence)"a", (CharSequence)"bbb")).isEqualTo(3);
        Assertions.assertThat((Integer)new LevenshteinDistance(Integer.valueOf(7)).apply((CharSequence)"aaapppp", (CharSequence)"b")).isEqualTo(7);
        Assertions.assertThat((Integer)new LevenshteinDistance(Integer.valueOf(3)).apply((CharSequence)"a", (CharSequence)"bbb")).isEqualTo(3);
        Assertions.assertThat((Integer)new LevenshteinDistance(Integer.valueOf(2)).apply((CharSequence)"a", (CharSequence)"bbb")).isEqualTo(-1);
        Assertions.assertThat((Integer)new LevenshteinDistance(Integer.valueOf(2)).apply((CharSequence)"bbb", (CharSequence)"a")).isEqualTo(-1);
        Assertions.assertThat((Integer)new LevenshteinDistance(Integer.valueOf(6)).apply((CharSequence)"aaapppp", (CharSequence)"b")).isEqualTo(-1);
        Assertions.assertThat((Integer)new LevenshteinDistance(Integer.valueOf(1)).apply((CharSequence)"a", (CharSequence)"bbb")).isEqualTo(-1);
        Assertions.assertThat((Integer)new LevenshteinDistance(Integer.valueOf(1)).apply((CharSequence)"bbb", (CharSequence)"a")).isEqualTo(-1);
        Assertions.assertThat((Integer)new LevenshteinDistance(Integer.valueOf(1)).apply((CharSequence)"12345", (CharSequence)"1234567")).isEqualTo(-1);
        Assertions.assertThat((Integer)new LevenshteinDistance(Integer.valueOf(1)).apply((CharSequence)"1234567", (CharSequence)"12345")).isEqualTo(-1);
        Assertions.assertThat((Integer)new LevenshteinDistance(Integer.valueOf(1)).apply((CharSequence)"frog", (CharSequence)"fog")).isEqualTo(1);
        Assertions.assertThat((Integer)new LevenshteinDistance(Integer.valueOf(3)).apply((CharSequence)"fly", (CharSequence)"ant")).isEqualTo(3);
        Assertions.assertThat((Integer)new LevenshteinDistance(Integer.valueOf(7)).apply((CharSequence)"elephant", (CharSequence)"hippo")).isEqualTo(7);
        Assertions.assertThat((Integer)new LevenshteinDistance(Integer.valueOf(6)).apply((CharSequence)"elephant", (CharSequence)"hippo")).isEqualTo(-1);
        Assertions.assertThat((Integer)new LevenshteinDistance(Integer.valueOf(7)).apply((CharSequence)"hippo", (CharSequence)"elephant")).isEqualTo(7);
        Assertions.assertThat((Integer)new LevenshteinDistance(Integer.valueOf(6)).apply((CharSequence)"hippo", (CharSequence)"elephant")).isEqualTo(-1);
        Assertions.assertThat((Integer)new LevenshteinDistance(Integer.valueOf(8)).apply((CharSequence)"hippo", (CharSequence)"zzzzzzzz")).isEqualTo(8);
        Assertions.assertThat((Integer)new LevenshteinDistance(Integer.valueOf(8)).apply((CharSequence)"zzzzzzzz", (CharSequence)"hippo")).isEqualTo(8);
        Assertions.assertThat((Integer)new LevenshteinDistance(Integer.valueOf(1)).apply((CharSequence)"hello", (CharSequence)"hallo")).isEqualTo(1);
        Assertions.assertThat((Integer)new LevenshteinDistance(Integer.valueOf(Integer.MAX_VALUE)).apply((CharSequence)"frog", (CharSequence)"fog")).isEqualTo(1);
        Assertions.assertThat((Integer)new LevenshteinDistance(Integer.valueOf(Integer.MAX_VALUE)).apply((CharSequence)"fly", (CharSequence)"ant")).isEqualTo(3);
        Assertions.assertThat((Integer)new LevenshteinDistance(Integer.valueOf(Integer.MAX_VALUE)).apply((CharSequence)"elephant", (CharSequence)"hippo")).isEqualTo(7);
        Assertions.assertThat((Integer)new LevenshteinDistance(Integer.valueOf(Integer.MAX_VALUE)).apply((CharSequence)"hippo", (CharSequence)"elephant")).isEqualTo(7);
        Assertions.assertThat((Integer)new LevenshteinDistance(Integer.valueOf(Integer.MAX_VALUE)).apply((CharSequence)"hippo", (CharSequence)"zzzzzzzz")).isEqualTo(8);
        Assertions.assertThat((Integer)new LevenshteinDistance(Integer.valueOf(Integer.MAX_VALUE)).apply((CharSequence)"zzzzzzzz", (CharSequence)"hippo")).isEqualTo(8);
        Assertions.assertThat((Integer)new LevenshteinDistance(Integer.valueOf(Integer.MAX_VALUE)).apply((CharSequence)"hello", (CharSequence)"hallo")).isEqualTo(1);
    }

    @Test
    public void testGetLevenshteinDistance_NullStringInt() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> UNLIMITED_DISTANCE.apply(null, (CharSequence)"a"));
    }

    @Test
    public void testGetLevenshteinDistance_StringNullInt() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> UNLIMITED_DISTANCE.apply((CharSequence)"a", null));
    }

    @Test
    public void testConstructorWithNegativeThreshold() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new LevenshteinDistance(Integer.valueOf(-1)));
    }

    @Test
    public void testApplyThrowsIllegalArgumentExceptionAndCreatesLevenshteinDistanceTakingInteger() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new LevenshteinDistance(Integer.valueOf(0)).apply(null, null));
    }

    @Test
    public void testGetThresholdDirectlyAfterObjectInstantiation() {
        Assertions.assertThat((Integer)new LevenshteinDistance().getThreshold()).isNull();
    }
}

