<!---
  Licensed to the Apache Software Foundation (ASF) under one
  or more contributor license agreements.  See the NOTICE file
  distributed with this work for additional information
  regarding copyright ownership.  The ASF licenses this file
  to you under the Apache License, Version 2.0 (the
  "License"); you may not use this file except in compliance
  with the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing,
  software distributed under the License is distributed on an
  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
  KIND, either express or implied.  See the License for the
  specific language governing permissions and limitations
  under the License.
-->

## [13.0.0](https://github.com/apache/datafusion/tree/13.0.0) (2022-10-06)

[Full Changelog](https://github.com/apache/datafusion/compare/12.0.0...13.0.0)

**Breaking changes:**

- Make ObjectStoreProvider fallible \(return `Result` rather than `Option`\) [\#3584](https://github.com/apache/datafusion/pull/3584) ([tustvold](https://github.com/tustvold))
- Make `OptimizerConfig` a builder style API [\#3525](https://github.com/apache/datafusion/pull/3525) ([alamb](https://github.com/alamb))

**Implemented enhancements:**

- remove `type coercion` for ScalarUDF in the physical phase [\#3734](https://github.com/apache/datafusion/issues/3734)
- Allow with statements to specify their columns alongside their expression names [\#3716](https://github.com/apache/datafusion/issues/3716)
- Support SQLDataType::Timestamp\(TimezoneInfo\) [\#3693](https://github.com/apache/datafusion/issues/3693)
- support `type coercion` for case when expr [\#3673](https://github.com/apache/datafusion/issues/3673)
- Add simplification rules for the `Modulo` operator [\#3664](https://github.com/apache/datafusion/issues/3664)
- Add TIMESTAMPTZ [\#3659](https://github.com/apache/datafusion/issues/3659)
- Simplify `A * 0` and `A * null`. [\#3626](https://github.com/apache/datafusion/issues/3626)
- change rule of `PreCastLitInComparisonExpressions` to unwrap cast rule after \#3582 [\#3622](https://github.com/apache/datafusion/issues/3622)
- Optimize regex_replace with a known pattern / replacement [\#3613](https://github.com/apache/datafusion/issues/3613)
- Simplify `CONCAT_WS(NULL, ..)` to `NULL` [\#3607](https://github.com/apache/datafusion/issues/3607)
- Add OctoSQL to list of systems powered by DataFusion [\#3605](https://github.com/apache/datafusion/issues/3605)
- Prevent over-allocation \(and spills\) on TopK queries [\#3596](https://github.com/apache/datafusion/issues/3596)
- Allow ObjectStoreProvider to return None \(return Result\<Option\> rather than Result\) [\#3594](https://github.com/apache/datafusion/issues/3594)
- simplify between expr should consider the data type [\#3587](https://github.com/apache/datafusion/issues/3587)
- make type coercion simple and remove the evaluate logic [\#3585](https://github.com/apache/datafusion/issues/3585)
- ReduceOuterJoin optimizer support `cast or try_cast` expr. [\#3565](https://github.com/apache/datafusion/issues/3565)
- Support type coercion for subquery [\#3557](https://github.com/apache/datafusion/issues/3557)
- Make `ParquetScanOptions` public and expose a reference to the scan options from `ParquetExec` [\#3550](https://github.com/apache/datafusion/issues/3550)
- Use `fetch` limit in `get_sorted_iter` [\#3544](https://github.com/apache/datafusion/issues/3544)
- Push limit to sort [\#3528](https://github.com/apache/datafusion/issues/3528)
- Execute sorts in parallel when limit is used after sort [\#3526](https://github.com/apache/datafusion/issues/3526)
- Consolidate optimizer passes in optimizer module for better testing [\#3524](https://github.com/apache/datafusion/issues/3524)
- Support Top-K query optimization for `ORDER BY \<EXPR\> \[ASC [\#3515](https://github.com/apache/datafusion/issues/3515)
- support the type coercion for `like` `unlike` `istrue` `isfalse` `isunknown` [\#3509](https://github.com/apache/datafusion/issues/3509)
- Automate the pushing of releases to Homebrew [\#3506](https://github.com/apache/datafusion/issues/3506)
- Add extra DATE_PART units that are already supported in arrow-rs [\#3502](https://github.com/apache/datafusion/issues/3502)
- Release datafusion-cli 12.0.0 on Homebrew [\#3501](https://github.com/apache/datafusion/issues/3501)
- Make `from_proto_binary_op` public [\#3489](https://github.com/apache/datafusion/issues/3489)
- coercion between decimal and other types lacking, compared to other numeric types [\#3479](https://github.com/apache/datafusion/issues/3479)
- move type coercion for inlist from physical phase to logical phase [\#3468](https://github.com/apache/datafusion/issues/3468)
- Make `datafusion::physical_plan::file_format::file_strean::FileStream` public [\#3466](https://github.com/apache/datafusion/issues/3466)
- Support using offset index in `ParquetRecordBatchStream` when pushing down `RowFilter` [\#3456](https://github.com/apache/datafusion/issues/3456)
- Support timestamp data type in In_list node [\#3449](https://github.com/apache/datafusion/issues/3449)
- Evaluate expressions after type coercion [\#3431](https://github.com/apache/datafusion/issues/3431)
- Make a convenience function to register a single `RecordBatch` as a table from SessionContext [\#3426](https://github.com/apache/datafusion/issues/3426)
- add datafusion-cli support of external table locations that object_store supports [\#3424](https://github.com/apache/datafusion/issues/3424)
- pruning support cast/try_cast expr [\#3414](https://github.com/apache/datafusion/issues/3414)
- Add documentation on querying against files in object store such as S3 [\#3399](https://github.com/apache/datafusion/issues/3399)
- Remove type-coercion from physical planner [\#3388](https://github.com/apache/datafusion/issues/3388)
- support `Statement::ShowVariable` to show session configs [\#3364](https://github.com/apache/datafusion/issues/3364)
- Support `RowFilter` in `ParquetExec` [\#3360](https://github.com/apache/datafusion/issues/3360)
- Apply `TypeCoercion` rule before `FilterPushDown` [\#3289](https://github.com/apache/datafusion/issues/3289)
- Add support for `get` / `show` timezone [\#3255](https://github.com/apache/datafusion/issues/3255)
- Consider adding DataFusion to ClickBench benchmarks [\#2902](https://github.com/apache/datafusion/issues/2902)
- `filter_push_down` panics on semi/anti join with join filters [\#2888](https://github.com/apache/datafusion/issues/2888)
- Migrate the `cross join -> inner join optimization` from the planner to the optimizer [\#2859](https://github.com/apache/datafusion/issues/2859)
- ObjectStore write support [\#2185](https://github.com/apache/datafusion/issues/2185)
- DataFusion should scan Parquet statistics once per query [\#871](https://github.com/apache/datafusion/issues/871)
- Extend & generalize constant folding / evaluation in logical optimizer [\#237](https://github.com/apache/datafusion/issues/237)

**Fixed bugs:**

- `projection_push_down` produces invalid aggregate plans in some cases [\#3738](https://github.com/apache/datafusion/issues/3738)
- `Time With Time Zone` should raise error until `DataType::Time64` support tz [\#3715](https://github.com/apache/datafusion/issues/3715)
- SQL Planner doesn't distinguish normal CTEs from the recursive ones. [\#3713](https://github.com/apache/datafusion/issues/3713)
- Fix inconsistency between column name formats [\#3711](https://github.com/apache/datafusion/issues/3711)
- Optimizer rule 'projection_push_down' failed due to unexpected error: Error during planning: Aggregate schema has wrong number of fields. Expected 3 got 8 [\#3704](https://github.com/apache/datafusion/issues/3704)
- Optimizer regressions in `unwrap_cast_in_comparison` [\#3690](https://github.com/apache/datafusion/issues/3690)
- Internal error when evaluating a predicate = "The type of Dictionary\(Int16, Utf8\) = Int64 of binary physical should be same" [\#3685](https://github.com/apache/datafusion/issues/3685)
- Specialized regexp_replace should early-abort when the input arrays are empty [\#3647](https://github.com/apache/datafusion/issues/3647)
- Internal error: Failed to coerce types Decimal128\(10, 2\) and Boolean in BETWEEN expression [\#3646](https://github.com/apache/datafusion/issues/3646)
- Internal error: Failed to coerce types Decimal128\(10, 2\) and Boolean in BETWEEN expression [\#3645](https://github.com/apache/datafusion/issues/3645)
- Type coercion error: The type of Boolean AND Decimal128\(10, 2\) of binary physical should be same [\#3644](https://github.com/apache/datafusion/issues/3644)
- LEFT JOIN not working as expected, error message is confusing [\#3639](https://github.com/apache/datafusion/issues/3639)
- `INTERSECT` and `EXCEPT` don't return an error when 2 sets have the different number of columns [\#3632](https://github.com/apache/datafusion/issues/3632)
- The datafusion-cli panics when `union` 2 table with different number of columns. [\#3630](https://github.com/apache/datafusion/issues/3630)
- The expression `col(a) / null` is not optimized. [\#3624](https://github.com/apache/datafusion/issues/3624)
- `s3_build_error` test may fail in some environments [\#3601](https://github.com/apache/datafusion/issues/3601)
- New clippy errors appears to be break the CI on the master [\#3597](https://github.com/apache/datafusion/issues/3597)
- `StringConcat` gives inconsistent result with `concat` when containing `null` [\#3569](https://github.com/apache/datafusion/issues/3569)
- simplify_expressions don't support different data type for binary [\#3556](https://github.com/apache/datafusion/issues/3556)
- Broken logical plan serialization for aggregation queries [\#3555](https://github.com/apache/datafusion/issues/3555)
- Aggregate filters do not get pushed down to table scan [\#3546](https://github.com/apache/datafusion/issues/3546)
- `docs.rs` cannot build `datafusion-proto` crate [\#3538](https://github.com/apache/datafusion/issues/3538)
- DataFusion serialization doesn't handle `ScalarValue::Dictionary, Binary, LargeBinary, Time64, IntervalMonthDayNano, Struct` [\#3531](https://github.com/apache/datafusion/issues/3531)
- What should be returned when trying to get a config in invalid format? [\#3505](https://github.com/apache/datafusion/issues/3505)
- Dividing decimal type gives wrong error: "170141183460469231731687303715884105727 is too large to store in a Decimal128 [\#3498](https://github.com/apache/datafusion/issues/3498)
- Add BitwiseXor in function `from_proto_binary_op` [\#3495](https://github.com/apache/datafusion/issues/3495)
- comparison operations with a scalar null and decimal array panics [\#3487](https://github.com/apache/datafusion/issues/3487)
- Union columns with different types [\#3467](https://github.com/apache/datafusion/issues/3467)
- Can't get the right logical plan after optimizer [\#3421](https://github.com/apache/datafusion/issues/3421)
- Fix conflict between simplify_expression rule and CAST expressions [\#3409](https://github.com/apache/datafusion/issues/3409)
- Empty array giving error [\#2439](https://github.com/apache/datafusion/issues/2439)
- Internal error: Unsupported data type in hasher: FixedSizeBinary\(16\) [\#1516](https://github.com/apache/datafusion/issues/1516)
- Predicates on to_timestamp do not work as expected with "naive" timestamp strings [\#765](https://github.com/apache/datafusion/issues/765)
- Address performance/execution plan of TPCH query 19 [\#78](https://github.com/apache/datafusion/issues/78)
- Bug fix: expr_visitor was not visiting aggregate filter expressions [\#3548](https://github.com/apache/datafusion/pull/3548) ([andygrove](https://github.com/andygrove))

**Documentation updates:**

- Publish 8.0.0 user guide [\#2558](https://github.com/apache/datafusion/issues/2558)
- MINOR: Add Dask SQL to list of projects powered by DataFusion [\#3581](https://github.com/apache/datafusion/pull/3581) ([andygrove](https://github.com/andygrove))
- Add Parseable as Datafusion user [\#3471](https://github.com/apache/datafusion/pull/3471) ([nitisht](https://github.com/nitisht))

**Closed issues:**

- Upgrade to Arrow 24.0.0 [\#3689](https://github.com/apache/datafusion/issues/3689)
- what's the best practice to get a single value from arrow array? [\#3497](https://github.com/apache/datafusion/issues/3497)
- The data type of predicate in the row filter should be same in the binary expr [\#3469](https://github.com/apache/datafusion/issues/3469)
- Extend constant folding and parquet filtering support [\#188](https://github.com/apache/datafusion/issues/188)
- Add FORMAT to explain plan and an easy to visualize format [\#96](https://github.com/apache/datafusion/issues/96)

**Merged pull requests:**

- Build aggregate schema in Aggregate::try_new [\#3739](https://github.com/apache/datafusion/pull/3739) ([andygrove](https://github.com/andygrove))
- delete type coercion for scalar udf in the physical phase [\#3735](https://github.com/apache/datafusion/pull/3735) ([liukun4515](https://github.com/liukun4515))
- Consolidate coercion code in `datafusion_expr::type_coercion` and submodules [\#3728](https://github.com/apache/datafusion/pull/3728) ([alamb](https://github.com/alamb))
- Skip filter push down on semi/anti joins [\#3723](https://github.com/apache/datafusion/pull/3723) ([andygrove](https://github.com/andygrove))
- Raise `Unsupported SQL type` for `Time(WithTimeZone)` and `Time(Tz)` [\#3718](https://github.com/apache/datafusion/pull/3718) [[sql](https://github.com/apache/datafusion/labels/sql)] ([waitingkuo](https://github.com/waitingkuo))
- Support column aliases specified by `WITH` statements [\#3717](https://github.com/apache/datafusion/pull/3717) [[sql](https://github.com/apache/datafusion/labels/sql)] ([isidentical](https://github.com/isidentical))
- Reject recursive CTEs before processing the sub-expressions [\#3714](https://github.com/apache/datafusion/pull/3714) [[sql](https://github.com/apache/datafusion/labels/sql)] ([isidentical](https://github.com/isidentical))
- Make column name consistent between Expr::name and Display/Debug [\#3712](https://github.com/apache/datafusion/pull/3712) [[sql](https://github.com/apache/datafusion/labels/sql)] ([andygrove](https://github.com/andygrove))
- Fix aggregate type coercion bug [\#3710](https://github.com/apache/datafusion/pull/3710) ([alamb](https://github.com/alamb))
- MINOR: Add `Expr::canonical_name` and improve docs on `Expr::name` [\#3706](https://github.com/apache/datafusion/pull/3706) ([andygrove](https://github.com/andygrove))
- Remove type coercions from ScalarValue and aggregation function code [\#3705](https://github.com/apache/datafusion/pull/3705) ([ozankabak](https://github.com/ozankabak))
- `unwrap_cast_in_comparison`: fix bug which can find the field for the schema [\#3699](https://github.com/apache/datafusion/pull/3699) ([liukun4515](https://github.com/liukun4515))
- bump sql-parser 0.25 [\#3698](https://github.com/apache/datafusion/pull/3698) [[sql](https://github.com/apache/datafusion/labels/sql)] ([xudong963](https://github.com/xudong963))
- Move optimizer init to optimizer crate [\#3692](https://github.com/apache/datafusion/pull/3692) ([andygrove](https://github.com/andygrove))
- Upgrade `arrow` `parquet` and `arrow-flight` to 24.0.0 [\#3691](https://github.com/apache/datafusion/pull/3691) [[sql](https://github.com/apache/datafusion/labels/sql)] ([alamb](https://github.com/alamb))
- Fix bug in dictionary coercion and allow better coercion [\#3688](https://github.com/apache/datafusion/pull/3688) ([alamb](https://github.com/alamb))
- \[MINOR\] Improve docstrings in binary_rule.rs [\#3687](https://github.com/apache/datafusion/pull/3687) ([alamb](https://github.com/alamb))
- \[MINOR\] Add `ScalarValue::new_utf8`, clean up creation of literals in casting tests [\#3680](https://github.com/apache/datafusion/pull/3680) ([alamb](https://github.com/alamb))
- Disable code coverage until we figure out why it is broken [\#3679](https://github.com/apache/datafusion/pull/3679) ([alamb](https://github.com/alamb))
- move `type coercion` for case when expr [\#3676](https://github.com/apache/datafusion/pull/3676) ([liukun4515](https://github.com/liukun4515))
- Update sqlparser to 0.24.0 [\#3675](https://github.com/apache/datafusion/pull/3675) [[sql](https://github.com/apache/datafusion/labels/sql)] ([alamb](https://github.com/alamb))
- Fail if field lengths are not same in INTERSECT and EXPECT [\#3674](https://github.com/apache/datafusion/pull/3674) ([askoa](https://github.com/askoa))
- Simplification Rules for Modulo Operator [\#3669](https://github.com/apache/datafusion/pull/3669) ([askoa](https://github.com/askoa))
- change pre_cast_lit_in_comparison to unwrap_cast_in_comparison [\#3662](https://github.com/apache/datafusion/pull/3662) ([liukun4515](https://github.com/liukun4515))
- restore optimization for `between` in simplify expression rule [\#3661](https://github.com/apache/datafusion/pull/3661) ([liukun4515](https://github.com/liukun4515))
- add timestamptz [\#3660](https://github.com/apache/datafusion/pull/3660) [[sql](https://github.com/apache/datafusion/labels/sql)] ([waitingkuo](https://github.com/waitingkuo))
- remove the type coercion in the simplify_expressions rule [\#3657](https://github.com/apache/datafusion/pull/3657) ([liukun4515](https://github.com/liukun4515))
- Cache collected file statistics [\#3649](https://github.com/apache/datafusion/pull/3649) ([mateuszkj](https://github.com/mateuszkj))
- make regexp_replace early abort with empty input [\#3648](https://github.com/apache/datafusion/pull/3648) ([isidentical](https://github.com/isidentical))
- Check each query has same number of columns when building the UNION plan [\#3638](https://github.com/apache/datafusion/pull/3638) ([HaoYang670](https://github.com/HaoYang670))
- move the `type coercion` to the beginning of the optimizer rule and support type coercion for subquery [\#3636](https://github.com/apache/datafusion/pull/3636) ([liukun4515](https://github.com/liukun4515))
- Add documentation for querying S3 data with CLI [\#3631](https://github.com/apache/datafusion/pull/3631) ([andygrove](https://github.com/andygrove))
- Simplify multiplication by `0` and by `null` [\#3627](https://github.com/apache/datafusion/pull/3627) ([HaoYang670](https://github.com/HaoYang670))
- Simplify null division. [\#3625](https://github.com/apache/datafusion/pull/3625) ([HaoYang670](https://github.com/HaoYang670))
- support cast/try_cast expr in reduceOuterJoin [\#3621](https://github.com/apache/datafusion/pull/3621) ([AssHero](https://github.com/AssHero))
- MINOR: fix TPC-H conversion function to not miss a row of data [\#3620](https://github.com/apache/datafusion/pull/3620) ([kmitchener](https://github.com/kmitchener))
- Document ObjectStoreProvider [\#3619](https://github.com/apache/datafusion/pull/3619) ([tustvold](https://github.com/tustvold))
- \[feat\] Support using offset index in ParquetRecordBatchStream when pu… [\#3616](https://github.com/apache/datafusion/pull/3616) ([Ted-Jiang](https://github.com/Ted-Jiang))
- Optimize `regex_replace` for scalar patterns [\#3614](https://github.com/apache/datafusion/pull/3614) ([isidentical](https://github.com/isidentical))
- Simplify `concat_ws(null, ..)` to `null` [\#3608](https://github.com/apache/datafusion/pull/3608) ([HaoYang670](https://github.com/HaoYang670))
- MINOR: improve docstrings on SessionContext [\#3603](https://github.com/apache/datafusion/pull/3603) ([alamb](https://github.com/alamb))
- Merge s3_success and s3_build_error tests into one test [\#3602](https://github.com/apache/datafusion/pull/3602) ([Licht-T](https://github.com/Licht-T))
- add `register_batch` and `read_batch` to `SessionContext` to register a single RecordBatch as a table [\#3600](https://github.com/apache/datafusion/pull/3600) ([BaymaxHWY](https://github.com/BaymaxHWY))
- \[CI\] Fix the newly added linting errors to make clippy happy [\#3598](https://github.com/apache/datafusion/pull/3598) ([isidentical](https://github.com/isidentical))
- Prevent over-allocations \(and spills\) on sorts with a fixed limit [\#3593](https://github.com/apache/datafusion/pull/3593) ([isidentical](https://github.com/isidentical))
- update datafusion cli deps [\#3588](https://github.com/apache/datafusion/pull/3588) ([Jimexist](https://github.com/Jimexist))
- Update cranelift\* dependencies `0.87` --\> `0.88` [\#3586](https://github.com/apache/datafusion/pull/3586) ([alamb](https://github.com/alamb))
- Fix docs.rs [\#3580](https://github.com/apache/datafusion/pull/3580) ([avantgardnerio](https://github.com/avantgardnerio))
- Fix build [\#3576](https://github.com/apache/datafusion/pull/3576) ([alamb](https://github.com/alamb))
- Use consistent name for `TimeUnit::Millisecond` [\#3575](https://github.com/apache/datafusion/pull/3575) ([alamb](https://github.com/alamb))
- Fix logical plan serialization [\#3574](https://github.com/apache/datafusion/pull/3574) ([thinkharderdev](https://github.com/thinkharderdev))
- Custom window frame logic \(support `ROWS`, `RANGE`, `PRECEDING` and `FOLLOWING` for window functions\) [\#3570](https://github.com/apache/datafusion/pull/3570) [[sql](https://github.com/apache/datafusion/labels/sql)] ([metesynnada](https://github.com/metesynnada))
- fix comparison of decimal array with null scalar [\#3567](https://github.com/apache/datafusion/pull/3567) ([kmitchener](https://github.com/kmitchener))
- Reduce dependencies of `datafusion-sql` crate [\#3566](https://github.com/apache/datafusion/pull/3566) [[sql](https://github.com/apache/datafusion/labels/sql)] ([mbrobbel](https://github.com/mbrobbel))
- Update pbjson-types requirement from 0.3 to 0.5 [\#3560](https://github.com/apache/datafusion/pull/3560) ([dependabot[bot]](https://github.com/apps/dependabot))
- Update pbjson requirement from 0.3 to 0.5 [\#3559](https://github.com/apache/datafusion/pull/3559) ([dependabot[bot]](https://github.com/apps/dependabot))
- Update pbjson-build requirement from 0.3 to 0.5 [\#3558](https://github.com/apache/datafusion/pull/3558) ([dependabot[bot]](https://github.com/apps/dependabot))
- MINOR: enable q19 in TPCH [\#3553](https://github.com/apache/datafusion/pull/3553) ([kmitchener](https://github.com/kmitchener))
- MINOR: remove out-of-date is_dictionary checks from binary_rule.rs [\#3552](https://github.com/apache/datafusion/pull/3552) ([kmitchener](https://github.com/kmitchener))
- Make ParquetScanOptions public and add method to get a reference from… [\#3551](https://github.com/apache/datafusion/pull/3551) ([thinkharderdev](https://github.com/thinkharderdev))
- fix coercion of null for decimal math in binary_rules [\#3549](https://github.com/apache/datafusion/pull/3549) ([kmitchener](https://github.com/kmitchener))
- Use `fetch` limit in get_sorted_iter [\#3545](https://github.com/apache/datafusion/pull/3545) ([Dandandan](https://github.com/Dandandan))
- feat: allow object store registration from datafusion-cli [\#3540](https://github.com/apache/datafusion/pull/3540) ([turbo1912](https://github.com/turbo1912))
- Actually test that `ScalarValue`s are the same after round trip serialization [\#3537](https://github.com/apache/datafusion/pull/3537) ([alamb](https://github.com/alamb))
- Add serialization of `ScalarValue::Struct` [\#3536](https://github.com/apache/datafusion/pull/3536) ([alamb](https://github.com/alamb))
- Add serialization of `ScalarValue::IntervalMonthDayNano` [\#3535](https://github.com/apache/datafusion/pull/3535) ([alamb](https://github.com/alamb))
- Add serialization of `ScalarValue::Binary` and `ScalarValue::LargeBinary`, `ScalarValue::Time64` [\#3534](https://github.com/apache/datafusion/pull/3534) ([alamb](https://github.com/alamb))
- MINOR: Impl `Debug` for TableReference and ResolvedTableReference [\#3533](https://github.com/apache/datafusion/pull/3533) [[sql](https://github.com/apache/datafusion/labels/sql)] ([andygrove](https://github.com/andygrove))
- Add support for serializing `ScalarValue::Dictionary` to datafusion-proto [\#3532](https://github.com/apache/datafusion/pull/3532) ([alamb](https://github.com/alamb))
- Push down limit to sort [\#3530](https://github.com/apache/datafusion/pull/3530) ([Dandandan](https://github.com/Dandandan))
- Execute sort in parallel when a limit is used after sort [\#3527](https://github.com/apache/datafusion/pull/3527) ([Dandandan](https://github.com/Dandandan))
- Config support type conversion [\#3522](https://github.com/apache/datafusion/pull/3522) ([comphead](https://github.com/comphead))
- MINOR: Add more execs to list of supported execs [\#3519](https://github.com/apache/datafusion/pull/3519) ([andygrove](https://github.com/andygrove))
- fix divide by zero not throwing proper error for decimal [\#3517](https://github.com/apache/datafusion/pull/3517) ([kmitchener](https://github.com/kmitchener))
- Make FileStream and FileOpener public [\#3514](https://github.com/apache/datafusion/pull/3514) ([thinkharderdev](https://github.com/thinkharderdev))
- feat: Union types coercion [\#3513](https://github.com/apache/datafusion/pull/3513) [[sql](https://github.com/apache/datafusion/labels/sql)] ([gandronchik](https://github.com/gandronchik))
- \[DataFrame\] - Add cache function for DataFrame [\#3512](https://github.com/apache/datafusion/pull/3512) ([francis-du](https://github.com/francis-du))
- type coercion: support is/is_not\_`bool`/like/unknown expr [\#3510](https://github.com/apache/datafusion/pull/3510) ([liukun4515](https://github.com/liukun4515))
- MINOR: remove unused dependencies [\#3508](https://github.com/apache/datafusion/pull/3508) ([waynexia](https://github.com/waynexia))
- Automate postrelease publishing to Homebrew [\#3507](https://github.com/apache/datafusion/pull/3507) ([iajoiner](https://github.com/iajoiner))
- Add additional DATE_PART units [\#3503](https://github.com/apache/datafusion/pull/3503) ([jonmmease](https://github.com/jonmmease))
- Add BitwiseXor in function from_proto_binary_op [\#3496](https://github.com/apache/datafusion/pull/3496) ([askoa](https://github.com/askoa))
- Make the function from_proto_binary_op public [\#3490](https://github.com/apache/datafusion/pull/3490) ([askoa](https://github.com/askoa))
- minor: fix bug in `downcast_value!` macro \(`T` --\> `$T`\) [\#3486](https://github.com/apache/datafusion/pull/3486) ([alamb](https://github.com/alamb))
- add time_zone into ConfigOptions [\#3485](https://github.com/apache/datafusion/pull/3485) [[sql](https://github.com/apache/datafusion/labels/sql)] ([waitingkuo](https://github.com/waitingkuo))
- \[MINOR\] Change `downcast_value!` macro so it does not need to use `use std::any::type_name;` [\#3484](https://github.com/apache/datafusion/pull/3484) ([alamb](https://github.com/alamb))
- Convert more cross joins to inner joins \(Address performance/execution plan of TPCH query 19\) [\#3482](https://github.com/apache/datafusion/pull/3482) ([DhamoPS](https://github.com/DhamoPS))
- \[minor\] Remove unused arg in macro in Inlist [\#3474](https://github.com/apache/datafusion/pull/3474) ([Ted-Jiang](https://github.com/Ted-Jiang))
- inlist: move type coercion to logical phase [\#3472](https://github.com/apache/datafusion/pull/3472) ([liukun4515](https://github.com/liukun4515))
- Use the column data type as the NULL data type in the row filter [\#3470](https://github.com/apache/datafusion/pull/3470) ([liukun4515](https://github.com/liukun4515))
- apply type coercion before filter pushdown [\#3459](https://github.com/apache/datafusion/pull/3459) ([liukun4515](https://github.com/liukun4515))
- add FixedSizeBinary support to create_hashes [\#3458](https://github.com/apache/datafusion/pull/3458) ([mcassels](https://github.com/mcassels))
- Support ShowVariable Statement [\#3455](https://github.com/apache/datafusion/pull/3455) [[sql](https://github.com/apache/datafusion/labels/sql)] ([waitingkuo](https://github.com/waitingkuo))
- Add additional pruning tests with casts, handle unsupported predicates better [\#3454](https://github.com/apache/datafusion/pull/3454) ([alamb](https://github.com/alamb))
- Add `InList` support for timestamp type. \(\#3449\) [\#3450](https://github.com/apache/datafusion/pull/3450) ([Ted-Jiang](https://github.com/Ted-Jiang))
- Evaluate expressions after type coercion [\#3444](https://github.com/apache/datafusion/pull/3444) ([Dandandan](https://github.com/Dandandan))
- remove type coercion in the binary physical expr [\#3396](https://github.com/apache/datafusion/pull/3396) ([liukun4515](https://github.com/liukun4515))
- Use arrow row format in SortPreservingMerge ~50-70% faster [\#3386](https://github.com/apache/datafusion/pull/3386) ([tustvold](https://github.com/tustvold))
- Pushdown `RowFilter` in `ParquetExec` [\#3380](https://github.com/apache/datafusion/pull/3380) ([thinkharderdev](https://github.com/thinkharderdev))
