/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.bulkhead;

import io.github.resilience4j.bulkhead.BulkheadConfig;
import io.github.resilience4j.bulkhead.BulkheadFullException;
import io.github.resilience4j.bulkhead.event.BulkheadEvent;
import io.github.resilience4j.bulkhead.event.BulkheadOnCallFinishedEvent;
import io.github.resilience4j.bulkhead.event.BulkheadOnCallPermittedEvent;
import io.github.resilience4j.bulkhead.event.BulkheadOnCallRejectedEvent;
import io.github.resilience4j.bulkhead.internal.SemaphoreBulkhead;
import io.github.resilience4j.core.EventConsumer;
import io.github.resilience4j.core.functions.OnceConsumer;
import io.vavr.CheckedConsumer;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.CheckedRunnable;
import io.vavr.collection.HashMap;
import io.vavr.collection.Map;
import io.vavr.control.Either;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface Bulkhead {
    public static <T> CheckedFunction0<T> decorateCheckedSupplier(Bulkhead bulkhead, CheckedFunction0<T> supplier) {
        return (CheckedFunction0 & Serializable)() -> {
            bulkhead.acquirePermission();
            try {
                Object object = supplier.apply();
                return object;
            }
            finally {
                bulkhead.onComplete();
            }
        };
    }

    public static <T> Supplier<CompletionStage<T>> decorateCompletionStage(Bulkhead bulkhead, Supplier<CompletionStage<T>> supplier) {
        return () -> {
            CompletableFuture promise = new CompletableFuture();
            if (!bulkhead.tryAcquirePermission()) {
                promise.completeExceptionally(BulkheadFullException.createBulkheadFullException(bulkhead));
            } else {
                try {
                    ((CompletionStage)supplier.get()).whenComplete((result, throwable) -> {
                        bulkhead.onComplete();
                        if (throwable != null) {
                            promise.completeExceptionally((Throwable)throwable);
                        } else {
                            promise.complete(result);
                        }
                    });
                }
                catch (Throwable throwable2) {
                    bulkhead.onComplete();
                    promise.completeExceptionally(throwable2);
                }
            }
            return promise;
        };
    }

    public static <T> Supplier<Future<T>> decorateFuture(Bulkhead bulkhead, Supplier<Future<T>> supplier) {
        return () -> {
            if (!bulkhead.tryAcquirePermission()) {
                CompletableFuture promise = new CompletableFuture();
                promise.completeExceptionally(BulkheadFullException.createBulkheadFullException(bulkhead));
                return promise;
            }
            try {
                return new BulkheadFuture(bulkhead, (Future)supplier.get());
            }
            catch (Throwable e) {
                bulkhead.onComplete();
                throw e;
            }
        };
    }

    public static CheckedRunnable decorateCheckedRunnable(Bulkhead bulkhead, CheckedRunnable runnable) {
        return () -> {
            bulkhead.acquirePermission();
            try {
                runnable.run();
            }
            finally {
                bulkhead.onComplete();
            }
        };
    }

    public static <T> Callable<T> decorateCallable(Bulkhead bulkhead, Callable<T> callable) {
        return () -> {
            bulkhead.acquirePermission();
            try {
                Object v = callable.call();
                return v;
            }
            finally {
                bulkhead.onComplete();
            }
        };
    }

    public static <T> Supplier<T> decorateSupplier(Bulkhead bulkhead, Supplier<T> supplier) {
        return () -> {
            bulkhead.acquirePermission();
            try {
                Object t = supplier.get();
                return t;
            }
            finally {
                bulkhead.onComplete();
            }
        };
    }

    public static <T> Supplier<Try<T>> decorateTrySupplier(Bulkhead bulkhead, Supplier<Try<T>> supplier) {
        return () -> {
            if (bulkhead.tryAcquirePermission()) {
                try {
                    Try try_ = (Try)supplier.get();
                    return try_;
                }
                finally {
                    bulkhead.onComplete();
                }
            }
            return Try.failure((Throwable)BulkheadFullException.createBulkheadFullException(bulkhead));
        };
    }

    public static <T> Supplier<Either<Exception, T>> decorateEitherSupplier(Bulkhead bulkhead, Supplier<Either<? extends Exception, T>> supplier) {
        return () -> {
            if (bulkhead.tryAcquirePermission()) {
                try {
                    Either result = (Either)supplier.get();
                    Either either = Either.narrow((Either)result);
                    return either;
                }
                finally {
                    bulkhead.onComplete();
                }
            }
            return Either.left((Object)BulkheadFullException.createBulkheadFullException(bulkhead));
        };
    }

    public static <T> Consumer<T> decorateConsumer(Bulkhead bulkhead, Consumer<T> consumer) {
        return t -> {
            bulkhead.acquirePermission();
            try {
                consumer.accept(t);
            }
            finally {
                bulkhead.onComplete();
            }
        };
    }

    public static <T> CheckedConsumer<T> decorateCheckedConsumer(Bulkhead bulkhead, CheckedConsumer<T> consumer) {
        return t -> {
            bulkhead.acquirePermission();
            try {
                consumer.accept(t);
            }
            finally {
                bulkhead.onComplete();
            }
        };
    }

    public static Runnable decorateRunnable(Bulkhead bulkhead, Runnable runnable) {
        return () -> {
            bulkhead.acquirePermission();
            try {
                runnable.run();
            }
            finally {
                bulkhead.onComplete();
            }
        };
    }

    public static <T, R> Function<T, R> decorateFunction(Bulkhead bulkhead, Function<T, R> function) {
        return t -> {
            bulkhead.acquirePermission();
            try {
                Object r = function.apply(t);
                return r;
            }
            finally {
                bulkhead.onComplete();
            }
        };
    }

    public static <T, R> CheckedFunction1<T, R> decorateCheckedFunction(Bulkhead bulkhead, CheckedFunction1<T, R> function) {
        return (CheckedFunction1 & Serializable)t -> {
            bulkhead.acquirePermission();
            try {
                Object object = function.apply(t);
                return object;
            }
            finally {
                bulkhead.onComplete();
            }
        };
    }

    public static Bulkhead ofDefaults(String name) {
        return new SemaphoreBulkhead(name);
    }

    public static Bulkhead of(String name, BulkheadConfig config) {
        return Bulkhead.of(name, config, (Map<String, String>)HashMap.empty());
    }

    public static Bulkhead of(String name, BulkheadConfig config, Map<String, String> tags) {
        return new SemaphoreBulkhead(name, config, tags);
    }

    public static Bulkhead of(String name, Supplier<BulkheadConfig> bulkheadConfigSupplier) {
        return Bulkhead.of(name, bulkheadConfigSupplier, (Map<String, String>)HashMap.empty());
    }

    public static Bulkhead of(String name, Supplier<BulkheadConfig> bulkheadConfigSupplier, Map<String, String> tags) {
        return new SemaphoreBulkhead(name, bulkheadConfigSupplier, tags);
    }

    public void changeConfig(BulkheadConfig var1);

    public boolean tryAcquirePermission();

    public void acquirePermission();

    public void releasePermission();

    public void onComplete();

    public String getName();

    public BulkheadConfig getBulkheadConfig();

    public Metrics getMetrics();

    public Map<String, String> getTags();

    public EventPublisher getEventPublisher();

    default public <T> T executeSupplier(Supplier<T> supplier) {
        return Bulkhead.decorateSupplier(this, supplier).get();
    }

    default public <T> Try<T> executeTrySupplier(Supplier<Try<T>> supplier) {
        return Bulkhead.decorateTrySupplier(this, supplier).get();
    }

    default public <T> Either<Exception, T> executeEitherSupplier(Supplier<Either<? extends Exception, T>> supplier) {
        return Bulkhead.decorateEitherSupplier(this, supplier).get();
    }

    default public <T> T executeCallable(Callable<T> callable) throws Exception {
        return Bulkhead.decorateCallable(this, callable).call();
    }

    default public void executeRunnable(Runnable runnable) {
        Bulkhead.decorateRunnable(this, runnable).run();
    }

    default public <T> T executeCheckedSupplier(CheckedFunction0<T> checkedSupplier) throws Throwable {
        return (T)Bulkhead.decorateCheckedSupplier(this, checkedSupplier).apply();
    }

    default public <T> CompletionStage<T> executeCompletionStage(Supplier<CompletionStage<T>> supplier) {
        return Bulkhead.decorateCompletionStage(this, supplier).get();
    }

    public static final class BulkheadFuture<T>
    implements Future<T> {
        private final Future<T> future;
        private final OnceConsumer<Bulkhead> onceToBulkhead;

        BulkheadFuture(Bulkhead bulkhead, Future<T> future) {
            Objects.requireNonNull(future, "Non null Future is required to decorate");
            this.onceToBulkhead = OnceConsumer.of((Object)bulkhead);
            this.future = future;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.future.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.future.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.future.isDone();
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            try {
                T t = this.future.get();
                return t;
            }
            finally {
                this.onceToBulkhead.applyOnce(bh -> bh.onComplete());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            try {
                T t = this.future.get(timeout, unit);
                return t;
            }
            finally {
                this.onceToBulkhead.applyOnce(bh -> bh.onComplete());
            }
        }
    }

    public static interface EventPublisher
    extends io.github.resilience4j.core.EventPublisher<BulkheadEvent> {
        public EventPublisher onCallRejected(EventConsumer<BulkheadOnCallRejectedEvent> var1);

        public EventPublisher onCallPermitted(EventConsumer<BulkheadOnCallPermittedEvent> var1);

        public EventPublisher onCallFinished(EventConsumer<BulkheadOnCallFinishedEvent> var1);
    }

    public static interface Metrics {
        public int getAvailableConcurrentCalls();

        public int getMaxAllowedConcurrentCalls();
    }
}

