/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.task.batch.parallel;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import org.apache.druid.guice.annotations.EscalatedGlobal;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTaskClient;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTaskClientImpl;
import org.apache.druid.indexing.common.task.batch.parallel.ParallelIndexSupervisorTaskClientProvider;
import org.apache.druid.rpc.ServiceClientFactory;
import org.apache.druid.rpc.ServiceRetryPolicy;
import org.apache.druid.rpc.StandardRetryPolicy;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.rpc.indexing.TaskServiceClients;
import org.joda.time.Duration;

public class ParallelIndexSupervisorTaskClientProviderImpl
implements ParallelIndexSupervisorTaskClientProvider {
    private final ServiceClientFactory serviceClientFactory;
    private final OverlordClient overlordClient;
    private final ObjectMapper jsonMapper;
    private final ObjectMapper smileMapper;

    @Inject
    public ParallelIndexSupervisorTaskClientProviderImpl(@EscalatedGlobal ServiceClientFactory serviceClientFactory, OverlordClient overlordClient, @Json ObjectMapper jsonMapper, @Smile ObjectMapper smileMapper) {
        this.serviceClientFactory = serviceClientFactory;
        this.overlordClient = overlordClient;
        this.jsonMapper = jsonMapper;
        this.smileMapper = smileMapper;
    }

    @Override
    public ParallelIndexSupervisorTaskClient build(String supervisorTaskId, Duration httpTimeout, long numRetries) {
        return new ParallelIndexSupervisorTaskClientImpl(TaskServiceClients.makeClient((String)supervisorTaskId, (ServiceRetryPolicy)StandardRetryPolicy.builder().maxAttempts(numRetries - 1L).build(), (ServiceClientFactory)this.serviceClientFactory, (OverlordClient)this.overlordClient), this.jsonMapper, this.smileMapper, httpTimeout);
    }
}

