/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord;

import com.google.common.base.Optional;
import com.google.inject.Inject;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.apache.druid.indexing.common.actions.TaskActionClient;
import org.apache.druid.indexing.common.actions.TaskActionClientFactory;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.TaskQueue;
import org.apache.druid.indexing.overlord.TaskRunner;
import org.apache.druid.indexing.overlord.autoscaling.ScalingStats;
import org.apache.druid.indexing.overlord.supervisor.SupervisorManager;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.server.metrics.TaskCountStatsProvider;
import org.apache.druid.server.metrics.TaskSlotCountStatsProvider;

public class TaskMaster
implements TaskCountStatsProvider,
TaskSlotCountStatsProvider {
    private final TaskActionClientFactory taskActionClientFactory;
    private final SupervisorManager supervisorManager;
    private volatile TaskRunner taskRunner;
    private volatile TaskQueue taskQueue;
    private final AtomicBoolean isLeader = new AtomicBoolean(false);

    @Inject
    public TaskMaster(TaskActionClientFactory taskActionClientFactory, SupervisorManager supervisorManager) {
        this.taskActionClientFactory = taskActionClientFactory;
        this.supervisorManager = supervisorManager;
    }

    public void becomeLeader(TaskRunner taskRunner, TaskQueue taskQueue) {
        this.taskRunner = taskRunner;
        this.taskQueue = taskQueue;
        this.isLeader.set(true);
    }

    public void stopBeingLeader() {
        this.isLeader.set(false);
        this.taskQueue = null;
        this.taskRunner = null;
    }

    private boolean isLeader() {
        return this.isLeader.get();
    }

    public Optional<TaskRunner> getTaskRunner() {
        if (this.isLeader()) {
            return Optional.of((Object)this.taskRunner);
        }
        return Optional.absent();
    }

    public Optional<TaskQueue> getTaskQueue() {
        if (this.isLeader()) {
            return Optional.of((Object)this.taskQueue);
        }
        return Optional.absent();
    }

    public Optional<TaskActionClient> getTaskActionClient(Task task) {
        if (this.isLeader()) {
            return Optional.of((Object)this.taskActionClientFactory.create(task));
        }
        return Optional.absent();
    }

    public Optional<ScalingStats> getScalingStats() {
        if (this.isLeader()) {
            return this.taskRunner.getScalingStats();
        }
        return Optional.absent();
    }

    public Optional<SupervisorManager> getSupervisorManager() {
        if (this.isLeader()) {
            return Optional.of((Object)this.supervisorManager);
        }
        return Optional.absent();
    }

    public Map<String, Long> getSuccessfulTaskCount() {
        Optional<TaskQueue> taskQueue = this.getTaskQueue();
        if (taskQueue.isPresent()) {
            return ((TaskQueue)taskQueue.get()).getSuccessfulTaskCount();
        }
        return null;
    }

    public Map<String, Long> getFailedTaskCount() {
        Optional<TaskQueue> taskQueue = this.getTaskQueue();
        if (taskQueue.isPresent()) {
            return ((TaskQueue)taskQueue.get()).getFailedTaskCount();
        }
        return null;
    }

    public Map<String, Long> getRunningTaskCount() {
        Optional<TaskQueue> taskQueue = this.getTaskQueue();
        if (taskQueue.isPresent()) {
            return ((TaskQueue)taskQueue.get()).getRunningTaskCount();
        }
        return null;
    }

    public Map<String, Long> getPendingTaskCount() {
        Optional<TaskQueue> taskQueue = this.getTaskQueue();
        if (taskQueue.isPresent()) {
            return ((TaskQueue)taskQueue.get()).getPendingTaskCount();
        }
        return null;
    }

    public Map<String, Long> getWaitingTaskCount() {
        Optional<TaskQueue> taskQueue = this.getTaskQueue();
        if (taskQueue.isPresent()) {
            return ((TaskQueue)taskQueue.get()).getWaitingTaskCount();
        }
        return null;
    }

    public CoordinatorRunStats getStats() {
        Optional<TaskQueue> taskQueue = this.getTaskQueue();
        if (taskQueue.isPresent()) {
            return ((TaskQueue)taskQueue.get()).getQueueStats();
        }
        return CoordinatorRunStats.empty();
    }

    @Nullable
    public Map<String, Long> getTotalTaskSlotCount() {
        Optional<TaskRunner> taskRunner = this.getTaskRunner();
        if (taskRunner.isPresent()) {
            return ((TaskRunner)taskRunner.get()).getTotalTaskSlotCount();
        }
        return null;
    }

    @Nullable
    public Map<String, Long> getIdleTaskSlotCount() {
        Optional<TaskRunner> taskRunner = this.getTaskRunner();
        if (taskRunner.isPresent()) {
            return ((TaskRunner)taskRunner.get()).getIdleTaskSlotCount();
        }
        return null;
    }

    @Nullable
    public Map<String, Long> getUsedTaskSlotCount() {
        Optional<TaskRunner> taskRunner = this.getTaskRunner();
        if (taskRunner.isPresent()) {
            return ((TaskRunner)taskRunner.get()).getUsedTaskSlotCount();
        }
        return null;
    }

    @Nullable
    public Map<String, Long> getLazyTaskSlotCount() {
        Optional<TaskRunner> taskRunner = this.getTaskRunner();
        if (taskRunner.isPresent()) {
            return ((TaskRunner)taskRunner.get()).getLazyTaskSlotCount();
        }
        return null;
    }

    @Nullable
    public Map<String, Long> getBlacklistedTaskSlotCount() {
        Optional<TaskRunner> taskRunner = this.getTaskRunner();
        if (taskRunner.isPresent()) {
            return ((TaskRunner)taskRunner.get()).getBlacklistedTaskSlotCount();
        }
        return null;
    }
}

