/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.overlord.duty;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.druid.common.config.Configs;

public class TaskLogAutoCleanerConfig {
    @JsonProperty
    private final boolean enabled;
    @JsonProperty
    private final long initialDelay;
    @JsonProperty
    private final long delay;
    @JsonProperty
    private final long durationToRetain;

    @JsonCreator
    public TaskLogAutoCleanerConfig(@JsonProperty(value="enabled") boolean enabled, @JsonProperty(value="initialDelay") Long initialDelay, @JsonProperty(value="delay") Long delay, @JsonProperty(value="durationToRetain") Long durationToRetain) {
        if (enabled) {
            Preconditions.checkNotNull((Object)durationToRetain, (Object)"'durationToRetain' must be provided.");
        }
        this.enabled = enabled;
        this.initialDelay = Configs.valueOrDefault((Long)initialDelay, (long)(60000 + ThreadLocalRandom.current().nextInt(240000)));
        this.delay = Configs.valueOrDefault((Long)delay, (long)TimeUnit.HOURS.toMillis(6L));
        this.durationToRetain = Configs.valueOrDefault((Long)durationToRetain, (long)Long.MAX_VALUE);
        Preconditions.checkArgument((this.initialDelay > 0L ? 1 : 0) != 0, (Object)"'initialDelay' must be greater than 0.");
        Preconditions.checkArgument((this.delay > 0L ? 1 : 0) != 0, (Object)"'delay' must be greater than 0.");
        Preconditions.checkArgument((this.durationToRetain > 0L ? 1 : 0) != 0, (Object)"'durationToRetain' must be greater than 0.");
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    public long getDelay() {
        return this.delay;
    }

    public long getDurationToRetain() {
        return this.durationToRetain;
    }

    public String toString() {
        return "TaskLogAutoCleanerConfig{enabled=" + this.enabled + ", initialDelay=" + this.initialDelay + ", delay=" + this.delay + ", durationToRetain=" + this.durationToRetain + '}';
    }
}

