/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rule;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Uncollect;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.InputBindings;
import org.apache.druid.query.InlineDataSource;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.DruidQueryRel;
import org.apache.druid.sql.calcite.rel.DruidUnnestRel;
import org.apache.druid.sql.calcite.table.RowSignatures;

public class DruidUnnestRule
extends RelOptRule {
    private final PlannerContext plannerContext;

    public DruidUnnestRule(PlannerContext plannerContext) {
        super(DruidUnnestRule.operand(Uncollect.class, (RelOptRuleOperand)DruidUnnestRule.operand(Project.class, (RelOptRuleOperand)DruidUnnestRule.operand(Values.class, (RelOptRuleOperandChildren)DruidUnnestRule.none()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
        this.plannerContext = plannerContext;
    }

    public boolean matches(RelOptRuleCall call) {
        Project projectRel = (Project)call.rel(1);
        Values valuesRel = (Values)call.rel(2);
        return projectRel.getProjects().size() == 1 && valuesRel.getTuples().size() == 1 && RelOptUtil.InputFinder.bits((List)projectRel.getProjects(), null).isEmpty();
    }

    public void onMatch(RelOptRuleCall call) {
        Uncollect uncollectRel = (Uncollect)call.rel(0);
        Project projectRel = (Project)call.rel(1);
        RexNode exprToUnnest = (RexNode)projectRel.getProjects().get(0);
        if (RexUtil.isConstant((RexNode)exprToUnnest)) {
            InlineDataSource inlineDataSource = DruidUnnestRule.toInlineDataSource(uncollectRel, exprToUnnest, this.plannerContext);
            if (inlineDataSource != null) {
                call.transformTo((RelNode)DruidQueryRel.scanConstantRel((RelNode)uncollectRel, inlineDataSource, this.plannerContext));
            }
        } else {
            call.transformTo((RelNode)DruidUnnestRel.create(uncollectRel.getCluster(), uncollectRel.getTraitSet(), exprToUnnest, this.plannerContext));
        }
    }

    @Nullable
    private static InlineDataSource toInlineDataSource(Uncollect uncollectRel, RexNode projectExpr, PlannerContext plannerContext) {
        DruidExpression expression = Expressions.toDruidExpression(plannerContext, RowSignature.empty(), projectExpr);
        if (expression == null) {
            return null;
        }
        Expr parsedExpression = plannerContext.parseExpression(expression.getExpression());
        ExprEval eval = parsedExpression.eval(InputBindings.nilBindings());
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        if (eval.isArray()) {
            Object[] evalArray = eval.asArray();
            if (evalArray != null) {
                for (Object o : evalArray) {
                    rows.add(new Object[]{o});
                }
            }
        } else {
            rows.add(new Object[]{eval.valueOrDefault()});
        }
        RowSignature rowSignature = RowSignatures.fromRelDataType(uncollectRel.getRowType().getFieldNames(), uncollectRel.getRowType());
        return InlineDataSource.fromIterable(rows, (RowSignature)rowSignature);
    }
}

