/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rule;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Sort;
import org.apache.druid.sql.calcite.planner.OffsetLimit;

public class SortCollapseRule
extends RelOptRule {
    private static final SortCollapseRule INSTANCE = new SortCollapseRule();

    public SortCollapseRule() {
        super(SortCollapseRule.operand(Sort.class, (RelOptRuleOperand)SortCollapseRule.operand(Sort.class, (RelOptRuleOperandChildren)SortCollapseRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
    }

    public static SortCollapseRule instance() {
        return INSTANCE;
    }

    public void onMatch(RelOptRuleCall call) {
        Sort outerSort = (Sort)call.rel(0);
        Sort innerSort = (Sort)call.rel(1);
        if (outerSort.collation.getFieldCollations().isEmpty() || outerSort.collation.getFieldCollations().equals(innerSort.collation.getFieldCollations())) {
            OffsetLimit offsetLimit = OffsetLimit.fromSort(innerSort).andThen(OffsetLimit.fromSort(outerSort));
            Sort combined = innerSort.copy(innerSort.getTraitSet(), innerSort.getInput(), innerSort.getCollation(), offsetLimit.getOffsetAsRexNode(call.builder().getRexBuilder()), offsetLimit.getLimitAsRexNode(call.builder().getRexBuilder()));
            call.transformTo((RelNode)combined);
            call.getPlanner().prune((RelNode)outerSort);
        }
    }
}

