/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.cli;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.initialization.ServerInjectorBuilder;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.lifecycle.Lifecycle;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.log.StartupLoggingConfig;
import org.apache.druid.utils.JvmUtils;

public abstract class GuiceRunnable
implements Runnable {
    private final Logger log;
    private Properties properties;
    private Injector baseInjector;

    public GuiceRunnable(Logger log) {
        this.log = log;
    }

    @Override
    public abstract void run();

    @Inject
    public void configure(Properties properties, Injector injector) {
        this.properties = properties;
        this.baseInjector = injector;
    }

    protected Properties getProperties() {
        return this.properties;
    }

    protected abstract List<? extends Module> getModules();

    public Injector makeInjector() {
        return this.makeInjector((Set<NodeRole>)ImmutableSet.of());
    }

    public Injector makeInjector(Set<NodeRole> nodeRoles) {
        try {
            return ServerInjectorBuilder.makeServerInjector((Injector)this.baseInjector, nodeRoles, this.getModules());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Lifecycle initLifecycle(Injector injector) {
        return GuiceRunnable.initLifecycle(injector, this.log);
    }

    public static Lifecycle initLifecycle(Injector injector, Logger log) {
        try {
            Lifecycle lifecycle = (Lifecycle)injector.getInstance(Lifecycle.class);
            StartupLoggingConfig startupLoggingConfig = (StartupLoggingConfig)injector.getInstance(StartupLoggingConfig.class);
            Long directSizeBytes = null;
            try {
                directSizeBytes = JvmUtils.getRuntimeInfo().getDirectMemorySizeBytes();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            log.info("Starting up with processors [%,d], memory [%,d], maxMemory [%,d]%s. Properties follow.", new Object[]{JvmUtils.getRuntimeInfo().getAvailableProcessors(), JvmUtils.getRuntimeInfo().getTotalHeapSizeBytes(), JvmUtils.getRuntimeInfo().getMaxHeapSizeBytes(), directSizeBytes != null ? StringUtils.format((String)", directMemory [%,d]", (Object[])new Object[]{directSizeBytes}) : ""});
            if (startupLoggingConfig.isLogProperties()) {
                HashSet maskProperties = Sets.newHashSet((Iterable)startupLoggingConfig.getMaskProperties());
                Properties props = (Properties)injector.getInstance(Properties.class);
                for (String propertyName : Ordering.natural().sortedCopy(props.stringPropertyNames())) {
                    String property = props.getProperty(propertyName);
                    for (String masked : maskProperties) {
                        if (!propertyName.contains(masked)) continue;
                        property = "<masked>";
                        break;
                    }
                    log.info("* %s: %s", new Object[]{propertyName, property});
                }
            }
            try {
                lifecycle.start();
            }
            catch (Throwable t) {
                log.error(t, "Error when starting up.  Failing.", new Object[0]);
                System.exit(1);
            }
            return lifecycle;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

