/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.router;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.druid.client.selector.Server;
import org.apache.druid.discovery.DiscoveryDruidNode;
import org.apache.druid.discovery.DruidNodeDiscovery;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.query.Query;
import org.apache.druid.server.coordinator.rules.LoadRule;
import org.apache.druid.server.coordinator.rules.Rule;
import org.apache.druid.server.router.CoordinatorRuleManager;
import org.apache.druid.server.router.TieredBrokerConfig;
import org.apache.druid.server.router.TieredBrokerSelectorStrategy;
import org.apache.druid.sql.http.SqlQuery;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class TieredBrokerHostSelector {
    private static EmittingLogger log = new EmittingLogger(TieredBrokerHostSelector.class);
    private final CoordinatorRuleManager ruleManager;
    private final TieredBrokerConfig tierConfig;
    private final List<TieredBrokerSelectorStrategy> strategies;
    private final ConcurrentHashMap<String, NodesHolder> servers = new ConcurrentHashMap();
    private final DruidNodeDiscoveryProvider druidNodeDiscoveryProvider;
    private final Object lock = new Object();
    private volatile boolean started = false;
    private static final Function<DiscoveryDruidNode, Server> TO_SERVER = new Function<DiscoveryDruidNode, Server>(){

        public Server apply(final DiscoveryDruidNode instance) {
            return new Server(){

                public String getHost() {
                    return instance.getDruidNode().getHostAndPortToUse();
                }

                public String getAddress() {
                    return instance.getDruidNode().getHost();
                }

                public int getPort() {
                    return instance.getDruidNode().getPortToUse();
                }

                public String getScheme() {
                    return instance.getDruidNode().getServiceScheme();
                }
            };
        }
    };

    @Inject
    public TieredBrokerHostSelector(CoordinatorRuleManager ruleManager, TieredBrokerConfig tierConfig, DruidNodeDiscoveryProvider druidNodeDiscoveryProvider, List<TieredBrokerSelectorStrategy> strategies) {
        this.ruleManager = ruleManager;
        this.tierConfig = tierConfig;
        this.druidNodeDiscoveryProvider = druidNodeDiscoveryProvider;
        this.strategies = strategies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            for (Map.Entry<String, String> entry : this.tierConfig.getTierToBrokerMap().entrySet()) {
                this.servers.put(entry.getValue(), new NodesHolder());
            }
            DruidNodeDiscovery druidNodeDiscovery = this.druidNodeDiscoveryProvider.getForNodeRole(NodeRole.BROKER);
            druidNodeDiscovery.registerListener(new DruidNodeDiscovery.Listener(){

                public void nodesAdded(Collection<DiscoveryDruidNode> nodes) {
                    nodes.forEach(node -> {
                        NodesHolder nodesHolder = (NodesHolder)TieredBrokerHostSelector.this.servers.get(node.getDruidNode().getServiceName());
                        if (nodesHolder != null) {
                            nodesHolder.add(node.getDruidNode().getHostAndPortToUse(), (Server)TO_SERVER.apply(node));
                        }
                    });
                }

                public void nodesRemoved(Collection<DiscoveryDruidNode> nodes) {
                    nodes.forEach(node -> {
                        NodesHolder nodesHolder = (NodesHolder)TieredBrokerHostSelector.this.servers.get(node.getDruidNode().getServiceName());
                        if (nodesHolder != null) {
                            nodesHolder.remove(node.getDruidNode().getHostAndPortToUse());
                        }
                    });
                }
            });
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            this.started = false;
        }
    }

    public String getDefaultServiceName() {
        return this.tierConfig.getDefaultBrokerServiceName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Pair<String, Server> select(Query<T> query) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.ruleManager.isStarted() || !this.started) {
                return this.getDefaultLookup();
            }
        }
        String brokerServiceName = null;
        for (TieredBrokerSelectorStrategy strategy : this.strategies) {
            Optional<String> optionalName = strategy.getBrokerServiceName(this.tierConfig, query);
            if (!optionalName.isPresent()) continue;
            brokerServiceName = (String)optionalName.get();
            break;
        }
        if (brokerServiceName == null) {
            List<Rule> rules = this.ruleManager.getRulesWithDefault((String)Iterables.getFirst((Iterable)query.getDataSource().getTableNames(), null));
            DateTime now = DateTimes.nowUtc();
            int lastRulePosition = -1;
            LoadRule baseRule = null;
            block4: for (Interval interval : query.getIntervals()) {
                int currRulePosition = 0;
                for (Rule rule : rules) {
                    if (rule instanceof LoadRule && currRulePosition > lastRulePosition && rule.appliesTo(interval, now)) {
                        lastRulePosition = currRulePosition;
                        baseRule = (LoadRule)rule;
                        continue block4;
                    }
                    ++currRulePosition;
                }
            }
            if (baseRule == null) {
                return this.getDefaultLookup();
            }
            for (Map.Entry entry : this.tierConfig.getTierToBrokerMap().entrySet()) {
                if (!baseRule.getTieredReplicants().containsKey(entry.getKey())) continue;
                brokerServiceName = (String)entry.getValue();
                break;
            }
        }
        if (brokerServiceName == null) {
            if (query.context().isDebug()) {
                log.info("Using default broker service[%s] for query with datasource [%s] and intervals[%s].", new Object[]{this.tierConfig.getDefaultBrokerServiceName(), query.getDataSource(), query.getIntervals()});
            }
            brokerServiceName = this.tierConfig.getDefaultBrokerServiceName();
        }
        return this.getServerPair(brokerServiceName);
    }

    private Pair<String, Server> getServerPair(String brokerServiceName) {
        NodesHolder nodesHolder = this.servers.get(brokerServiceName);
        if (nodesHolder == null) {
            log.error("No nodesHolder found for brokerServiceName[%s]. Using default selector for[%s]", new Object[]{brokerServiceName, this.tierConfig.getDefaultBrokerServiceName()});
            nodesHolder = this.servers.get(this.tierConfig.getDefaultBrokerServiceName());
        }
        return new Pair((Object)brokerServiceName, (Object)nodesHolder.pick());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pair<String, Server> selectForSql(SqlQuery sqlQuery) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return this.getDefaultLookup();
            }
        }
        String brokerServiceName = null;
        for (TieredBrokerSelectorStrategy strategy : this.strategies) {
            Optional<String> optionalName = strategy.getBrokerServiceName(this.tierConfig, sqlQuery);
            if (!optionalName.isPresent()) continue;
            brokerServiceName = (String)optionalName.get();
            break;
        }
        if (brokerServiceName == null) {
            brokerServiceName = this.tierConfig.getDefaultBrokerServiceName();
            if (sqlQuery.queryContext().isDebug()) {
                log.info("No brokerServiceName found for SQL Query [%s], Context [%s]. Using default selector for [%s].", new Object[]{sqlQuery.getQuery(), sqlQuery.getContext(), this.tierConfig.getDefaultBrokerServiceName()});
            }
        }
        return this.getServerPair(brokerServiceName);
    }

    public Pair<String, Server> getDefaultLookup() {
        String brokerServiceName = this.tierConfig.getDefaultBrokerServiceName();
        return new Pair((Object)brokerServiceName, (Object)this.servers.get(brokerServiceName).pick());
    }

    public Map<String, List<Server>> getAllBrokers() {
        return Maps.transformValues(this.servers, (Function)new Function<NodesHolder, List<Server>>(){

            public List<Server> apply(NodesHolder input) {
                return input.getAll();
            }
        });
    }

    private static class NodesHolder {
        private AtomicInteger roundRobinIndex = new AtomicInteger(-1);
        private Map<String, Server> nodesMap = new HashMap<String, Server>();
        private ImmutableList<Server> nodes = ImmutableList.of();

        private NodesHolder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(String id, Server node) {
            NodesHolder nodesHolder = this;
            synchronized (nodesHolder) {
                this.nodesMap.put(id, node);
                this.nodes = ImmutableList.copyOf(this.nodesMap.values());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(String id) {
            NodesHolder nodesHolder = this;
            synchronized (nodesHolder) {
                if (this.nodesMap.remove(id) != null) {
                    this.nodes = ImmutableList.copyOf(this.nodesMap.values());
                }
            }
        }

        List<Server> getAll() {
            return this.nodes;
        }

        Server pick() {
            ImmutableList<Server> currNodes = this.nodes;
            if (currNodes.size() == 0) {
                return null;
            }
            return (Server)currNodes.get(this.getIndex(currNodes));
        }

        int getIndex(ImmutableList<Server> currNodes) {
            int nextIndex;
            int index;
            do {
                if ((nextIndex = (index = this.roundRobinIndex.get()) + 1) < currNodes.size()) continue;
                nextIndex = 0;
            } while (!this.roundRobinIndex.compareAndSet(index, nextIndex));
            return nextIndex;
        }
    }
}

