/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import org.apache.druid.math.expr.BinaryEvalOpExprBase;
import org.apache.druid.math.expr.BinaryOpExprBase;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.math.expr.vector.VectorMathProcessors;

final class BinDivExpr
extends BinaryEvalOpExprBase {
    BinDivExpr(String op, Expr left, Expr right) {
        super(op, left, right);
    }

    @Override
    protected BinaryOpExprBase copy(Expr left, Expr right) {
        return new BinDivExpr(this.op, left, right);
    }

    @Override
    protected long evalLong(long left, long right) {
        return left / right;
    }

    @Override
    protected double evalDouble(double left, double right) {
        return left / right;
    }

    @Override
    public boolean canVectorize(Expr.InputBindingInspector inspector) {
        return inspector.areScalar(this.left, this.right) && inspector.canVectorize(this.left, this.right);
    }

    @Override
    public <T> ExprVectorProcessor<T> asVectorProcessor(Expr.VectorInputBindingInspector inspector) {
        return VectorMathProcessors.divide(inspector, this.left, this.right);
    }
}

