/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Supplier;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.AggregatorUtil;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.DoubleMaxAggregateCombiner;
import org.apache.druid.query.aggregation.DoubleMaxAggregator;
import org.apache.druid.query.aggregation.DoubleMaxBufferAggregator;
import org.apache.druid.query.aggregation.DoubleMaxVectorAggregator;
import org.apache.druid.query.aggregation.SimpleDoubleAggregatorFactory;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorValueSelector;

public class DoubleMaxAggregatorFactory
extends SimpleDoubleAggregatorFactory {
    private final Supplier<byte[]> cacheKey;

    @JsonCreator
    public DoubleMaxAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="expression") @Nullable String expression, @JacksonInject ExprMacroTable macroTable) {
        super(macroTable, name, fieldName, expression);
        this.cacheKey = AggregatorUtil.getSimpleAggregatorCacheKeySupplier((byte)3, fieldName, (Supplier<Expr>)this.fieldExpression);
    }

    public DoubleMaxAggregatorFactory(String name, String fieldName) {
        this(name, fieldName, null, ExprMacroTable.nil());
    }

    @Override
    protected double nullValue() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    protected Aggregator buildAggregator(BaseDoubleColumnValueSelector selector) {
        return new DoubleMaxAggregator(selector);
    }

    @Override
    protected BufferAggregator buildBufferAggregator(BaseDoubleColumnValueSelector selector) {
        return new DoubleMaxBufferAggregator(selector);
    }

    @Override
    protected VectorAggregator factorizeVector(VectorColumnSelectorFactory columnSelectorFactory, VectorValueSelector selector) {
        return new DoubleMaxVectorAggregator(selector);
    }

    @Override
    @Nullable
    public Object combine(@Nullable Object lhs, @Nullable Object rhs) {
        if (rhs == null) {
            return lhs;
        }
        if (lhs == null) {
            return rhs;
        }
        return DoubleMaxAggregator.combineValues(lhs, rhs);
    }

    @Override
    public AggregateCombiner makeAggregateCombiner() {
        return new DoubleMaxAggregateCombiner();
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new DoubleMaxAggregatorFactory(this.name, this.name, null, this.macroTable);
    }

    @Override
    public AggregatorFactory withName(String newName) {
        return new DoubleMaxAggregatorFactory(newName, this.getFieldName(), this.getExpression(), this.macroTable);
    }

    @Override
    public byte[] getCacheKey() {
        return (byte[])this.cacheKey.get();
    }

    public String toString() {
        return "DoubleMaxAggregatorFactory{fieldName='" + this.fieldName + '\'' + ", expression='" + this.expression + '\'' + ", name='" + this.name + '\'' + '}';
    }
}

