/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expression;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.ISODateTimeFormat;

public class TimestampParseExprMacro
implements ExprMacroTable.ExprMacro {
    private static final String FN_NAME = "timestamp_parse";

    @Override
    public String name() {
        return FN_NAME;
    }

    @Override
    public Expr apply(List<Expr> args) {
        this.validationHelperCheckArgumentRange(args, 1, 3);
        final Expr arg = args.get(0);
        String formatString = args.size() > 1 ? (String)args.get(1).getLiteralValue() : null;
        DateTimeZone timeZone = args.size() > 2 && args.get(2).getLiteralValue() != null ? DateTimes.inferTzFromString((String)args.get(2).getLiteralValue()) : DateTimeZone.UTC;
        final DateTimes.UtcFormatter formatter = formatString == null ? TimestampParseExprMacro.createDefaultParser(timeZone) : DateTimes.wrapFormatter(DateTimeFormat.forPattern((String)formatString).withZone(timeZone));
        class TimestampParseExpr
        extends ExprMacroTable.BaseScalarMacroFunctionExpr {
            TimestampParseExpr(List<Expr> args) {
                super(this$0, args);
            }

            @Override
            @Nonnull
            public ExprEval eval(Expr.ObjectBinding bindings) {
                String value = arg.eval(bindings).asString();
                if (value == null) {
                    return ExprEval.of(null);
                }
                try {
                    return ExprEval.of(formatter.parse(value).getMillis());
                }
                catch (IllegalArgumentException e) {
                    return ExprEval.of(null);
                }
            }

            @Override
            @Nullable
            public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                return ExpressionType.LONG;
            }
        }
        return new TimestampParseExpr(args);
    }

    private static DateTimes.UtcFormatter createDefaultParser(DateTimeZone timeZone) {
        DateTimeFormatter offsetElement = new DateTimeFormatterBuilder().appendTimeZoneOffset("Z", true, 2, 4).toFormatter();
        DateTimeParser timeOrOffset = new DateTimeFormatterBuilder().append(null, new DateTimeParser[]{new DateTimeFormatterBuilder().appendLiteral('T').toParser(), new DateTimeFormatterBuilder().appendLiteral(' ').toParser()}).appendOptional(ISODateTimeFormat.timeElementParser().getParser()).appendOptional(offsetElement.getParser()).toParser();
        return DateTimes.wrapFormatter(new DateTimeFormatterBuilder().append(ISODateTimeFormat.dateElementParser()).appendOptional(timeOrOffset).toFormatter().withZone(timeZone));
    }
}

