/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde;

import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.data.Indexed;

public abstract class CombineFirstTwoEntriesIndexed<T>
implements Indexed<T> {
    private static final int FIRST_ID = 0;
    protected final Indexed<T> delegate;

    protected CombineFirstTwoEntriesIndexed(Indexed<T> delegate) {
        this.delegate = delegate;
        if (delegate.size() < 2) {
            throw new ISE("Size[%s] must be >= 2", delegate.size());
        }
    }

    public static <T> CombineFirstTwoEntriesIndexed<T> returnNull(Indexed<T> delegate) {
        return new CombineFirstTwoEntriesIndexed<T>((Indexed)delegate){

            @Override
            @Nullable
            protected T newFirstValue() {
                return null;
            }
        };
    }

    public static CombineFirstTwoEntriesIndexed<ImmutableBitmap> unionBitmaps(final BitmapFactory bitmapFactory, Indexed<ImmutableBitmap> delegate) {
        return new CombineFirstTwoEntriesIndexed<ImmutableBitmap>(delegate){

            @Override
            @Nullable
            protected ImmutableBitmap newFirstValue() {
                return bitmapFactory.union((Iterable<ImmutableBitmap>)ImmutableList.of((Object)((ImmutableBitmap)this.delegate.get(0)), (Object)((ImmutableBitmap)this.delegate.get(1))));
            }
        };
    }

    @Nullable
    protected abstract T newFirstValue();

    @Override
    public int size() {
        return this.delegate.size() - 1;
    }

    @Override
    @Nullable
    public T get(int index) {
        if (index == 0) {
            return this.newFirstValue();
        }
        return this.delegate.get(index + 1);
    }

    @Override
    public int indexOf(@Nullable T value) {
        if (Objects.equals(this.newFirstValue(), value)) {
            return 0;
        }
        int index = this.delegate.indexOf(value);
        if (index > 1) {
            return index - 1;
        }
        if (index >= 0) {
            return -2;
        }
        if (index >= -2) {
            return -2;
        }
        return index + 1;
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator it = this.delegate.iterator();
        it.next();
        it.next();
        class CoalescingIndexedIterator
        implements Iterator<T> {
            boolean returnedFirstValue;

            CoalescingIndexedIterator() {
            }

            @Override
            public boolean hasNext() {
                return !this.returnedFirstValue || it.hasNext();
            }

            @Override
            public T next() {
                if (!this.returnedFirstValue) {
                    this.returnedFirstValue = true;
                    return CombineFirstTwoEntriesIndexed.this.newFirstValue();
                }
                return it.next();
            }
        }
        return new CoalescingIndexedIterator();
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        this.delegate.inspectRuntimeShape(inspector);
    }

    @Override
    public boolean isSorted() {
        return this.delegate.isSorted();
    }
}

