/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.vector.ExprEvalVector;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public class ExpressionVectorValueSelector
implements VectorValueSelector {
    private final Expr.VectorInputBinding bindings;
    private final ExprVectorProcessor<?> processor;
    private final float[] floats;
    private @MonotonicNonNull ExprEvalVector<?> evalResult;
    private int currentOffsetId = -1;
    private int currentFloatsId = -1;

    public ExpressionVectorValueSelector(ExprVectorProcessor<?> processor, Expr.VectorInputBinding bindings) {
        this.processor = (ExprVectorProcessor)Preconditions.checkNotNull(processor, (Object)"processor");
        this.bindings = (Expr.VectorInputBinding)Preconditions.checkNotNull((Object)bindings, (Object)"bindings");
        this.floats = new float[bindings.getMaxVectorSize()];
    }

    @Override
    public long[] getLongVector() {
        this.eval();
        return this.evalResult.getLongVector();
    }

    @Override
    public float[] getFloatVector() {
        if (this.currentFloatsId != this.bindings.getCurrentVectorId()) {
            this.eval();
            this.currentFloatsId = this.currentOffsetId;
            double[] doubles = this.evalResult.getDoubleVector();
            for (int i = 0; i < this.bindings.getCurrentVectorSize(); ++i) {
                this.floats[i] = (float)doubles[i];
            }
        }
        return this.floats;
    }

    @Override
    public double[] getDoubleVector() {
        this.eval();
        return this.evalResult.getDoubleVector();
    }

    @Override
    @Nullable
    public boolean[] getNullVector() {
        this.eval();
        return this.evalResult.getNullVector();
    }

    @Override
    public int getMaxVectorSize() {
        return this.bindings.getMaxVectorSize();
    }

    @Override
    public int getCurrentVectorSize() {
        return this.bindings.getCurrentVectorSize();
    }

    private void eval() {
        if (this.currentOffsetId != this.bindings.getCurrentVectorId()) {
            this.currentOffsetId = this.bindings.getCurrentVectorId();
            this.evalResult = this.processor.evalVector(this.bindings);
        }
    }
}

