/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.sql;

import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.druid.catalog.model.ColumnSpec;
import org.apache.druid.catalog.model.Columns;
import org.apache.druid.catalog.model.ResolvedTable;
import org.apache.druid.catalog.model.TableId;
import org.apache.druid.catalog.model.facade.DatasourceFacade;
import org.apache.druid.catalog.model.table.DatasourceDefn;
import org.apache.druid.catalog.sync.MetadataCatalog;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.planner.CatalogResolver;
import org.apache.druid.sql.calcite.table.DatasourceMetadata;
import org.apache.druid.sql.calcite.table.DatasourceTable;
import org.apache.druid.sql.calcite.table.DruidTable;

public class LiveCatalogResolver
implements CatalogResolver {
    private final MetadataCatalog catalog;

    @Inject
    public LiveCatalogResolver(MetadataCatalog catalog) {
        this.catalog = catalog;
    }

    @Nullable
    private DatasourceFacade datasourceSpec(String name) {
        TableId tableId = TableId.datasource((String)name);
        ResolvedTable table = this.catalog.resolveTable(tableId);
        if (table == null) {
            return null;
        }
        if (!DatasourceDefn.isDatasource((ResolvedTable)table)) {
            return null;
        }
        return new DatasourceFacade(table);
    }

    public DruidTable resolveDatasource(String name, DatasourceTable.PhysicalDatasourceMetadata dsMetadata) {
        DatasourceFacade dsSpec = this.datasourceSpec(name);
        if (dsSpec == null) {
            return dsMetadata == null ? null : new DatasourceTable(dsMetadata);
        }
        if (dsMetadata == null) {
            return this.emptyDatasource(name, dsSpec);
        }
        return this.mergeDatasource(dsMetadata, dsSpec);
    }

    private DruidTable emptyDatasource(String name, DatasourceFacade dsSpec) {
        RowSignature.Builder builder = RowSignature.builder();
        HashMap<String, DatasourceTable.EffectiveColumnMetadata> columns = new HashMap<String, DatasourceTable.EffectiveColumnMetadata>();
        boolean hasTime = false;
        for (ColumnSpec col : dsSpec.columns()) {
            DatasourceTable.EffectiveColumnMetadata colMetadata = this.columnFromCatalog(col, null);
            if (colMetadata.name().equals("__time")) {
                hasTime = true;
            }
            builder.add(col.name(), colMetadata.druidType());
            columns.put(col.name(), colMetadata);
        }
        if (!hasTime) {
            columns.put("__time", new DatasourceTable.EffectiveColumnMetadata("__time", ColumnType.LONG));
            builder = RowSignature.builder().add("__time", ColumnType.LONG).addAll(builder.build());
        }
        DatasourceTable.PhysicalDatasourceMetadata mergedMetadata = new DatasourceTable.PhysicalDatasourceMetadata(new TableDataSource(name), builder.build(), false, false);
        return new DatasourceTable(mergedMetadata.getRowSignature(), (DatasourceMetadata)mergedMetadata, new DatasourceTable.EffectiveMetadata(dsSpec, columns, true));
    }

    private DatasourceTable.EffectiveColumnMetadata columnFromCatalog(ColumnSpec col, ColumnType physicalType) {
        ColumnType type = Columns.druidType((ColumnSpec)col);
        if (type == null) {
            type = physicalType == null ? ColumnType.STRING : physicalType;
        }
        return new DatasourceTable.EffectiveColumnMetadata(col.name(), type);
    }

    private DruidTable mergeDatasource(DatasourceTable.PhysicalDatasourceMetadata dsMetadata, DatasourceFacade dsSpec) {
        DatasourceTable.EffectiveColumnMetadata colMetadata;
        ColumnType physicalType;
        RowSignature physicalSchema = dsMetadata.getRowSignature();
        HashSet physicalCols = new HashSet(physicalSchema.getColumnNames());
        RowSignature.Builder builder = RowSignature.builder();
        HashMap<String, DatasourceTable.EffectiveColumnMetadata> columns = new HashMap<String, DatasourceTable.EffectiveColumnMetadata>();
        for (ColumnSpec col : dsSpec.columns()) {
            physicalType = null;
            if (physicalCols.remove(col.name())) {
                physicalType = (ColumnType)dsMetadata.getRowSignature().getColumnType(col.name()).get();
            }
            colMetadata = this.columnFromCatalog(col, physicalType);
            builder.add(col.name(), colMetadata.druidType());
            columns.put(col.name(), colMetadata);
        }
        if (dsSpec.hiddenColumns() != null) {
            for (String colName : dsSpec.hiddenColumns()) {
                physicalCols.remove(colName);
            }
        }
        for (int i = 0; i < physicalSchema.size(); ++i) {
            String colName;
            colName = physicalSchema.getColumnName(i);
            if (!physicalCols.contains(colName)) continue;
            physicalType = (ColumnType)dsMetadata.getRowSignature().getColumnType(colName).get();
            colMetadata = DatasourceTable.EffectiveColumnMetadata.fromPhysical((String)colName, (ColumnType)physicalType);
            columns.put(colName, colMetadata);
            builder.add(colName, physicalType);
        }
        DatasourceTable.EffectiveMetadata effectiveMetadata = new DatasourceTable.EffectiveMetadata(dsSpec, columns, false);
        return new DatasourceTable(builder.build(), (DatasourceMetadata)dsMetadata, effectiveMetadata);
    }

    public boolean ingestRequiresExistingTable() {
        return false;
    }

    public Set<String> getTableNames(Set<String> datasourceNames) {
        Set<String> catalogTableNames = this.catalog.tableNames("druid");
        if (catalogTableNames.isEmpty()) {
            return datasourceNames;
        }
        return ImmutableSet.builder().addAll(datasourceNames).addAll(catalogTableNames).build();
    }
}

