/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.basic.authorization.endpoint;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.security.basic.BasicAuthUtils;
import org.apache.druid.security.basic.BasicSecurityDBResourceException;
import org.apache.druid.security.basic.authorization.BasicRoleBasedAuthorizer;
import org.apache.druid.security.basic.authorization.db.updater.BasicAuthorizerMetadataStorageUpdater;
import org.apache.druid.security.basic.authorization.endpoint.BasicAuthorizerResourceHandler;
import org.apache.druid.security.basic.authorization.entity.BasicAuthorizerGroupMapping;
import org.apache.druid.security.basic.authorization.entity.BasicAuthorizerGroupMappingFull;
import org.apache.druid.security.basic.authorization.entity.BasicAuthorizerRole;
import org.apache.druid.security.basic.authorization.entity.BasicAuthorizerRoleFull;
import org.apache.druid.security.basic.authorization.entity.BasicAuthorizerRoleSimplifiedPermissions;
import org.apache.druid.security.basic.authorization.entity.BasicAuthorizerUser;
import org.apache.druid.security.basic.authorization.entity.BasicAuthorizerUserFull;
import org.apache.druid.security.basic.authorization.entity.BasicAuthorizerUserFullSimplifiedPermissions;
import org.apache.druid.security.basic.authorization.entity.GroupMappingAndRoleMap;
import org.apache.druid.security.basic.authorization.entity.UserAndRoleMap;
import org.apache.druid.server.security.Authorizer;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.ResourceAction;

public class CoordinatorBasicAuthorizerResourceHandler
implements BasicAuthorizerResourceHandler {
    private static final Logger log = new Logger(CoordinatorBasicAuthorizerResourceHandler.class);
    private final BasicAuthorizerMetadataStorageUpdater storageUpdater;
    private final Map<String, BasicRoleBasedAuthorizer> authorizerMap;
    private final ObjectMapper objectMapper;

    @Inject
    public CoordinatorBasicAuthorizerResourceHandler(BasicAuthorizerMetadataStorageUpdater storageUpdater, AuthorizerMapper authorizerMapper, @Smile ObjectMapper objectMapper) {
        this.storageUpdater = storageUpdater;
        this.objectMapper = objectMapper;
        this.authorizerMap = new HashMap<String, BasicRoleBasedAuthorizer>();
        for (Map.Entry authorizerEntry : authorizerMapper.getAuthorizerMap().entrySet()) {
            String authorizerName = (String)authorizerEntry.getKey();
            Authorizer authorizer = (Authorizer)authorizerEntry.getValue();
            if (!(authorizer instanceof BasicRoleBasedAuthorizer)) continue;
            this.authorizerMap.put(authorizerName, (BasicRoleBasedAuthorizer)authorizer);
        }
    }

    @Override
    public Response getAllUsers(String authorizerName) {
        BasicRoleBasedAuthorizer authorizer = this.authorizerMap.get(authorizerName);
        if (authorizer == null) {
            return CoordinatorBasicAuthorizerResourceHandler.makeResponseForAuthorizerNotFound(authorizerName);
        }
        Map<String, BasicAuthorizerUser> userMap = BasicAuthUtils.deserializeAuthorizerUserMap(this.objectMapper, this.storageUpdater.getCurrentUserMapBytes(authorizerName));
        return Response.ok(userMap.keySet()).build();
    }

    @Override
    public Response getAllGroupMappings(String authorizerName) {
        BasicRoleBasedAuthorizer authorizer = this.authorizerMap.get(authorizerName);
        if (authorizer == null) {
            return CoordinatorBasicAuthorizerResourceHandler.makeResponseForAuthorizerNotFound(authorizerName);
        }
        Map<String, BasicAuthorizerGroupMapping> groupMappingMap = BasicAuthUtils.deserializeAuthorizerGroupMappingMap(this.objectMapper, this.storageUpdater.getCurrentGroupMappingMapBytes(authorizerName));
        return Response.ok(groupMappingMap.keySet()).build();
    }

    @Override
    public Response getUser(String authorizerName, String userName, boolean isFull, boolean simplifyPermissions) {
        BasicRoleBasedAuthorizer authorizer = this.authorizerMap.get(authorizerName);
        if (authorizer == null) {
            return CoordinatorBasicAuthorizerResourceHandler.makeResponseForAuthorizerNotFound(authorizerName);
        }
        if (isFull) {
            return this.getUserFull(authorizerName, userName, simplifyPermissions);
        }
        return this.getUserSimple(authorizerName, userName);
    }

    @Override
    public Response getGroupMapping(String authorizerName, String groupMappingName, boolean isFull) {
        BasicRoleBasedAuthorizer authorizer = this.authorizerMap.get(authorizerName);
        if (authorizer == null) {
            return CoordinatorBasicAuthorizerResourceHandler.makeResponseForAuthorizerNotFound(authorizerName);
        }
        if (isFull) {
            return this.getGroupMappingFull(authorizerName, groupMappingName);
        }
        return this.getGroupMappingSimple(authorizerName, groupMappingName);
    }

    @Override
    public Response createUser(String authorizerName, String userName) {
        BasicRoleBasedAuthorizer authorizer = this.authorizerMap.get(authorizerName);
        if (authorizer == null) {
            return CoordinatorBasicAuthorizerResourceHandler.makeResponseForAuthorizerNotFound(authorizerName);
        }
        try {
            this.storageUpdater.createUser(authorizerName, userName);
            return Response.ok().build();
        }
        catch (BasicSecurityDBResourceException cfe) {
            return CoordinatorBasicAuthorizerResourceHandler.makeResponseForBasicSecurityDBResourceException(cfe);
        }
    }

    @Override
    public Response createGroupMapping(String authorizerName, BasicAuthorizerGroupMapping groupMapping) {
        BasicRoleBasedAuthorizer authorizer = this.authorizerMap.get(authorizerName);
        if (authorizer == null) {
            return CoordinatorBasicAuthorizerResourceHandler.makeResponseForAuthorizerNotFound(authorizerName);
        }
        try {
            this.storageUpdater.createGroupMapping(authorizerName, groupMapping);
            return Response.ok().build();
        }
        catch (BasicSecurityDBResourceException cfe) {
            return CoordinatorBasicAuthorizerResourceHandler.makeResponseForBasicSecurityDBResourceException(cfe);
        }
    }

    @Override
    public Response deleteUser(String authorizerName, String userName) {
        BasicRoleBasedAuthorizer authorizer = this.authorizerMap.get(authorizerName);
        if (authorizer == null) {
            return CoordinatorBasicAuthorizerResourceHandler.makeResponseForAuthorizerNotFound(authorizerName);
        }
        try {
            this.storageUpdater.deleteUser(authorizerName, userName);
            return Response.ok().build();
        }
        catch (BasicSecurityDBResourceException cfe) {
            return CoordinatorBasicAuthorizerResourceHandler.makeResponseForBasicSecurityDBResourceException(cfe);
        }
    }

    @Override
    public Response deleteGroupMapping(String authorizerName, String groupMappingName) {
        BasicRoleBasedAuthorizer authorizer = this.authorizerMap.get(authorizerName);
        if (authorizer == null) {
            return CoordinatorBasicAuthorizerResourceHandler.makeResponseForAuthorizerNotFound(authorizerName);
        }
        try {
            this.storageUpdater.deleteGroupMapping(authorizerName, groupMappingName);
            return Response.ok().build();
        }
        catch (BasicSecurityDBResourceException cfe) {
            return CoordinatorBasicAuthorizerResourceHandler.makeResponseForBasicSecurityDBResourceException(cfe);
        }
    }

    @Override
    public Response getAllRoles(String authorizerName) {
        BasicRoleBasedAuthorizer authorizer = this.authorizerMap.get(authorizerName);
        if (authorizer == null) {
            return CoordinatorBasicAuthorizerResourceHandler.makeResponseForAuthorizerNotFound(authorizerName);
        }
        Map<String, BasicAuthorizerRole> roleMap = BasicAuthUtils.deserializeAuthorizerRoleMap(this.objectMapper, this.storageUpdater.getCurrentRoleMapBytes(authorizerName));
        return Response.ok(roleMap.keySet()).build();
    }

    @Override
    public Response getRole(String authorizerName, String roleName, boolean isFull, boolean simplifyPermissions) {
        BasicRoleBasedAuthorizer authorizer = this.authorizerMap.get(authorizerName);
        if (authorizer == null) {
            return CoordinatorBasicAuthorizerResourceHandler.makeResponseForAuthorizerNotFound(authorizerName);
        }
        if (isFull) {
            return this.getRoleFull(authorizerName, roleName, simplifyPermissions);
        }
        return this.getRoleSimple(authorizerName, roleName, simplifyPermissions);
    }

    @Override
    public Response createRole(String authorizerName, String roleName) {
        BasicRoleBasedAuthorizer authorizer = this.authorizerMap.get(authorizerName);
        if (authorizer == null) {
            return CoordinatorBasicAuthorizerResourceHandler.makeResponseForAuthorizerNotFound(authorizerName);
        }
        try {
            this.storageUpdater.createRole(authorizerName, roleName);
            return Response.ok().build();
        }
        catch (BasicSecurityDBResourceException cfe) {
            return CoordinatorBasicAuthorizerResourceHandler.makeResponseForBasicSecurityDBResourceException(cfe);
        }
    }

    @Override
    public Response deleteRole(String authorizerName, String roleName) {
        BasicRoleBasedAuthorizer authorizer = this.authorizerMap.get(authorizerName);
        if (authorizer == null) {
            return CoordinatorBasicAuthorizerResourceHandler.makeResponseForAuthorizerNotFound(authorizerName);
        }
        try {
            this.storageUpdater.deleteRole(authorizerName, roleName);
            return Response.ok().build();
        }
        catch (BasicSecurityDBResourceException cfe) {
            return CoordinatorBasicAuthorizerResourceHandler.makeResponseForBasicSecurityDBResourceException(cfe);
        }
    }

    @Override
    public Response assignRoleToUser(String authorizerName, String userName, String roleName) {
        BasicRoleBasedAuthorizer authorizer = this.authorizerMap.get(authorizerName);
        if (authorizer == null) {
            return CoordinatorBasicAuthorizerResourceHandler.makeResponseForAuthorizerNotFound(authorizerName);
        }
        try {
            this.storageUpdater.assignUserRole(authorizerName, userName, roleName);
            return Response.ok().build();
        }
        catch (BasicSecurityDBResourceException cfe) {
            return CoordinatorBasicAuthorizerResourceHandler.makeResponseForBasicSecurityDBResourceException(cfe);
        }
    }

    @Override
    public Response assignRoleToGroupMapping(String authorizerName, String groupMappingName, String roleName) {
        BasicRoleBasedAuthorizer authorizer = this.authorizerMap.get(authorizerName);
        if (authorizer == null) {
            return CoordinatorBasicAuthorizerResourceHandler.makeResponseForAuthorizerNotFound(authorizerName);
        }
        try {
            this.storageUpdater.assignGroupMappingRole(authorizerName, groupMappingName, roleName);
            return Response.ok().build();
        }
        catch (BasicSecurityDBResourceException cfe) {
            return CoordinatorBasicAuthorizerResourceHandler.makeResponseForBasicSecurityDBResourceException(cfe);
        }
    }

    @Override
    public Response unassignRoleFromUser(String authorizerName, String userName, String roleName) {
        BasicRoleBasedAuthorizer authorizer = this.authorizerMap.get(authorizerName);
        if (authorizer == null) {
            return CoordinatorBasicAuthorizerResourceHandler.makeResponseForAuthorizerNotFound(authorizerName);
        }
        try {
            this.storageUpdater.unassignUserRole(authorizerName, userName, roleName);
            return Response.ok().build();
        }
        catch (BasicSecurityDBResourceException cfe) {
            return CoordinatorBasicAuthorizerResourceHandler.makeResponseForBasicSecurityDBResourceException(cfe);
        }
    }

    @Override
    public Response unassignRoleFromGroupMapping(String authorizerName, String groupMappingName, String roleName) {
        BasicRoleBasedAuthorizer authorizer = this.authorizerMap.get(authorizerName);
        if (authorizer == null) {
            return CoordinatorBasicAuthorizerResourceHandler.makeResponseForAuthorizerNotFound(authorizerName);
        }
        try {
            this.storageUpdater.unassignGroupMappingRole(authorizerName, groupMappingName, roleName);
            return Response.ok().build();
        }
        catch (BasicSecurityDBResourceException cfe) {
            return CoordinatorBasicAuthorizerResourceHandler.makeResponseForBasicSecurityDBResourceException(cfe);
        }
    }

    @Override
    public Response setRolePermissions(String authorizerName, String roleName, List<ResourceAction> permissions) {
        BasicRoleBasedAuthorizer authorizer = this.authorizerMap.get(authorizerName);
        if (authorizer == null) {
            return CoordinatorBasicAuthorizerResourceHandler.makeResponseForAuthorizerNotFound(authorizerName);
        }
        try {
            this.storageUpdater.setPermissions(authorizerName, roleName, permissions);
            return Response.ok().build();
        }
        catch (BasicSecurityDBResourceException cfe) {
            return CoordinatorBasicAuthorizerResourceHandler.makeResponseForBasicSecurityDBResourceException(cfe);
        }
    }

    @Override
    public Response getRolePermissions(String authorizerName, String roleName) {
        BasicRoleBasedAuthorizer authorizer = this.authorizerMap.get(authorizerName);
        if (authorizer == null) {
            return CoordinatorBasicAuthorizerResourceHandler.makeResponseForAuthorizerNotFound(authorizerName);
        }
        return this.getPermissions(authorizerName, roleName);
    }

    @Override
    public Response getCachedUserMaps(String authorizerName) {
        BasicRoleBasedAuthorizer authorizer = this.authorizerMap.get(authorizerName);
        if (authorizer == null) {
            return CoordinatorBasicAuthorizerResourceHandler.makeResponseForAuthorizerNotFound(authorizerName);
        }
        UserAndRoleMap userAndRoleMap = new UserAndRoleMap(this.storageUpdater.getCachedUserMap(authorizerName), this.storageUpdater.getCachedRoleMap(authorizerName));
        return Response.ok((Object)userAndRoleMap).build();
    }

    @Override
    public Response getCachedGroupMappingMaps(String authorizerName) {
        BasicRoleBasedAuthorizer authorizer = this.authorizerMap.get(authorizerName);
        if (authorizer == null) {
            return CoordinatorBasicAuthorizerResourceHandler.makeResponseForAuthorizerNotFound(authorizerName);
        }
        GroupMappingAndRoleMap groupMappingAndRoleMap = new GroupMappingAndRoleMap(this.storageUpdater.getCachedGroupMappingMap(authorizerName), this.storageUpdater.getCachedRoleMap(authorizerName));
        return Response.ok((Object)groupMappingAndRoleMap).build();
    }

    @Override
    public Response refreshAll() {
        this.storageUpdater.refreshAllNotification();
        return Response.ok().build();
    }

    @Override
    public Response authorizerUserUpdateListener(String authorizerName, byte[] serializedUserAndRoleMap) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @Override
    public Response authorizerGroupMappingUpdateListener(String authorizerName, byte[] serializedGroupMappingAndRoleMap) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @Override
    public Response getLoadStatus() {
        HashMap loadStatus = new HashMap();
        this.authorizerMap.forEach((authorizerName, authorizer) -> loadStatus.put(authorizerName, this.storageUpdater.getCachedUserMap((String)authorizerName) != null && this.storageUpdater.getCachedGroupMappingMap((String)authorizerName) != null && this.storageUpdater.getCachedRoleMap((String)authorizerName) != null));
        return Response.ok(loadStatus).build();
    }

    private static Response makeResponseForAuthorizerNotFound(String authorizerName) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ImmutableMap.of((Object)"error", (Object)StringUtils.format((String)"Basic authorizer with name [%s] does not exist.", (Object[])new Object[]{authorizerName}))).build();
    }

    private static Response makeResponseForBasicSecurityDBResourceException(BasicSecurityDBResourceException bsre) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ImmutableMap.of((Object)"error", (Object)bsre.getMessage())).build();
    }

    private Response getUserSimple(String authorizerName, String userName) {
        Map<String, BasicAuthorizerUser> userMap = BasicAuthUtils.deserializeAuthorizerUserMap(this.objectMapper, this.storageUpdater.getCurrentUserMapBytes(authorizerName));
        try {
            BasicAuthorizerUser user = userMap.get(userName);
            if (user == null) {
                throw new BasicSecurityDBResourceException("User [%s] does not exist.", userName);
            }
            return Response.ok((Object)user).build();
        }
        catch (BasicSecurityDBResourceException e) {
            return CoordinatorBasicAuthorizerResourceHandler.makeResponseForBasicSecurityDBResourceException(e);
        }
    }

    private Response getUserFull(String authorizerName, String userName, boolean simplifyPermissions) {
        Map<String, BasicAuthorizerUser> userMap = BasicAuthUtils.deserializeAuthorizerUserMap(this.objectMapper, this.storageUpdater.getCurrentUserMapBytes(authorizerName));
        try {
            BasicAuthorizerUser user = userMap.get(userName);
            if (user == null) {
                throw new BasicSecurityDBResourceException("User [%s] does not exist.", userName);
            }
            Map<String, BasicAuthorizerRole> roleMap = BasicAuthUtils.deserializeAuthorizerRoleMap(this.objectMapper, this.storageUpdater.getCurrentRoleMapBytes(authorizerName));
            if (simplifyPermissions) {
                Set<BasicAuthorizerRoleSimplifiedPermissions> roles = this.getRolesForUserWithSimplifiedPermissions(user, roleMap);
                BasicAuthorizerUserFullSimplifiedPermissions fullUser = new BasicAuthorizerUserFullSimplifiedPermissions(userName, roles);
                return Response.ok((Object)fullUser).build();
            }
            Set<BasicAuthorizerRole> roles = this.getRolesForUser(user, roleMap);
            BasicAuthorizerUserFull fullUser = new BasicAuthorizerUserFull(userName, roles);
            return Response.ok((Object)fullUser).build();
        }
        catch (BasicSecurityDBResourceException e) {
            return CoordinatorBasicAuthorizerResourceHandler.makeResponseForBasicSecurityDBResourceException(e);
        }
    }

    private Set<BasicAuthorizerRoleSimplifiedPermissions> getRolesForUserWithSimplifiedPermissions(BasicAuthorizerUser user, Map<String, BasicAuthorizerRole> roleMap) {
        HashSet<BasicAuthorizerRoleSimplifiedPermissions> roles = new HashSet<BasicAuthorizerRoleSimplifiedPermissions>();
        for (String roleName : user.getRoles()) {
            BasicAuthorizerRole role = roleMap.get(roleName);
            if (role == null) {
                log.error("User [%s] had role [%s], but role object was not found.", new Object[]{user.getName(), roleName});
                continue;
            }
            BasicAuthorizerRoleSimplifiedPermissions roleWithSimplifiedPermissions = new BasicAuthorizerRoleSimplifiedPermissions(role.getName(), null, BasicAuthorizerRoleSimplifiedPermissions.convertPermissions(role.getPermissions()));
            roles.add(roleWithSimplifiedPermissions);
        }
        return roles;
    }

    private Set<BasicAuthorizerRole> getRolesForUser(BasicAuthorizerUser user, Map<String, BasicAuthorizerRole> roleMap) {
        HashSet<BasicAuthorizerRole> roles = new HashSet<BasicAuthorizerRole>();
        for (String roleName : user.getRoles()) {
            BasicAuthorizerRole role = roleMap.get(roleName);
            if (role == null) {
                log.error("User [%s] had role [%s], but role object was not found.", new Object[]{user.getName(), roleName});
                continue;
            }
            roles.add(role);
        }
        return roles;
    }

    private Response getGroupMappingSimple(String authorizerName, String groupMappingName) {
        Map<String, BasicAuthorizerGroupMapping> groupMappings = BasicAuthUtils.deserializeAuthorizerGroupMappingMap(this.objectMapper, this.storageUpdater.getCurrentGroupMappingMapBytes(authorizerName));
        try {
            BasicAuthorizerGroupMapping groupMapping = groupMappings.get(groupMappingName);
            if (groupMapping == null) {
                throw new BasicSecurityDBResourceException("Group mapping [%s] does not exist.", groupMappingName);
            }
            return Response.ok((Object)groupMapping).build();
        }
        catch (BasicSecurityDBResourceException e) {
            return CoordinatorBasicAuthorizerResourceHandler.makeResponseForBasicSecurityDBResourceException(e);
        }
    }

    private Response getGroupMappingFull(String authorizerName, String groupMappingName) {
        Map<String, BasicAuthorizerGroupMapping> groupMappings = BasicAuthUtils.deserializeAuthorizerGroupMappingMap(this.objectMapper, this.storageUpdater.getCurrentGroupMappingMapBytes(authorizerName));
        try {
            BasicAuthorizerGroupMapping groupMapping = groupMappings.get(groupMappingName);
            if (groupMapping == null) {
                throw new BasicSecurityDBResourceException("Group mapping [%s] does not exist.", groupMappingName);
            }
            Map<String, BasicAuthorizerRole> roleMap = BasicAuthUtils.deserializeAuthorizerRoleMap(this.objectMapper, this.storageUpdater.getCurrentRoleMapBytes(authorizerName));
            HashSet<BasicAuthorizerRole> roles = new HashSet<BasicAuthorizerRole>();
            for (String roleName : groupMapping.getRoles()) {
                BasicAuthorizerRole role = roleMap.get(roleName);
                if (role == null) {
                    log.error("Group mapping [%s] had role [%s], but role was not found.", new Object[]{groupMappingName, roleName});
                    continue;
                }
                roles.add(role);
            }
            BasicAuthorizerGroupMappingFull fullGroup = new BasicAuthorizerGroupMappingFull(groupMapping.getName(), groupMapping.getGroupPattern(), roles);
            return Response.ok((Object)fullGroup).build();
        }
        catch (BasicSecurityDBResourceException e) {
            return CoordinatorBasicAuthorizerResourceHandler.makeResponseForBasicSecurityDBResourceException(e);
        }
    }

    private Response getRoleSimple(String authorizerName, String roleName, boolean simplifyPermissions) {
        Map<String, BasicAuthorizerRole> roleMap = BasicAuthUtils.deserializeAuthorizerRoleMap(this.objectMapper, this.storageUpdater.getCurrentRoleMapBytes(authorizerName));
        try {
            BasicAuthorizerRole role = roleMap.get(roleName);
            if (role == null) {
                throw new BasicSecurityDBResourceException("Role [%s] does not exist.", roleName);
            }
            if (simplifyPermissions) {
                return Response.ok((Object)new BasicAuthorizerRoleSimplifiedPermissions(role, null)).build();
            }
            return Response.ok((Object)role).build();
        }
        catch (BasicSecurityDBResourceException e) {
            return CoordinatorBasicAuthorizerResourceHandler.makeResponseForBasicSecurityDBResourceException(e);
        }
    }

    private Response getRoleFull(String authorizerName, String roleName, boolean simplifyPermissions) {
        Map<String, BasicAuthorizerRole> roleMap = BasicAuthUtils.deserializeAuthorizerRoleMap(this.objectMapper, this.storageUpdater.getCurrentRoleMapBytes(authorizerName));
        try {
            BasicAuthorizerRole role = roleMap.get(roleName);
            if (role == null) {
                throw new BasicSecurityDBResourceException("Role [%s] does not exist.", roleName);
            }
            Map<String, BasicAuthorizerUser> userMap = BasicAuthUtils.deserializeAuthorizerUserMap(this.objectMapper, this.storageUpdater.getCurrentUserMapBytes(authorizerName));
            Map<String, BasicAuthorizerGroupMapping> groupMappingMap = BasicAuthUtils.deserializeAuthorizerGroupMappingMap(this.objectMapper, this.storageUpdater.getCurrentGroupMappingMapBytes(authorizerName));
            HashSet<String> users = new HashSet<String>();
            for (BasicAuthorizerUser basicAuthorizerUser : userMap.values()) {
                if (!basicAuthorizerUser.getRoles().contains(roleName)) continue;
                users.add(basicAuthorizerUser.getName());
            }
            HashSet<String> groupMappings = new HashSet<String>();
            for (BasicAuthorizerGroupMapping group : groupMappingMap.values()) {
                if (!group.getRoles().contains(roleName)) continue;
                groupMappings.add(group.getName());
            }
            if (simplifyPermissions) {
                return Response.ok((Object)new BasicAuthorizerRoleSimplifiedPermissions(role, users)).build();
            }
            BasicAuthorizerRoleFull basicAuthorizerRoleFull = new BasicAuthorizerRoleFull(roleName, users, groupMappings, role.getPermissions());
            return Response.ok((Object)basicAuthorizerRoleFull).build();
        }
        catch (BasicSecurityDBResourceException e) {
            return CoordinatorBasicAuthorizerResourceHandler.makeResponseForBasicSecurityDBResourceException(e);
        }
    }

    private Response getPermissions(String authorizerName, String roleName) {
        Map<String, BasicAuthorizerRole> roleMap = BasicAuthUtils.deserializeAuthorizerRoleMap(this.objectMapper, this.storageUpdater.getCurrentRoleMapBytes(authorizerName));
        try {
            BasicAuthorizerRole role = roleMap.get(roleName);
            if (role == null) {
                throw new BasicSecurityDBResourceException("Role [%s] does not exist.", roleName);
            }
            return Response.ok(role.getPermissions()).build();
        }
        catch (BasicSecurityDBResourceException e) {
            return CoordinatorBasicAuthorizerResourceHandler.makeResponseForBasicSecurityDBResourceException(e);
        }
    }
}

