/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.messages.server;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.druid.common.guava.FutureBox;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.messages.MessageBatch;
import org.apache.druid.messages.server.Outbox;

public class OutboxImpl<MessageType>
implements Outbox<MessageType> {
    private static final int MAX_BATCH_SIZE = 8;
    private final ConcurrentHashMap<String, OutboxQueue<MessageType>> queues = new ConcurrentHashMap();
    private volatile boolean stopped;

    @LifecycleStop
    public void stop() {
        this.stopped = true;
        Iterator<OutboxQueue<MessageType>> it = this.queues.values().iterator();
        while (it.hasNext()) {
            it.next().stop();
            it.remove();
        }
    }

    @Override
    public ListenableFuture<?> sendMessage(String clientHost, MessageType message) {
        if (this.stopped) {
            return Futures.immediateCancelledFuture();
        }
        return this.queues.computeIfAbsent(clientHost, id -> new OutboxQueue()).sendMessage(message);
    }

    @Override
    public ListenableFuture<MessageBatch<MessageType>> getMessages(String clientHost, long epoch, long startWatermark) {
        if (this.stopped) {
            return Futures.immediateCancelledFuture();
        }
        OutboxQueue queue = this.queues.computeIfAbsent(clientHost, id -> new OutboxQueue());
        if (epoch != queue.epoch && epoch != -1L) {
            return Futures.immediateFuture(new MessageBatch(Collections.emptyList(), queue.epoch, 0L));
        }
        return queue.getMessages(startWatermark);
    }

    @Override
    public void resetOutbox(String clientHost) {
        OutboxQueue<MessageType> queue = this.queues.remove(clientHost);
        if (queue != null) {
            queue.stop();
        }
    }

    @VisibleForTesting
    long getOutboxEpoch(String clientHost) {
        OutboxQueue<MessageType> queue = this.queues.get(clientHost);
        return queue != null ? ((OutboxQueue)queue).epoch : -1L;
    }

    public static class OutboxQueue<T> {
        private final long epoch;
        private final FutureBox pendingFutures = new FutureBox();
        @GuardedBy(value="this")
        private long startWatermark = 0L;
        @GuardedBy(value="this")
        private final Deque<Pair<SettableFuture<?>, T>> queue = new ArrayDeque();
        @GuardedBy(value="this")
        private SettableFuture<?> messageAvailableFuture = SettableFuture.create();

        public OutboxQueue() {
            this.epoch = ThreadLocalRandom.current().nextLong() & Long.MAX_VALUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ListenableFuture<?> sendMessage(T message) {
            SettableFuture future = SettableFuture.create();
            OutboxQueue outboxQueue = this;
            synchronized (outboxQueue) {
                this.queue.add(Pair.of((Object)future, message));
                if (!this.messageAvailableFuture.isDone()) {
                    this.messageAvailableFuture.set(null);
                }
            }
            return this.pendingFutures.register((ListenableFuture)future);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ListenableFuture<MessageBatch<T>> getMessages(long newStartWatermark) {
            OutboxQueue outboxQueue = this;
            synchronized (outboxQueue) {
                while (!this.queue.isEmpty() && this.startWatermark < newStartWatermark) {
                    Pair<SettableFuture<?>, T> message = this.queue.poll();
                    ++this.startWatermark;
                    ((SettableFuture)message.lhs).set(null);
                }
                if (this.queue.isEmpty()) {
                    if (this.messageAvailableFuture.isDone()) {
                        this.messageAvailableFuture = SettableFuture.create();
                    }
                    return this.pendingFutures.register(FutureUtils.transform((ListenableFuture)Futures.nonCancellationPropagating(this.messageAvailableFuture), ignored -> {
                        OutboxQueue outboxQueue = this;
                        synchronized (outboxQueue) {
                            return this.nextBatch();
                        }
                    }));
                }
                return this.pendingFutures.register(Futures.immediateFuture(this.nextBatch()));
            }
        }

        void stop() {
            this.pendingFutures.close();
        }

        @GuardedBy(value="this")
        private MessageBatch<T> nextBatch() {
            ArrayList<Object> batch = new ArrayList<Object>();
            Iterator<Pair<SettableFuture<?>, T>> it = this.queue.iterator();
            while (it.hasNext() && batch.size() < 8) {
                batch.add(it.next().rhs);
            }
            return new MessageBatch(batch, this.epoch, this.startWatermark);
        }
    }
}

