/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import org.apache.druid.msq.indexing.error.BaseMSQFault;

@JsonTypeName(value="NotEnoughTemporaryStorageFault")
public class NotEnoughTemporaryStorageFault
extends BaseMSQFault {
    static final String CODE = "NotEnoughTemporaryStorageFault";
    private final long suggestedMinimumStorage;
    private final long configuredTemporaryStorage;

    @JsonCreator
    public NotEnoughTemporaryStorageFault(@JsonProperty(value="suggestedMinimumStorage") long suggestedMinimumStorage, @JsonProperty(value="configuredTemporaryStorage") long configuredTemporaryStorage) {
        super(CODE, "Not enough temporary storage space for intermediate files. Requires at least %,d bytes. (configured = %,d bytes). Increase the limit by increasing tmpStorageBytesPerTask or disable durable storage by setting the context parameter durableShuffleStorage as false.", suggestedMinimumStorage, configuredTemporaryStorage);
        this.suggestedMinimumStorage = suggestedMinimumStorage;
        this.configuredTemporaryStorage = configuredTemporaryStorage;
    }

    @JsonProperty
    public long getSuggestedMinimumStorage() {
        return this.suggestedMinimumStorage;
    }

    @JsonProperty
    public long getConfiguredTemporaryStorage() {
        return this.configuredTemporaryStorage;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NotEnoughTemporaryStorageFault that = (NotEnoughTemporaryStorageFault)o;
        return this.suggestedMinimumStorage == that.suggestedMinimumStorage && this.configuredTemporaryStorage == that.configuredTemporaryStorage;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.suggestedMinimumStorage, this.configuredTemporaryStorage);
    }

    @Override
    public String toString() {
        return "NotEnoughTemporaryStorageFault{suggestedMinimumStorage=" + this.suggestedMinimumStorage + ", configuredTemporaryStorage=" + this.configuredTemporaryStorage + '}';
    }
}

