/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.processor;

import com.google.common.primitives.Ints;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.allocation.MemoryRange;
import org.apache.druid.frame.channel.FrameWithPartition;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.WritableFrameChannel;
import org.apache.druid.frame.key.ClusterBy;
import org.apache.druid.frame.key.FrameComparisonWidget;
import org.apache.druid.frame.key.RowKey;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.FrameProcessors;
import org.apache.druid.frame.processor.ReturnOrAwait;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.frame.read.FrameReaderUtils;
import org.apache.druid.frame.segment.FrameCursor;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.msq.statistics.ClusterByStatisticsCollector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.column.RowSignature;

public class KeyStatisticsCollectionProcessor
implements FrameProcessor<ClusterByStatisticsCollector> {
    private static final int STANDARD_VALUE_SIZE = 1000;
    private static final int STANDARD_ROW_SIZE = 2000;
    private final ReadableFrameChannel inputChannel;
    private final WritableFrameChannel outputChannel;
    private final FrameReader frameReader;
    private final ClusterBy clusterBy;
    private ClusterByStatisticsCollector clusterByStatisticsCollector;

    public KeyStatisticsCollectionProcessor(ReadableFrameChannel inputChannel, WritableFrameChannel outputChannel, FrameReader frameReader, ClusterBy clusterBy, ClusterByStatisticsCollector clusterByStatisticsCollector) {
        this.inputChannel = inputChannel;
        this.outputChannel = outputChannel;
        this.frameReader = frameReader;
        this.clusterBy = clusterBy;
        this.clusterByStatisticsCollector = clusterByStatisticsCollector;
    }

    public List<ReadableFrameChannel> inputChannels() {
        return Collections.singletonList(this.inputChannel);
    }

    public List<WritableFrameChannel> outputChannels() {
        return Collections.singletonList(this.outputChannel);
    }

    public ReturnOrAwait<ClusterByStatisticsCollector> runIncrementally(IntSet readableInputs) throws IOException {
        if (readableInputs.isEmpty()) {
            return ReturnOrAwait.awaitAll((int)1);
        }
        if (this.inputChannel.isFinished()) {
            return ReturnOrAwait.returnObject((Object)this.clusterByStatisticsCollector);
        }
        Frame frame = this.inputChannel.read();
        FrameCursor cursor = FrameProcessors.makeCursor((Frame)frame, (FrameReader)this.frameReader);
        IntSupplier rowWeightSupplier = this.makeRowWeightSupplier(this.frameReader, cursor.getColumnSelectorFactory());
        FrameComparisonWidget comparisonWidget = this.frameReader.makeComparisonWidget(frame, this.clusterBy.getColumns());
        for (int i = 0; i < frame.numRows(); ++i) {
            RowKey key = comparisonWidget.readKey(i);
            this.clusterByStatisticsCollector.add(key, rowWeightSupplier.getAsInt());
            cursor.advance();
        }
        this.outputChannel.write(new FrameWithPartition(frame, -1));
        return ReturnOrAwait.awaitAll((int)1);
    }

    public void cleanup() throws IOException {
        FrameProcessors.closeAll(this.inputChannels(), this.outputChannels(), (Closeable[])new Closeable[]{() -> {
            this.clusterByStatisticsCollector = null;
        }});
    }

    private IntSupplier makeRowWeightSupplier(FrameReader frameReader, ColumnSelectorFactory columnSelectorFactory) {
        Supplier rowMemorySupplier = FrameReaderUtils.makeRowMemorySupplier((ColumnSelectorFactory)columnSelectorFactory, (RowSignature)frameReader.signature());
        int numFields = frameReader.signature().size();
        if (rowMemorySupplier == null) {
            throw new ISE("Can't read row memory from frame. Wrong frame type or signature?", new Object[0]);
        }
        return () -> KeyStatisticsCollectionProcessor.lambda$makeRowWeightSupplier$1((Supplier)rowMemorySupplier, numFields);
    }

    private static /* synthetic */ int lambda$makeRowWeightSupplier$1(Supplier rowMemorySupplier, int numFields) {
        MemoryRange rowMemory = (MemoryRange)rowMemorySupplier.get();
        if (rowMemory == null) {
            throw new ISE("Can't read row memory from frame. Wrong type or signature?", new Object[0]);
        }
        long maxValueLength = 0L;
        long totalLength = 0L;
        long currentValueStartPosition = 4L * (long)numFields;
        for (int i = 0; i < numFields; ++i) {
            long currentValueEndPosition = rowMemory.memory().getInt(rowMemory.start() + 4L * (long)i);
            long valueLength = currentValueEndPosition - currentValueStartPosition;
            if (valueLength > maxValueLength) {
                maxValueLength = valueLength;
            }
            totalLength += valueLength;
            currentValueStartPosition = currentValueEndPosition;
        }
        return 1 + Ints.checkedCast((long)Math.max(maxValueLength / 1000L, totalLength / 2000L));
    }
}

