/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.kernel;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.frame.allocation.MemoryAllocator;
import org.apache.druid.frame.allocation.MemoryAllocatorFactory;
import org.apache.druid.frame.allocation.SingleMemoryAllocatorFactory;
import org.apache.druid.frame.key.ClusterBy;
import org.apache.druid.frame.key.ClusterByPartitions;
import org.apache.druid.frame.key.KeyColumn;
import org.apache.druid.frame.read.FrameReader;
import org.apache.druid.frame.write.FrameWriterFactory;
import org.apache.druid.frame.write.FrameWriters;
import org.apache.druid.java.util.common.Either;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.msq.input.InputSpec;
import org.apache.druid.msq.input.InputSpecs;
import org.apache.druid.msq.kernel.FrameProcessorFactory;
import org.apache.druid.msq.kernel.GlobalSortShuffleSpec;
import org.apache.druid.msq.kernel.ShuffleKind;
import org.apache.druid.msq.kernel.ShuffleSpec;
import org.apache.druid.msq.kernel.StageDefinitionBuilder;
import org.apache.druid.msq.kernel.StageId;
import org.apache.druid.msq.statistics.ClusterByStatisticsCollector;
import org.apache.druid.msq.statistics.ClusterByStatisticsCollectorImpl;
import org.apache.druid.segment.column.RowSignature;

public class StageDefinition {
    private static final int MAX_PARTITIONS = 25000;
    private final StageId id;
    private final List<InputSpec> inputSpecs;
    private final IntSet broadcastInputNumbers;
    private final FrameProcessorFactory processorFactory;
    private final RowSignature signature;
    private final int maxWorkerCount;
    private final boolean shuffleCheckHasMultipleValues;
    @Nullable
    private final ShuffleSpec shuffleSpec;
    private final java.util.function.Supplier<FrameReader> frameReader;

    @JsonCreator
    StageDefinition(@JsonProperty(value="id") StageId id, @JsonProperty(value="input") List<InputSpec> inputSpecs, @JsonProperty(value="broadcast") Set<Integer> broadcastInputNumbers, @JsonProperty(value="processor") FrameProcessorFactory processorFactory, @JsonProperty(value="signature") RowSignature signature, @Nullable @JsonProperty(value="shuffleSpec") ShuffleSpec shuffleSpec, @JsonProperty(value="maxWorkerCount") int maxWorkerCount, @JsonProperty(value="shuffleCheckHasMultipleValues") boolean shuffleCheckHasMultipleValues) {
        this.id = (StageId)Preconditions.checkNotNull((Object)id, (Object)"id");
        this.inputSpecs = (List)Preconditions.checkNotNull(inputSpecs, (Object)"inputSpecs");
        this.broadcastInputNumbers = broadcastInputNumbers == null ? IntSets.emptySet() : (broadcastInputNumbers instanceof IntSet ? (IntSet)broadcastInputNumbers : new IntAVLTreeSet(broadcastInputNumbers));
        this.processorFactory = (FrameProcessorFactory)Preconditions.checkNotNull((Object)processorFactory, (Object)"processorFactory");
        this.signature = (RowSignature)Preconditions.checkNotNull((Object)signature, (Object)"signature");
        this.shuffleSpec = shuffleSpec;
        this.maxWorkerCount = maxWorkerCount;
        this.shuffleCheckHasMultipleValues = shuffleCheckHasMultipleValues;
        this.frameReader = () -> ((Supplier)Suppliers.memoize(() -> FrameReader.create((RowSignature)signature))).get();
        if (this.mustGatherResultKeyStatistics() && shuffleSpec.clusterBy().isEmpty()) {
            throw new IAE("Cannot shuffle with spec [%s] and nil clusterBy", new Object[]{shuffleSpec});
        }
        for (String columnName : signature.getColumnNames()) {
            if (signature.getColumnType(columnName).isPresent()) continue;
            throw new ISE("Missing type for column [%s]", new Object[]{columnName});
        }
        IntIterator intIterator = this.broadcastInputNumbers.iterator();
        while (intIterator.hasNext()) {
            int broadcastInputNumber = (Integer)intIterator.next();
            if (broadcastInputNumber >= 0 && broadcastInputNumber < inputSpecs.size()) continue;
            throw new ISE("Broadcast input number out of range [%s]", new Object[]{broadcastInputNumber});
        }
    }

    public static boolean mustGatherResultKeyStatistics(@Nullable ShuffleSpec shuffleSpec) {
        return shuffleSpec != null && shuffleSpec.kind() == ShuffleKind.GLOBAL_SORT && ((GlobalSortShuffleSpec)shuffleSpec).mustGatherResultKeyStatistics();
    }

    public static StageDefinitionBuilder builder(int stageNumber) {
        return new StageDefinitionBuilder(stageNumber);
    }

    public static StageDefinitionBuilder builder(StageDefinition stageDef) {
        return new StageDefinitionBuilder(stageDef.getStageNumber()).inputs(stageDef.getInputSpecs()).broadcastInputs(stageDef.getBroadcastInputNumbers()).processorFactory(stageDef.getProcessorFactory()).signature(stageDef.getSignature()).shuffleSpec(stageDef.doesShuffle() ? stageDef.getShuffleSpec() : null).maxWorkerCount(stageDef.getMaxWorkerCount()).shuffleCheckHasMultipleValues(stageDef.getShuffleCheckHasMultipleValues());
    }

    @JsonProperty
    public StageId getId() {
        return this.id;
    }

    @JsonProperty(value="input")
    public List<InputSpec> getInputSpecs() {
        return this.inputSpecs;
    }

    public IntSet getInputStageNumbers() {
        return InputSpecs.getStageNumbers(this.inputSpecs);
    }

    @JsonProperty(value="broadcast")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public IntSet getBroadcastInputNumbers() {
        return this.broadcastInputNumbers;
    }

    @JsonProperty(value="processor")
    public FrameProcessorFactory getProcessorFactory() {
        return this.processorFactory;
    }

    @JsonProperty
    public RowSignature getSignature() {
        return this.signature;
    }

    public boolean doesShuffle() {
        return this.shuffleSpec != null;
    }

    public boolean doesSortDuringShuffle() {
        if (this.shuffleSpec == null || this.shuffleSpec.clusterBy().isEmpty()) {
            return false;
        }
        return this.shuffleSpec.clusterBy().sortable();
    }

    public ShuffleSpec getShuffleSpec() {
        if (this.shuffleSpec == null) {
            throw new IllegalStateException("Stage does not shuffle");
        }
        return this.shuffleSpec;
    }

    public ClusterBy getClusterBy() {
        if (this.shuffleSpec != null) {
            return this.shuffleSpec.clusterBy();
        }
        return ClusterBy.none();
    }

    public List<KeyColumn> getSortKey() {
        ClusterBy clusterBy = this.getClusterBy();
        if (clusterBy.sortable()) {
            return clusterBy.getColumns();
        }
        return Collections.emptyList();
    }

    @Nullable
    @JsonProperty(value="shuffleSpec")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    ShuffleSpec getShuffleSpecForSerialization() {
        return this.shuffleSpec;
    }

    @JsonProperty
    public int getMaxWorkerCount() {
        return this.maxWorkerCount;
    }

    @JsonProperty(value="shuffleCheckHasMultipleValues")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean getShuffleCheckHasMultipleValues() {
        return this.shuffleCheckHasMultipleValues;
    }

    public int getMaxPartitionCount() {
        return 25000;
    }

    public int getStageNumber() {
        return this.id.getStageNumber();
    }

    public boolean mustGatherResultKeyStatistics() {
        return StageDefinition.mustGatherResultKeyStatistics(this.shuffleSpec);
    }

    public Either<Long, ClusterByPartitions> generatePartitionBoundariesForShuffle(@Nullable ClusterByStatisticsCollector collector) {
        if (this.shuffleSpec == null) {
            throw new ISE("No shuffle for stage[%d]", new Object[]{this.getStageNumber()});
        }
        if (this.shuffleSpec.kind() != ShuffleKind.GLOBAL_SORT) {
            throw new ISE("Shuffle of kind [%s] cannot generate partition boundaries for stage[%d]", new Object[]{this.shuffleSpec.kind(), this.getStageNumber()});
        }
        if (this.mustGatherResultKeyStatistics() && collector == null) {
            throw new ISE("Statistics required, but not gathered for stage[%d]", new Object[]{this.getStageNumber()});
        }
        if (!this.mustGatherResultKeyStatistics() && collector != null) {
            throw new ISE("Statistics gathered, but not required for stage[%d]", new Object[]{this.getStageNumber()});
        }
        return ((GlobalSortShuffleSpec)this.shuffleSpec).generatePartitionsForGlobalSort(collector, 25000);
    }

    public ClusterByStatisticsCollector createResultKeyStatisticsCollector(int maxRetainedBytes) {
        if (!this.mustGatherResultKeyStatistics()) {
            throw new ISE("No statistics needed for stage[%d]", new Object[]{this.getStageNumber()});
        }
        return ClusterByStatisticsCollectorImpl.create(this.shuffleSpec.clusterBy(), this.signature, maxRetainedBytes, 5000, ((GlobalSortShuffleSpec)this.shuffleSpec).doesAggregate(), this.shuffleCheckHasMultipleValues);
    }

    public FrameWriterFactory createFrameWriterFactory(MemoryAllocatorFactory memoryAllocatorFactory, boolean removeNullBytes) {
        return FrameWriters.makeRowBasedFrameWriterFactory((MemoryAllocatorFactory)memoryAllocatorFactory, (RowSignature)this.signature, this.doesShuffle() && !this.shuffleSpec.kind().isHash() ? this.getClusterBy().getColumns() : Collections.emptyList(), (boolean)removeNullBytes);
    }

    public FrameWriterFactory createFrameWriterFactory(MemoryAllocator allocator, boolean removeNullBytes) {
        return this.createFrameWriterFactory((MemoryAllocatorFactory)new SingleMemoryAllocatorFactory(allocator), removeNullBytes);
    }

    public FrameReader getFrameReader() {
        return this.frameReader.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StageDefinition that = (StageDefinition)o;
        return this.maxWorkerCount == that.maxWorkerCount && this.shuffleCheckHasMultipleValues == that.shuffleCheckHasMultipleValues && Objects.equals(this.id, that.id) && Objects.equals(this.inputSpecs, that.inputSpecs) && Objects.equals(this.broadcastInputNumbers, that.broadcastInputNumbers) && Objects.equals(this.processorFactory, that.processorFactory) && Objects.equals(this.signature, that.signature) && Objects.equals(this.shuffleSpec, that.shuffleSpec);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.inputSpecs, this.broadcastInputNumbers, this.processorFactory, this.signature, this.maxWorkerCount, this.shuffleCheckHasMultipleValues, this.shuffleSpec);
    }

    public String toString() {
        return "StageDefinition{id=" + this.id + ", inputSpecs=" + this.inputSpecs + (!this.broadcastInputNumbers.isEmpty() ? ", broadcastInputStages=" + this.broadcastInputNumbers : "") + ", processorFactory=" + this.processorFactory + ", signature=" + this.signature + ", maxWorkerCount=" + this.maxWorkerCount + ", shuffleSpec=" + this.shuffleSpec + (this.shuffleCheckHasMultipleValues ? ", shuffleCheckHasMultipleValues=" + this.shuffleCheckHasMultipleValues : "") + '}';
    }
}

