/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.kernel.controller;

import java.util.List;
import java.util.Objects;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.msq.exec.OutputChannelMode;
import org.apache.druid.msq.kernel.StageId;

public class StageGroup {
    private final List<StageId> stageIds;
    private final OutputChannelMode groupOutputChannelMode;

    public StageGroup(List<StageId> stageIds, OutputChannelMode groupOutputChannelMode) {
        this.stageIds = stageIds;
        this.groupOutputChannelMode = groupOutputChannelMode;
    }

    public List<StageId> stageIds() {
        return this.stageIds;
    }

    public OutputChannelMode lastStageOutputChannelMode() {
        return this.stageOutputChannelMode(this.last());
    }

    public OutputChannelMode stageOutputChannelMode(StageId stageId) {
        if (this.last().equals(stageId)) {
            return this.groupOutputChannelMode;
        }
        if (this.stageIds.contains(stageId)) {
            return OutputChannelMode.MEMORY;
        }
        throw new IAE("Stage[%s] not in group", new Object[]{stageId});
    }

    public StageId first() {
        return this.stageIds.get(0);
    }

    public StageId last() {
        return this.stageIds.get(this.stageIds.size() - 1);
    }

    public int size() {
        return this.stageIds.size();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StageGroup that = (StageGroup)o;
        return Objects.equals(this.stageIds, that.stageIds) && this.groupOutputChannelMode == that.groupOutputChannelMode;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.stageIds, this.groupOutputChannelMode});
    }

    public String toString() {
        return "StageGroup{stageIds=" + this.stageIds + ", groupOutputChannelMode=" + (Object)((Object)this.groupOutputChannelMode) + '}';
    }
}

