/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.fluent;

import io.kubernetes.client.fluent.Visitor;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public interface Visitable<T> {
    default public <V> T accept(final Class<V> type, final Visitor<V> visitor) {
        return this.accept(new Visitor<V>(){

            @Override
            public Class<V> getType() {
                return type;
            }

            @Override
            public void visit(V element) {
                visitor.visit(element);
            }
        });
    }

    default public T accept(Visitor ... visitors) {
        for (Visitor visitor : visitors) {
            if (!visitor.canVisit(Collections.emptyList(), this).booleanValue()) continue;
            visitor.visit(this);
        }
        return this.getTarget(this);
    }

    default public T accept(List<Map.Entry<String, Object>> path, Visitor ... visitors) {
        return this.accept(path, "", visitors);
    }

    default public T accept(List<Map.Entry<String, Object>> path, String currentKey, Visitor ... visitors) {
        for (Visitor visitor : visitors) {
            if (!visitor.canVisit(path, this).booleanValue()) continue;
            visitor.visit(path, this);
        }
        return this.getTarget(this);
    }

    default public T getTarget(Visitable<T> visitable) {
        return (T)visitable;
    }
}

