/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1HTTPIngressPath;
import io.kubernetes.client.openapi.models.V1HTTPIngressPathFluent;
import io.kubernetes.client.openapi.models.V1IngressBackend;
import io.kubernetes.client.openapi.models.V1IngressBackendBuilder;
import io.kubernetes.client.openapi.models.V1IngressBackendFluentImpl;
import java.util.Objects;

public class V1HTTPIngressPathFluentImpl<A extends V1HTTPIngressPathFluent<A>>
extends BaseFluent<A>
implements V1HTTPIngressPathFluent<A> {
    private V1IngressBackendBuilder backend;
    private String path;
    private String pathType;

    public V1HTTPIngressPathFluentImpl() {
    }

    public V1HTTPIngressPathFluentImpl(V1HTTPIngressPath instance) {
        if (instance != null) {
            this.withBackend(instance.getBackend());
            this.withPath(instance.getPath());
            this.withPathType(instance.getPathType());
        }
    }

    @Override
    @Deprecated
    public V1IngressBackend getBackend() {
        return this.backend != null ? this.backend.build() : null;
    }

    @Override
    public V1IngressBackend buildBackend() {
        return this.backend != null ? this.backend.build() : null;
    }

    @Override
    public A withBackend(V1IngressBackend backend) {
        this._visitables.get("backend").remove(this.backend);
        if (backend != null) {
            this.backend = new V1IngressBackendBuilder(backend);
            this._visitables.get("backend").add(this.backend);
        } else {
            this.backend = null;
            this._visitables.get("backend").remove(this.backend);
        }
        return (A)this;
    }

    @Override
    public Boolean hasBackend() {
        return this.backend != null;
    }

    @Override
    public V1HTTPIngressPathFluent.BackendNested<A> withNewBackend() {
        return new BackendNestedImpl();
    }

    @Override
    public V1HTTPIngressPathFluent.BackendNested<A> withNewBackendLike(V1IngressBackend item) {
        return new BackendNestedImpl(item);
    }

    @Override
    public V1HTTPIngressPathFluent.BackendNested<A> editBackend() {
        return this.withNewBackendLike(this.getBackend());
    }

    @Override
    public V1HTTPIngressPathFluent.BackendNested<A> editOrNewBackend() {
        return this.withNewBackendLike(this.getBackend() != null ? this.getBackend() : new V1IngressBackendBuilder().build());
    }

    @Override
    public V1HTTPIngressPathFluent.BackendNested<A> editOrNewBackendLike(V1IngressBackend item) {
        return this.withNewBackendLike(this.getBackend() != null ? this.getBackend() : item);
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public A withPath(String path) {
        this.path = path;
        return (A)this;
    }

    @Override
    public Boolean hasPath() {
        return this.path != null;
    }

    @Override
    public String getPathType() {
        return this.pathType;
    }

    @Override
    public A withPathType(String pathType) {
        this.pathType = pathType;
        return (A)this;
    }

    @Override
    public Boolean hasPathType() {
        return this.pathType != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1HTTPIngressPathFluentImpl that = (V1HTTPIngressPathFluentImpl)o;
        if (!Objects.equals(this.backend, that.backend)) {
            return false;
        }
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        return Objects.equals(this.pathType, that.pathType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.backend, this.path, this.pathType, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.backend != null) {
            sb.append("backend:");
            sb.append(this.backend + ",");
        }
        if (this.path != null) {
            sb.append("path:");
            sb.append(this.path + ",");
        }
        if (this.pathType != null) {
            sb.append("pathType:");
            sb.append(this.pathType);
        }
        sb.append("}");
        return sb.toString();
    }

    class BackendNestedImpl<N>
    extends V1IngressBackendFluentImpl<V1HTTPIngressPathFluent.BackendNested<N>>
    implements V1HTTPIngressPathFluent.BackendNested<N>,
    Nested<N> {
        V1IngressBackendBuilder builder;

        BackendNestedImpl(V1IngressBackend item) {
            this.builder = new V1IngressBackendBuilder(this, item);
        }

        BackendNestedImpl() {
            this.builder = new V1IngressBackendBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1HTTPIngressPathFluentImpl.this.withBackend(this.builder.build());
        }

        @Override
        public N endBackend() {
            return this.and();
        }
    }
}

