/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.custom.IntOrString;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="TCPSocketAction describes an action based on opening a socket")
public class V1TCPSocketAction {
    public static final String SERIALIZED_NAME_HOST = "host";
    @SerializedName(value="host")
    private String host;
    public static final String SERIALIZED_NAME_PORT = "port";
    @SerializedName(value="port")
    private IntOrString port;

    public V1TCPSocketAction host(String host) {
        this.host = host;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Optional: Host name to connect to, defaults to the pod IP.")
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public V1TCPSocketAction port(IntOrString port) {
        this.port = port;
        return this;
    }

    @ApiModelProperty(required=true, value="IntOrString is a type that can hold an int32 or a string.  When used in JSON or YAML marshalling and unmarshalling, it produces or consumes the inner type.  This allows you to have, for example, a JSON field that can accept a name or number.")
    public IntOrString getPort() {
        return this.port;
    }

    public void setPort(IntOrString port) {
        this.port = port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1TCPSocketAction v1TCPSocketAction = (V1TCPSocketAction)o;
        return Objects.equals(this.host, v1TCPSocketAction.host) && Objects.equals(this.port, v1TCPSocketAction.port);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1TCPSocketAction {\n");
        sb.append("    host: ").append(this.toIndentedString(this.host)).append("\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

