/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.parser.errors;

import com.github.rvesse.airline.parser.errors.ParseRestrictionViolatedException;
import com.github.rvesse.airline.utils.AirlineUtils;

public class ParseOptionOutOfRangeException
extends ParseRestrictionViolatedException {
    private static final long serialVersionUID = 4391651222234661142L;
    private final Object illegalValue;
    private final Object min;
    private final Object max;
    private final boolean minInclusive;
    private final boolean maxInclusive;

    public ParseOptionOutOfRangeException(String optionTitle, Object value, Object min, boolean minInclusive, Object max, boolean maxInclusive) {
        super("Value for option '%s' was given as '%s' which is not in the acceptable range: %s", optionTitle, value, AirlineUtils.toRangeString(min, minInclusive, max, maxInclusive));
        this.illegalValue = value;
        this.min = min;
        this.minInclusive = minInclusive;
        this.max = max;
        this.maxInclusive = maxInclusive;
    }

    public Object getIllegalValue() {
        return this.illegalValue;
    }

    public Object getMinimumValue() {
        return this.min;
    }

    public Object getMaximumValue() {
        return this.max;
    }

    public boolean isMinimumInclusive() {
        return this.minInclusive;
    }

    public boolean isMaximumInclusive() {
        return this.maxInclusive;
    }
}

