/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.s3;

import com.amazonaws.SdkClientException;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.AccessControlList;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadResult;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.CopyObjectResult;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.UploadPartRequest;
import com.amazonaws.services.s3.model.UploadPartResult;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerBuilder;
import com.amazonaws.services.s3.transfer.Upload;
import java.io.File;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.storage.s3.NoopServerSideEncryption;
import org.apache.druid.storage.s3.S3StorageConfig;
import org.apache.druid.storage.s3.S3TransferConfig;
import org.apache.druid.storage.s3.S3Utils;
import org.apache.druid.storage.s3.ServerSideEncryption;

public class ServerSideEncryptingAmazonS3 {
    private final AmazonS3 amazonS3;
    private final ServerSideEncryption serverSideEncryption;
    private final TransferManager transferManager;

    public static Builder builder() {
        return new Builder();
    }

    public ServerSideEncryptingAmazonS3(AmazonS3 amazonS3, ServerSideEncryption serverSideEncryption, S3TransferConfig transferConfig) {
        this.amazonS3 = amazonS3;
        this.serverSideEncryption = serverSideEncryption;
        this.transferManager = transferConfig.isUseTransferManager() ? TransferManagerBuilder.standard().withS3Client(amazonS3).withMinimumUploadPartSize(Long.valueOf(transferConfig.getMinimumUploadPartSize())).withMultipartUploadThreshold(Long.valueOf(transferConfig.getMultipartUploadThreshold())).build() : null;
    }

    public AmazonS3 getAmazonS3() {
        return this.amazonS3;
    }

    public boolean doesObjectExist(String bucket, String objectName) {
        try {
            this.getObjectMetadata(bucket, objectName);
            return true;
        }
        catch (AmazonS3Exception e) {
            if (e.getStatusCode() == 404) {
                return false;
            }
            throw e;
        }
    }

    public ListObjectsV2Result listObjectsV2(ListObjectsV2Request request) {
        return this.amazonS3.listObjectsV2(request);
    }

    public AccessControlList getBucketAcl(String bucket) {
        return this.amazonS3.getBucketAcl(bucket);
    }

    public ObjectMetadata getObjectMetadata(String bucket, String key) {
        GetObjectMetadataRequest getObjectMetadataRequest = this.serverSideEncryption.decorate(new GetObjectMetadataRequest(bucket, key));
        return this.amazonS3.getObjectMetadata(getObjectMetadataRequest);
    }

    public S3Object getObject(String bucket, String key) {
        return this.getObject(new GetObjectRequest(bucket, key));
    }

    public S3Object getObject(GetObjectRequest request) {
        return this.amazonS3.getObject(this.serverSideEncryption.decorate(request));
    }

    public PutObjectResult putObject(String bucket, String key, File file) {
        return this.putObject(new PutObjectRequest(bucket, key, file));
    }

    public PutObjectResult putObject(PutObjectRequest request) {
        return this.amazonS3.putObject(this.serverSideEncryption.decorate(request));
    }

    public CopyObjectResult copyObject(CopyObjectRequest request) {
        return this.amazonS3.copyObject(this.serverSideEncryption.decorate(request));
    }

    public void deleteObject(String bucket, String key) {
        this.amazonS3.deleteObject(bucket, key);
    }

    public void deleteObjects(DeleteObjectsRequest request) {
        this.amazonS3.deleteObjects(request);
    }

    public InitiateMultipartUploadResult initiateMultipartUpload(InitiateMultipartUploadRequest request) throws SdkClientException {
        return this.amazonS3.initiateMultipartUpload(this.serverSideEncryption.decorate(request));
    }

    public UploadPartResult uploadPart(UploadPartRequest request) throws SdkClientException {
        return this.amazonS3.uploadPart(this.serverSideEncryption.decorate(request));
    }

    public void cancelMultiPartUpload(AbortMultipartUploadRequest request) throws SdkClientException {
        this.amazonS3.abortMultipartUpload(request);
    }

    public CompleteMultipartUploadResult completeMultipartUpload(CompleteMultipartUploadRequest request) throws SdkClientException {
        return this.amazonS3.completeMultipartUpload(request);
    }

    public void upload(PutObjectRequest request) throws InterruptedException {
        if (this.transferManager == null) {
            this.putObject(request);
        } else {
            Upload transfer = this.transferManager.upload(this.serverSideEncryption.decorate(request));
            transfer.waitForCompletion();
        }
    }

    public static class Builder {
        private AmazonS3ClientBuilder amazonS3ClientBuilder = AmazonS3Client.builder();
        private S3StorageConfig s3StorageConfig = new S3StorageConfig(new NoopServerSideEncryption(), null);

        public Builder setAmazonS3ClientBuilder(AmazonS3ClientBuilder amazonS3ClientBuilder) {
            this.amazonS3ClientBuilder = amazonS3ClientBuilder;
            return this;
        }

        public Builder setS3StorageConfig(S3StorageConfig s3StorageConfig) {
            this.s3StorageConfig = s3StorageConfig;
            return this;
        }

        public AmazonS3ClientBuilder getAmazonS3ClientBuilder() {
            return this.amazonS3ClientBuilder;
        }

        public S3StorageConfig getS3StorageConfig() {
            return this.s3StorageConfig;
        }

        public ServerSideEncryptingAmazonS3 build() {
            AmazonS3 amazonS3Client;
            if (this.amazonS3ClientBuilder == null) {
                throw new ISE("AmazonS3ClientBuilder cannot be null!", new Object[0]);
            }
            if (this.s3StorageConfig == null) {
                throw new ISE("S3StorageConfig cannot be null!", new Object[0]);
            }
            try {
                amazonS3Client = (AmazonS3)S3Utils.retryS3Operation(() -> (AmazonS3)this.amazonS3ClientBuilder.build());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return new ServerSideEncryptingAmazonS3(amazonS3Client, this.s3StorageConfig.getServerSideEncryption(), this.s3StorageConfig.getS3TransferConfig());
        }
    }
}

