/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.kafka.clients.ApiVersions;
import org.apache.kafka.clients.GroupRebalanceConfig;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.consumer.internals.CachedSupplier;
import org.apache.kafka.clients.consumer.internals.CommitRequestManager;
import org.apache.kafka.clients.consumer.internals.ConsumerMetadata;
import org.apache.kafka.clients.consumer.internals.CoordinatorRequestManager;
import org.apache.kafka.clients.consumer.internals.FetchBuffer;
import org.apache.kafka.clients.consumer.internals.FetchConfig;
import org.apache.kafka.clients.consumer.internals.FetchMetricsManager;
import org.apache.kafka.clients.consumer.internals.FetchRequestManager;
import org.apache.kafka.clients.consumer.internals.HeartbeatRequestManager;
import org.apache.kafka.clients.consumer.internals.MemberStateListener;
import org.apache.kafka.clients.consumer.internals.MembershipManager;
import org.apache.kafka.clients.consumer.internals.MembershipManagerImpl;
import org.apache.kafka.clients.consumer.internals.NetworkClientDelegate;
import org.apache.kafka.clients.consumer.internals.OffsetCommitCallbackInvoker;
import org.apache.kafka.clients.consumer.internals.OffsetsRequestManager;
import org.apache.kafka.clients.consumer.internals.RequestManager;
import org.apache.kafka.clients.consumer.internals.ShareConsumeRequestManager;
import org.apache.kafka.clients.consumer.internals.ShareFetchBuffer;
import org.apache.kafka.clients.consumer.internals.ShareFetchMetricsManager;
import org.apache.kafka.clients.consumer.internals.ShareHeartbeatRequestManager;
import org.apache.kafka.clients.consumer.internals.ShareMembershipManager;
import org.apache.kafka.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.clients.consumer.internals.TopicMetadataRequestManager;
import org.apache.kafka.clients.consumer.internals.events.BackgroundEventHandler;
import org.apache.kafka.common.internals.IdempotentCloser;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.telemetry.internals.ClientTelemetryReporter;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;

public class RequestManagers
implements Closeable {
    private final Logger log;
    public final Optional<CoordinatorRequestManager> coordinatorRequestManager;
    public final Optional<CommitRequestManager> commitRequestManager;
    public final Optional<HeartbeatRequestManager> heartbeatRequestManager;
    public final Optional<ShareHeartbeatRequestManager> shareHeartbeatRequestManager;
    public final Optional<MembershipManager> membershipManager;
    public final Optional<ShareMembershipManager> shareMembershipManager;
    public final OffsetsRequestManager offsetsRequestManager;
    public final TopicMetadataRequestManager topicMetadataRequestManager;
    public final FetchRequestManager fetchRequestManager;
    public final Optional<ShareConsumeRequestManager> shareConsumeRequestManager;
    private final List<Optional<? extends RequestManager>> entries;
    private final IdempotentCloser closer = new IdempotentCloser();

    public RequestManagers(LogContext logContext, OffsetsRequestManager offsetsRequestManager, TopicMetadataRequestManager topicMetadataRequestManager, FetchRequestManager fetchRequestManager, Optional<CoordinatorRequestManager> coordinatorRequestManager, Optional<CommitRequestManager> commitRequestManager, Optional<HeartbeatRequestManager> heartbeatRequestManager, Optional<MembershipManager> membershipManager) {
        this.log = logContext.logger(RequestManagers.class);
        this.offsetsRequestManager = Objects.requireNonNull(offsetsRequestManager, "OffsetsRequestManager cannot be null");
        this.coordinatorRequestManager = coordinatorRequestManager;
        this.commitRequestManager = commitRequestManager;
        this.topicMetadataRequestManager = topicMetadataRequestManager;
        this.fetchRequestManager = fetchRequestManager;
        this.shareConsumeRequestManager = Optional.empty();
        this.heartbeatRequestManager = heartbeatRequestManager;
        this.shareHeartbeatRequestManager = Optional.empty();
        this.membershipManager = membershipManager;
        this.shareMembershipManager = Optional.empty();
        ArrayList<Optional<RequestManager>> list = new ArrayList<Optional<RequestManager>>();
        list.add(coordinatorRequestManager);
        list.add(commitRequestManager);
        list.add(heartbeatRequestManager);
        list.add(membershipManager);
        list.add(Optional.of(offsetsRequestManager));
        list.add(Optional.of(topicMetadataRequestManager));
        list.add(Optional.of(fetchRequestManager));
        this.entries = Collections.unmodifiableList(list);
    }

    public RequestManagers(LogContext logContext, ShareConsumeRequestManager shareConsumeRequestManager, Optional<CoordinatorRequestManager> coordinatorRequestManager, Optional<ShareHeartbeatRequestManager> shareHeartbeatRequestManager, Optional<ShareMembershipManager> shareMembershipManager) {
        this.log = logContext.logger(RequestManagers.class);
        this.shareConsumeRequestManager = Optional.of(shareConsumeRequestManager);
        this.coordinatorRequestManager = coordinatorRequestManager;
        this.commitRequestManager = Optional.empty();
        this.heartbeatRequestManager = Optional.empty();
        this.shareHeartbeatRequestManager = shareHeartbeatRequestManager;
        this.membershipManager = Optional.empty();
        this.shareMembershipManager = shareMembershipManager;
        this.offsetsRequestManager = null;
        this.topicMetadataRequestManager = null;
        this.fetchRequestManager = null;
        ArrayList<Optional<RequestManager>> list = new ArrayList<Optional<RequestManager>>();
        list.add(coordinatorRequestManager);
        list.add(shareHeartbeatRequestManager);
        list.add(shareMembershipManager);
        list.add(Optional.of(shareConsumeRequestManager));
        this.entries = Collections.unmodifiableList(list);
    }

    public List<Optional<? extends RequestManager>> entries() {
        return this.entries;
    }

    @Override
    public void close() {
        this.closer.close(() -> {
            this.log.debug("Closing RequestManagers");
            this.entries.stream().filter(Optional::isPresent).map(Optional::get).filter(rm -> rm instanceof Closeable).map(rm -> (Closeable)((Object)rm)).forEach(c -> Utils.closeQuietly(c, c.getClass().getSimpleName()));
            this.log.debug("RequestManagers has been closed");
        }, () -> this.log.debug("RequestManagers was already closed"));
    }

    public static Supplier<RequestManagers> supplier(final Time time, final LogContext logContext, final BackgroundEventHandler backgroundEventHandler, final ConsumerMetadata metadata, final SubscriptionState subscriptions, final FetchBuffer fetchBuffer, final ConsumerConfig config, final GroupRebalanceConfig groupRebalanceConfig, final ApiVersions apiVersions, final FetchMetricsManager fetchMetricsManager, final Supplier<NetworkClientDelegate> networkClientDelegateSupplier, final Optional<ClientTelemetryReporter> clientTelemetryReporter, final Metrics metrics, final OffsetCommitCallbackInvoker offsetCommitCallbackInvoker, final MemberStateListener applicationThreadMemberStateListener) {
        return new CachedSupplier<RequestManagers>(){

            @Override
            protected RequestManagers create() {
                NetworkClientDelegate networkClientDelegate = (NetworkClientDelegate)networkClientDelegateSupplier.get();
                FetchConfig fetchConfig = new FetchConfig(config);
                long retryBackoffMs = config.getLong("retry.backoff.ms");
                long retryBackoffMaxMs = config.getLong("retry.backoff.max.ms");
                int requestTimeoutMs = config.getInt("request.timeout.ms");
                OffsetsRequestManager listOffsets = new OffsetsRequestManager(subscriptions, metadata, fetchConfig.isolationLevel, time, retryBackoffMs, requestTimeoutMs, apiVersions, networkClientDelegate, backgroundEventHandler, logContext);
                FetchRequestManager fetch = new FetchRequestManager(logContext, time, metadata, subscriptions, fetchConfig, fetchBuffer, fetchMetricsManager, networkClientDelegate, apiVersions);
                TopicMetadataRequestManager topic = new TopicMetadataRequestManager(logContext, time, config);
                HeartbeatRequestManager heartbeatRequestManager = null;
                MembershipManagerImpl membershipManager = null;
                CoordinatorRequestManager coordinator = null;
                CommitRequestManager commit = null;
                if (groupRebalanceConfig != null && groupRebalanceConfig.groupId != null) {
                    Optional<String> serverAssignor = Optional.ofNullable(config.getString("group.remote.assignor"));
                    coordinator = new CoordinatorRequestManager(logContext, retryBackoffMs, retryBackoffMaxMs, backgroundEventHandler, groupRebalanceConfig.groupId);
                    commit = new CommitRequestManager(time, logContext, subscriptions, config, coordinator, offsetCommitCallbackInvoker, groupRebalanceConfig.groupId, groupRebalanceConfig.groupInstanceId, metrics);
                    membershipManager = new MembershipManagerImpl(groupRebalanceConfig.groupId, groupRebalanceConfig.groupInstanceId, groupRebalanceConfig.rebalanceTimeoutMs, serverAssignor, subscriptions, commit, metadata, logContext, (Optional<ClientTelemetryReporter>)clientTelemetryReporter, backgroundEventHandler, time, metrics);
                    membershipManager.registerStateListener(commit);
                    membershipManager.registerStateListener(applicationThreadMemberStateListener);
                    heartbeatRequestManager = new HeartbeatRequestManager(logContext, time, config, coordinator, subscriptions, membershipManager, backgroundEventHandler, metrics);
                }
                return new RequestManagers(logContext, listOffsets, topic, fetch, Optional.ofNullable(coordinator), Optional.ofNullable(commit), Optional.ofNullable(heartbeatRequestManager), Optional.ofNullable(membershipManager));
            }
        };
    }

    public static Supplier<RequestManagers> supplier(final Time time, final LogContext logContext, final BackgroundEventHandler backgroundEventHandler, final ConsumerMetadata metadata, final SubscriptionState subscriptions, final ShareFetchBuffer fetchBuffer, final ConsumerConfig config, final GroupRebalanceConfig groupRebalanceConfig, final ShareFetchMetricsManager shareFetchMetricsManager, final Optional<ClientTelemetryReporter> clientTelemetryReporter, final Metrics metrics) {
        return new CachedSupplier<RequestManagers>(){

            @Override
            protected RequestManagers create() {
                long retryBackoffMs = config.getLong("retry.backoff.ms");
                long retryBackoffMaxMs = config.getLong("retry.backoff.max.ms");
                FetchConfig fetchConfig = new FetchConfig(config);
                CoordinatorRequestManager coordinator = new CoordinatorRequestManager(logContext, retryBackoffMs, retryBackoffMaxMs, backgroundEventHandler, groupRebalanceConfig.groupId);
                ShareMembershipManager shareMembershipManager = new ShareMembershipManager(logContext, groupRebalanceConfig.groupId, null, subscriptions, metadata, (Optional<ClientTelemetryReporter>)clientTelemetryReporter, time, metrics);
                ShareHeartbeatRequestManager shareHeartbeatRequestManager = new ShareHeartbeatRequestManager(logContext, time, config, coordinator, subscriptions, shareMembershipManager, backgroundEventHandler, metrics);
                ShareConsumeRequestManager shareConsumeRequestManager = new ShareConsumeRequestManager(time, logContext, groupRebalanceConfig.groupId, metadata, subscriptions, fetchConfig, fetchBuffer, backgroundEventHandler, shareFetchMetricsManager, retryBackoffMs, retryBackoffMaxMs);
                shareMembershipManager.registerStateListener(shareConsumeRequestManager);
                return new RequestManagers(logContext, shareConsumeRequestManager, Optional.of(coordinator), Optional.of(shareHeartbeatRequestManager), Optional.of(shareMembershipManager));
            }
        };
    }
}

