/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.load;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.apache.derby.iapi.error.PublicAPI;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.LimitInputStream;
import org.apache.derby.impl.load.ImportFileInputStream;

class ImportLobFile {
    private ImportFileInputStream lobInputStream = null;
    private LimitInputStream lobLimitIn;
    private Reader lobReader = null;
    private String dataCodeset;

    ImportLobFile(File file, String string) throws Exception {
        this.dataCodeset = string;
        this.openLobFile(file);
    }

    private void openLobFile(final File file) throws Exception {
        RandomAccessFile randomAccessFile;
        try {
            try {
                randomAccessFile = AccessController.doPrivileged(new PrivilegedExceptionAction<RandomAccessFile>(){

                    @Override
                    public RandomAccessFile run() throws IOException {
                        return new RandomAccessFile(file, "r");
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw PublicAPI.wrapStandardException(StandardException.newException("XIE0P.S", file.getPath()));
        }
        this.lobInputStream = new ImportFileInputStream(randomAccessFile);
        this.lobLimitIn = new LimitInputStream(this.lobInputStream);
    }

    public InputStream getBinaryStream(long l, long l2) throws IOException {
        this.lobInputStream.seek(l);
        this.lobLimitIn.clearLimit();
        this.lobLimitIn.setLimit((int)l2);
        return this.lobLimitIn;
    }

    public String getString(long l, int n) throws IOException {
        this.lobInputStream.seek(l);
        this.lobLimitIn.clearLimit();
        this.lobLimitIn.setLimit(n);
        this.lobReader = this.dataCodeset == null ? new InputStreamReader(this.lobLimitIn) : new InputStreamReader((InputStream)this.lobLimitIn, this.dataCodeset);
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[1024];
        int n2 = this.lobReader.read(cArray, 0, 1024);
        while (n2 != -1) {
            stringBuffer.append(cArray, 0, n2);
            n2 = this.lobReader.read(cArray, 0, 1024);
        }
        return stringBuffer.toString();
    }

    public Reader getCharacterStream(long l, long l2) throws IOException {
        this.lobInputStream.seek(l);
        this.lobLimitIn.clearLimit();
        this.lobLimitIn.setLimit((int)l2);
        this.lobReader = this.dataCodeset == null ? new InputStreamReader(this.lobLimitIn) : new InputStreamReader((InputStream)this.lobLimitIn, this.dataCodeset);
        return this.lobReader;
    }

    public long getClobDataLength(long l, long l2) throws IOException {
        this.lobInputStream.seek(l);
        this.lobLimitIn.clearLimit();
        this.lobLimitIn.setLimit((int)l2);
        this.lobReader = this.dataCodeset == null ? new InputStreamReader(this.lobLimitIn) : new InputStreamReader((InputStream)this.lobLimitIn, this.dataCodeset);
        char[] cArray = new char[1024];
        long l3 = 0L;
        int n = this.lobReader.read(cArray, 0, 1024);
        while (n != -1) {
            l3 += (long)n;
            n = this.lobReader.read(cArray, 0, 1024);
        }
        return l3;
    }

    public void close() throws IOException {
        if (this.lobReader != null) {
            this.lobReader.close();
        } else if (this.lobLimitIn != null) {
            this.lobLimitIn.close();
        } else if (this.lobInputStream != null) {
            this.lobInputStream.close();
        }
    }
}

