/*
 * Decompiled with CFR 0.152.
 */
package io.vavr;

import io.vavr.Function1;
import io.vavr.Memoized;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;

@FunctionalInterface
public interface Function2<T1, T2, R>
extends Serializable,
BiFunction<T1, T2, R> {
    public static final long serialVersionUID = 1L;

    public static <T1, T2, R> Function2<T1, T2, R> constant(R value) {
        return (t1, t2) -> value;
    }

    public static <T1, T2, R> Function2<T1, T2, R> of(Function2<T1, T2, R> methodReference) {
        return methodReference;
    }

    public static <T1, T2, R> Function2<T1, T2, Option<R>> lift(BiFunction<? super T1, ? super T2, ? extends R> partialFunction) {
        return (t1, t2) -> Try.of(() -> partialFunction.apply((Object)t1, (Object)t2)).toOption();
    }

    public static <T1, T2, R> Function2<T1, T2, Try<R>> liftTry(BiFunction<? super T1, ? super T2, ? extends R> partialFunction) {
        return (t1, t2) -> Try.of(() -> partialFunction.apply((Object)t1, (Object)t2));
    }

    public static <T1, T2, R> Function2<T1, T2, R> narrow(Function2<? super T1, ? super T2, ? extends R> f) {
        return f;
    }

    @Override
    public R apply(T1 var1, T2 var2);

    default public Function1<T2, R> apply(T1 t1) {
        return t2 -> this.apply(t1, (T2)t2);
    }

    default public int arity() {
        return 2;
    }

    default public Function1<T1, Function1<T2, R>> curried() {
        return t1 -> t2 -> this.apply((T1)t1, (T2)t2);
    }

    default public Function1<Tuple2<T1, T2>, R> tupled() {
        return t -> this.apply((T1)t._1, (T2)t._2);
    }

    default public Function2<T2, T1, R> reversed() {
        return (t2, t1) -> this.apply((T1)t1, (T2)t2);
    }

    default public Function2<T1, T2, R> memoized() {
        if (this.isMemoized()) {
            return this;
        }
        HashMap cache = new HashMap();
        return (Function2<Object, Object, Object> & Memoized)(t1, t2) -> {
            Tuple2<Object, Object> key = Tuple.of(t1, t2);
            Map map = cache;
            synchronized (map) {
                if (cache.containsKey(key)) {
                    return cache.get(key);
                }
                R value = this.tupled().apply(key);
                cache.put(key, value);
                return value;
            }
        };
    }

    default public boolean isMemoized() {
        return this instanceof Memoized;
    }

    @Override
    default public <V> Function2<T1, T2, V> andThen(Function<? super R, ? extends V> after) {
        Objects.requireNonNull(after, "after is null");
        return (t1, t2) -> after.apply((R)this.apply((T1)t1, (T2)t2));
    }
}

