/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.basic;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.List;
import org.apache.druid.guice.Jerseys;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.initialization.DruidModule;
import org.apache.druid.java.util.http.client.NettyHttpClient;
import org.apache.druid.security.basic.BasicAuthClassCompositionConfig;
import org.apache.druid.security.basic.BasicAuthCommonCacheConfig;
import org.apache.druid.security.basic.BasicAuthSSLConfig;
import org.apache.druid.security.basic.BasicSecuritySSLSocketFactory;
import org.apache.druid.security.basic.authentication.BasicHTTPAuthenticator;
import org.apache.druid.security.basic.authentication.BasicHTTPEscalator;
import org.apache.druid.security.basic.authentication.db.cache.BasicAuthenticatorCacheManager;
import org.apache.druid.security.basic.authentication.db.cache.BasicAuthenticatorCacheNotifier;
import org.apache.druid.security.basic.authentication.db.cache.CoordinatorBasicAuthenticatorCacheNotifier;
import org.apache.druid.security.basic.authentication.db.cache.CoordinatorPollingBasicAuthenticatorCacheManager;
import org.apache.druid.security.basic.authentication.db.cache.MetadataStoragePollingBasicAuthenticatorCacheManager;
import org.apache.druid.security.basic.authentication.db.cache.NoopBasicAuthenticatorCacheNotifier;
import org.apache.druid.security.basic.authentication.db.updater.BasicAuthenticatorMetadataStorageUpdater;
import org.apache.druid.security.basic.authentication.db.updater.CoordinatorBasicAuthenticatorMetadataStorageUpdater;
import org.apache.druid.security.basic.authentication.db.updater.NoopBasicAuthenticatorMetadataStorageUpdater;
import org.apache.druid.security.basic.authentication.endpoint.BasicAuthenticatorResource;
import org.apache.druid.security.basic.authentication.endpoint.BasicAuthenticatorResourceHandler;
import org.apache.druid.security.basic.authentication.endpoint.CoordinatorBasicAuthenticatorResourceHandler;
import org.apache.druid.security.basic.authentication.endpoint.DefaultBasicAuthenticatorResourceHandler;
import org.apache.druid.security.basic.authorization.BasicRoleBasedAuthorizer;
import org.apache.druid.security.basic.authorization.db.cache.BasicAuthorizerCacheManager;
import org.apache.druid.security.basic.authorization.db.cache.BasicAuthorizerCacheNotifier;
import org.apache.druid.security.basic.authorization.db.cache.CoordinatorBasicAuthorizerCacheNotifier;
import org.apache.druid.security.basic.authorization.db.cache.CoordinatorPollingBasicAuthorizerCacheManager;
import org.apache.druid.security.basic.authorization.db.cache.MetadataStoragePollingBasicAuthorizerCacheManager;
import org.apache.druid.security.basic.authorization.db.cache.NoopBasicAuthorizerCacheNotifier;
import org.apache.druid.security.basic.authorization.db.updater.BasicAuthorizerMetadataStorageUpdater;
import org.apache.druid.security.basic.authorization.db.updater.CoordinatorBasicAuthorizerMetadataStorageUpdater;
import org.apache.druid.security.basic.authorization.db.updater.NoopBasicAuthorizerMetadataStorageUpdater;
import org.apache.druid.security.basic.authorization.endpoint.BasicAuthorizerResource;
import org.apache.druid.security.basic.authorization.endpoint.BasicAuthorizerResourceHandler;
import org.apache.druid.security.basic.authorization.endpoint.CoordinatorBasicAuthorizerResourceHandler;
import org.apache.druid.security.basic.authorization.endpoint.DefaultBasicAuthorizerResourceHandler;

public class BasicSecurityDruidModule
implements DruidModule {
    public void configure(Binder binder) {
        JsonConfigProvider.bind((Binder)binder, (String)"druid.auth.basic.common", BasicAuthCommonCacheConfig.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.auth.basic.composition", BasicAuthClassCompositionConfig.class);
        JsonConfigProvider.bind((Binder)binder, (String)"druid.auth.basic.ssl", BasicAuthSSLConfig.class);
        LifecycleModule.register((Binder)binder, BasicAuthenticatorMetadataStorageUpdater.class);
        LifecycleModule.register((Binder)binder, BasicAuthorizerMetadataStorageUpdater.class);
        LifecycleModule.register((Binder)binder, BasicAuthenticatorCacheManager.class);
        LifecycleModule.register((Binder)binder, BasicAuthorizerCacheManager.class);
        LifecycleModule.register((Binder)binder, BasicAuthenticatorCacheNotifier.class);
        LifecycleModule.register((Binder)binder, BasicAuthorizerCacheNotifier.class);
        Jerseys.addResource((Binder)binder, BasicAuthenticatorResource.class);
        Jerseys.addResource((Binder)binder, BasicAuthorizerResource.class);
        binder.requestStaticInjection(new Class[]{BasicSecuritySSLSocketFactory.class});
    }

    @Provides
    @LazySingleton
    public static BasicAuthenticatorMetadataStorageUpdater createAuthenticatorStorageUpdater(Injector injector, BasicAuthClassCompositionConfig config) throws ClassNotFoundException {
        return BasicSecurityDruidModule.getInstance(injector, config.getAuthenticatorMetadataStorageUpdater(), CoordinatorBasicAuthenticatorMetadataStorageUpdater.class, NoopBasicAuthenticatorMetadataStorageUpdater.class);
    }

    @Provides
    @LazySingleton
    public static BasicAuthenticatorCacheManager createAuthenticatorCacheManager(Injector injector, BasicAuthClassCompositionConfig config) throws ClassNotFoundException {
        return BasicSecurityDruidModule.getInstance(injector, config.getAuthenticatorCacheManager(), MetadataStoragePollingBasicAuthenticatorCacheManager.class, CoordinatorPollingBasicAuthenticatorCacheManager.class);
    }

    @Provides
    @LazySingleton
    public static BasicAuthenticatorResourceHandler createAuthenticatorResourceHandler(Injector injector, BasicAuthClassCompositionConfig config) throws ClassNotFoundException {
        return BasicSecurityDruidModule.getInstance(injector, config.getAuthenticatorResourceHandler(), CoordinatorBasicAuthenticatorResourceHandler.class, DefaultBasicAuthenticatorResourceHandler.class);
    }

    @Provides
    @LazySingleton
    public static BasicAuthenticatorCacheNotifier createAuthenticatorCacheNotifier(Injector injector, BasicAuthClassCompositionConfig config) throws ClassNotFoundException {
        return BasicSecurityDruidModule.getInstance(injector, config.getAuthenticatorCacheNotifier(), CoordinatorBasicAuthenticatorCacheNotifier.class, NoopBasicAuthenticatorCacheNotifier.class);
    }

    @Provides
    @LazySingleton
    public static BasicAuthorizerMetadataStorageUpdater createAuthorizerStorageUpdater(Injector injector, BasicAuthClassCompositionConfig config) throws ClassNotFoundException {
        return BasicSecurityDruidModule.getInstance(injector, config.getAuthorizerMetadataStorageUpdater(), CoordinatorBasicAuthorizerMetadataStorageUpdater.class, NoopBasicAuthorizerMetadataStorageUpdater.class);
    }

    @Provides
    @LazySingleton
    public static BasicAuthorizerCacheManager createAuthorizerCacheManager(Injector injector, BasicAuthClassCompositionConfig config) throws ClassNotFoundException {
        return BasicSecurityDruidModule.getInstance(injector, config.getAuthorizerCacheManager(), MetadataStoragePollingBasicAuthorizerCacheManager.class, CoordinatorPollingBasicAuthorizerCacheManager.class);
    }

    @Provides
    @LazySingleton
    public static BasicAuthorizerResourceHandler createAuthorizerResourceHandler(Injector injector, BasicAuthClassCompositionConfig config) throws ClassNotFoundException {
        return BasicSecurityDruidModule.getInstance(injector, config.getAuthorizerResourceHandler(), CoordinatorBasicAuthorizerResourceHandler.class, DefaultBasicAuthorizerResourceHandler.class);
    }

    @Provides
    @LazySingleton
    public static BasicAuthorizerCacheNotifier createAuthorizerCacheNotifier(Injector injector, BasicAuthClassCompositionConfig config) throws ClassNotFoundException {
        return BasicSecurityDruidModule.getInstance(injector, config.getAuthorizerCacheNotifier(), CoordinatorBasicAuthorizerCacheNotifier.class, NoopBasicAuthorizerCacheNotifier.class);
    }

    public List<? extends Module> getJacksonModules() {
        return ImmutableList.of((Object)new SimpleModule("BasicDruidSecurity").registerSubtypes(new Class[]{BasicHTTPAuthenticator.class, BasicHTTPEscalator.class, BasicRoleBasedAuthorizer.class, NettyHttpClient.class}));
    }

    private static <T> T getInstance(Injector injector, String configClassName, Class<? extends T> classRunByCoordinator, Class<? extends T> defaultClass) throws ClassNotFoundException {
        if (configClassName != null) {
            Object instance = injector.getInstance(Class.forName(configClassName));
            return (T)instance;
        }
        if (BasicSecurityDruidModule.isCoordinator(injector)) {
            return (T)injector.getInstance(classRunByCoordinator);
        }
        return (T)injector.getInstance(defaultClass);
    }

    private static boolean isCoordinator(Injector injector) {
        String serviceName;
        try {
            serviceName = (String)injector.getInstance(Key.get(String.class, (Annotation)Names.named((String)"serviceName")));
        }
        catch (Exception e) {
            return false;
        }
        return "druid/coordinator".equals(serviceName);
    }
}

