/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.security.basic.authentication.endpoint;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.security.basic.BasicAuthUtils;
import org.apache.druid.security.basic.BasicSecurityDBResourceException;
import org.apache.druid.security.basic.authentication.BasicHTTPAuthenticator;
import org.apache.druid.security.basic.authentication.db.updater.BasicAuthenticatorMetadataStorageUpdater;
import org.apache.druid.security.basic.authentication.endpoint.BasicAuthenticatorResourceHandler;
import org.apache.druid.security.basic.authentication.entity.BasicAuthenticatorCredentialUpdate;
import org.apache.druid.security.basic.authentication.entity.BasicAuthenticatorUser;
import org.apache.druid.server.security.Authenticator;
import org.apache.druid.server.security.AuthenticatorMapper;

public class CoordinatorBasicAuthenticatorResourceHandler
implements BasicAuthenticatorResourceHandler {
    private final BasicAuthenticatorMetadataStorageUpdater storageUpdater;
    private final Map<String, BasicHTTPAuthenticator> authenticatorMap;
    private final ObjectMapper objectMapper;

    @Inject
    public CoordinatorBasicAuthenticatorResourceHandler(BasicAuthenticatorMetadataStorageUpdater storageUpdater, AuthenticatorMapper authenticatorMapper, @Smile ObjectMapper objectMapper) {
        this.storageUpdater = storageUpdater;
        this.objectMapper = objectMapper;
        this.authenticatorMap = new HashMap<String, BasicHTTPAuthenticator>();
        for (Map.Entry authenticatorEntry : authenticatorMapper.getAuthenticatorMap().entrySet()) {
            String authenticatorName = (String)authenticatorEntry.getKey();
            Authenticator authenticator = (Authenticator)authenticatorEntry.getValue();
            if (!(authenticator instanceof BasicHTTPAuthenticator)) continue;
            this.authenticatorMap.put(authenticatorName, (BasicHTTPAuthenticator)authenticator);
        }
    }

    @Override
    public Response getAllUsers(String authenticatorName) {
        BasicHTTPAuthenticator authenticator = this.authenticatorMap.get(authenticatorName);
        if (authenticator == null) {
            return CoordinatorBasicAuthenticatorResourceHandler.makeResponseForAuthenticatorNotFound(authenticatorName);
        }
        Map<String, BasicAuthenticatorUser> userMap = BasicAuthUtils.deserializeAuthenticatorUserMap(this.objectMapper, this.storageUpdater.getCurrentUserMapBytes(authenticatorName));
        return Response.ok(userMap.keySet()).build();
    }

    @Override
    public Response getUser(String authenticatorName, String userName) {
        BasicHTTPAuthenticator authenticator = this.authenticatorMap.get(authenticatorName);
        if (authenticator == null) {
            return CoordinatorBasicAuthenticatorResourceHandler.makeResponseForAuthenticatorNotFound(authenticatorName);
        }
        Map<String, BasicAuthenticatorUser> userMap = BasicAuthUtils.deserializeAuthenticatorUserMap(this.objectMapper, this.storageUpdater.getCurrentUserMapBytes(authenticatorName));
        try {
            BasicAuthenticatorUser user = userMap.get(userName);
            if (user == null) {
                throw new BasicSecurityDBResourceException("User [%s] does not exist.", userName);
            }
            return Response.ok((Object)user).build();
        }
        catch (BasicSecurityDBResourceException cfe) {
            return CoordinatorBasicAuthenticatorResourceHandler.makeResponseForBasicSecurityDBResourceException(cfe);
        }
    }

    @Override
    public Response createUser(String authenticatorName, String userName) {
        BasicHTTPAuthenticator authenticator = this.authenticatorMap.get(authenticatorName);
        if (authenticator == null) {
            return CoordinatorBasicAuthenticatorResourceHandler.makeResponseForAuthenticatorNotFound(authenticatorName);
        }
        try {
            this.storageUpdater.createUser(authenticatorName, userName);
            return Response.ok().build();
        }
        catch (BasicSecurityDBResourceException cfe) {
            return CoordinatorBasicAuthenticatorResourceHandler.makeResponseForBasicSecurityDBResourceException(cfe);
        }
    }

    @Override
    public Response deleteUser(String authenticatorName, String userName) {
        BasicHTTPAuthenticator authenticator = this.authenticatorMap.get(authenticatorName);
        if (authenticator == null) {
            return CoordinatorBasicAuthenticatorResourceHandler.makeResponseForAuthenticatorNotFound(authenticatorName);
        }
        try {
            this.storageUpdater.deleteUser(authenticatorName, userName);
            return Response.ok().build();
        }
        catch (BasicSecurityDBResourceException cfe) {
            return CoordinatorBasicAuthenticatorResourceHandler.makeResponseForBasicSecurityDBResourceException(cfe);
        }
    }

    @Override
    public Response updateUserCredentials(String authenticatorName, String userName, BasicAuthenticatorCredentialUpdate update) {
        BasicHTTPAuthenticator authenticator = this.authenticatorMap.get(authenticatorName);
        if (authenticator == null) {
            return CoordinatorBasicAuthenticatorResourceHandler.makeResponseForAuthenticatorNotFound(authenticatorName);
        }
        try {
            this.storageUpdater.setUserCredentials(authenticatorName, userName, update);
            return Response.ok().build();
        }
        catch (BasicSecurityDBResourceException cfe) {
            return CoordinatorBasicAuthenticatorResourceHandler.makeResponseForBasicSecurityDBResourceException(cfe);
        }
    }

    @Override
    public Response getCachedSerializedUserMap(String authenticatorName) {
        BasicHTTPAuthenticator authenticator = this.authenticatorMap.get(authenticatorName);
        if (authenticator == null) {
            return CoordinatorBasicAuthenticatorResourceHandler.makeResponseForAuthenticatorNotFound(authenticatorName);
        }
        return Response.ok((Object)this.storageUpdater.getCachedSerializedUserMap(authenticatorName)).build();
    }

    @Override
    public Response refreshAll() {
        this.storageUpdater.refreshAllNotification();
        return Response.ok().build();
    }

    @Override
    public Response authenticatorUserUpdateListener(String authenticatorName, byte[] serializedUserMap) {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @Override
    public Response getLoadStatus() {
        HashMap loadStatus = new HashMap();
        this.authenticatorMap.forEach((authenticatorName, authenticator) -> loadStatus.put(authenticatorName, this.storageUpdater.getCachedUserMap((String)authenticatorName) != null));
        return Response.ok(loadStatus).build();
    }

    private static Response makeResponseForAuthenticatorNotFound(String authenticatorName) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ImmutableMap.of((Object)"error", (Object)StringUtils.format((String)"Basic authenticator with name [%s] does not exist.", (Object[])new Object[]{authenticatorName}))).build();
    }

    private static Response makeResponseForBasicSecurityDBResourceException(BasicSecurityDBResourceException bsre) {
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ImmutableMap.of((Object)"error", (Object)bsre.getMessage())).build();
    }
}

