/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.cli;

import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.druid.guice.ExtensionsConfig;
import org.apache.druid.indexing.common.config.TaskConfig;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.filter.DependencyFilterUtils;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.eclipse.aether.util.repository.DefaultProxySelector;

@Command(name="pull-deps", description="Pull down dependencies to the local repository specified by druid.extensions.localRepository, extensions directory specified by druid.extensions.extensionsDir and hadoop dependencies directory specified by druid.extensions.hadoopDependenciesDir")
public class PullDependencies
implements Runnable {
    private static final Logger log = new Logger(PullDependencies.class);
    private static final List<String> DEFAULT_REMOTE_REPOSITORIES = ImmutableList.of((Object)"https://repo1.maven.org/maven2/");
    private static final Dependencies PROVIDED_BY_CORE_DEPENDENCIES = Dependencies.builder().put("com.squareup.okhttp", "okhttp").put("commons-beanutils", "commons-beanutils").put("org.apache.commons", "commons-compress").put("org.apache.zookeeper", "zookeeper").put("com.fasterxml.jackson.core", "jackson-databind").put("com.fasterxml.jackson.core", "jackson-core").put("com.fasterxml.jackson.core", "jackson-annotations").build();
    private static final Dependencies SECURITY_VULNERABILITY_EXCLUSIONS = Dependencies.builder().put("commons-beanutils", "commons-beanutils-core").build();
    private final Dependencies hadoopExclusions;
    @Inject
    public ExtensionsConfig extensionsConfig;
    @Option(name={"-c", "--coordinate"}, title={"coordinate"}, description="Extension coordinate to pull down, followed by a maven coordinate, e.g. org.apache.druid.extensions:mysql-metadata-storage")
    public List<String> coordinates = new ArrayList<String>();
    @Option(name={"-h", "--hadoop-coordinate"}, title={"hadoop coordinate"}, description="Hadoop dependency to pull down, followed by a maven coordinate, e.g. org.apache.hadoop:hadoop-client:2.4.0")
    public List<String> hadoopCoordinates = new ArrayList<String>();
    @Option(name={"--no-default-hadoop"}, description="Don't pull down the default hadoop coordinate, i.e., org.apache.hadoop:hadoop-client-runtime if hadoop3. If `-h` option is supplied, then default hadoop coordinate will not be downloaded.")
    public boolean noDefaultHadoop = false;
    @Option(name={"--clean"}, title={"Remove exisiting extension and hadoop dependencies directories before pulling down dependencies."})
    public boolean clean = false;
    @Option(name={"-l", "--localRepository"}, title={"A local repository that Maven will use to put downloaded files. Then pull-deps will lay these files out into the extensions directory as needed."})
    public String localRepository = StringUtils.format((String)"%s/%s", (Object[])new Object[]{System.getProperty("user.home"), ".m2/repository"});
    @Option(name={"--no-default-remote-repositories"}, description="Don't use the default remote repositories, only use the repositories provided directly via --remoteRepository")
    public boolean noDefaultRemoteRepositories = false;
    @Option(name={"-d", "--defaultVersion"}, title={"Version to use for extension artifacts without version information."})
    public String defaultVersion = PullDependencies.class.getPackage().getImplementationVersion();
    @Option(name={"--use-proxy"}, title={"Use http/https proxy to pull dependencies."})
    public boolean useProxy = false;
    @Option(name={"--proxy-type"}, title={"The proxy type, should be either http or https"})
    public String proxyType = "https";
    @Option(name={"--proxy-host"}, title={"The proxy host"})
    public String proxyHost = "";
    @Option(name={"--proxy-port"}, title={"The proxy port"})
    public int proxyPort = -1;
    @Option(name={"--proxy-username"}, title={"The proxy username"})
    public String proxyUsername = "";
    @Option(name={"--proxy-password"}, title={"The proxy password"})
    public String proxyPassword = "";
    @Option(name={"-r", "--remoteRepository"}, title={"Add a remote repository. Unless --no-default-remote-repositories is provided, these will be used after https://repo1.maven.org/maven2/"})
    List<String> remoteRepositories = new ArrayList<String>();
    private RepositorySystem repositorySystem;
    private RepositorySystemSession repositorySystemSession;

    public PullDependencies() {
        this.hadoopExclusions = Dependencies.builder().putAll(PROVIDED_BY_CORE_DEPENDENCIES).putAll(SECURITY_VULNERABILITY_EXCLUSIONS).build();
    }

    PullDependencies(RepositorySystem repositorySystem, RepositorySystemSession repositorySystemSession, ExtensionsConfig extensionsConfig, Dependencies hadoopExclusions) {
        this.repositorySystem = repositorySystem;
        this.repositorySystemSession = repositorySystemSession;
        this.extensionsConfig = extensionsConfig;
        this.hadoopExclusions = hadoopExclusions;
    }

    private RepositorySystem getRepositorySystem() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        return (RepositorySystem)locator.getService(RepositorySystem.class);
    }

    protected RepositorySystemSession getRepositorySystemSession() {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepo = new LocalRepository(this.localRepository);
        session.setLocalRepositoryManager(this.repositorySystem.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        if (this.useProxy) {
            Proxy proxy = new Proxy(this.proxyType, this.proxyHost, this.proxyPort, this.isBlank(this.proxyUsername) ? null : new AuthenticationBuilder().addUsername(this.proxyUsername).addPassword(this.proxyPassword).build());
            DefaultProxySelector proxySelector = new DefaultProxySelector();
            proxySelector.add(proxy, null);
            session.setProxySelector((ProxySelector)proxySelector);
        }
        return session;
    }

    protected List<RemoteRepository> getRemoteRepositories() {
        ArrayList<RemoteRepository> repositories = new ArrayList<RemoteRepository>();
        if (!this.noDefaultRemoteRepositories) {
            repositories.add(new RemoteRepository.Builder("central", "default", DEFAULT_REMOTE_REPOSITORIES.get(0)).build());
        }
        for (String repoUrl : this.remoteRepositories) {
            repositories.add(new RemoteRepository.Builder(null, "default", repoUrl).build());
        }
        return repositories;
    }

    @Override
    public void run() {
        if (this.repositorySystem == null) {
            this.repositorySystem = this.getRepositorySystem();
        }
        File extensionsDir = new File(this.extensionsConfig.getDirectory());
        File hadoopDependenciesDir = new File(this.extensionsConfig.getHadoopDependenciesDir());
        try {
            if (this.clean) {
                FileUtils.deleteDirectory((File)extensionsDir);
                FileUtils.deleteDirectory((File)hadoopDependenciesDir);
            }
            FileUtils.mkdirp((File)extensionsDir);
            FileUtils.mkdirp((File)hadoopDependenciesDir);
        }
        catch (IOException e) {
            log.error((Throwable)e, "Unable to clear or create extension directory at [%s]", new Object[]{extensionsDir});
            throw new RuntimeException(e);
        }
        log.info("Start pull-deps with local repository [%s] and remote repositories [%s]", new Object[]{this.localRepository, this.remoteRepositories});
        try {
            File currExtensionDir;
            Artifact versionedArtifact;
            log.info("Start downloading dependencies for extension coordinates: [%s]", new Object[]{this.coordinates});
            for (String coordinate : this.coordinates) {
                coordinate = coordinate.trim();
                versionedArtifact = this.getArtifact(coordinate);
                currExtensionDir = new File(extensionsDir, versionedArtifact.getArtifactId());
                this.createExtensionDirectory(coordinate, currExtensionDir);
                this.downloadExtension(versionedArtifact, currExtensionDir);
            }
            log.info("Finish downloading dependencies for extension coordinates: [%s]", new Object[]{this.coordinates});
            if (!this.noDefaultHadoop && this.hadoopCoordinates.isEmpty()) {
                this.hadoopCoordinates.addAll(TaskConfig.DEFAULT_DEFAULT_HADOOP_COORDINATES);
            }
            log.info("Start downloading dependencies for hadoop extension coordinates: [%s]", new Object[]{this.hadoopCoordinates});
            for (String hadoopCoordinate : this.hadoopCoordinates) {
                versionedArtifact = this.getArtifact(hadoopCoordinate);
                currExtensionDir = new File(hadoopDependenciesDir, versionedArtifact.getArtifactId());
                this.createExtensionDirectory(hadoopCoordinate, currExtensionDir);
                currExtensionDir = new File(currExtensionDir, versionedArtifact.getVersion());
                this.createExtensionDirectory(hadoopCoordinate, currExtensionDir);
                this.downloadExtension(versionedArtifact, currExtensionDir, this.hadoopExclusions);
            }
            log.info("Finish downloading dependencies for hadoop extension coordinates: [%s]", new Object[]{this.hadoopCoordinates});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Artifact getArtifact(String coordinate) {
        DefaultArtifact versionedArtifact;
        try {
            versionedArtifact = new DefaultArtifact(coordinate);
        }
        catch (IllegalArgumentException e) {
            if (this.defaultVersion != null) {
                versionedArtifact = new DefaultArtifact(coordinate + ":" + this.defaultVersion);
            }
            throw e;
        }
        return versionedArtifact;
    }

    private void downloadExtension(Artifact versionedArtifact, File toLocation) {
        this.downloadExtension(versionedArtifact, toLocation, PROVIDED_BY_CORE_DEPENDENCIES);
    }

    private void downloadExtension(Artifact versionedArtifact, File toLocation, Dependencies exclusions) {
        CollectRequest collectRequest = new CollectRequest();
        collectRequest.setRoot(new Dependency(versionedArtifact, "runtime"));
        List<RemoteRepository> repositories = this.getRemoteRepositories();
        for (RemoteRepository repo : repositories) {
            collectRequest.addRepository(repo);
        }
        DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, DependencyFilterUtils.andFilter((DependencyFilter[])new DependencyFilter[]{DependencyFilterUtils.classpathFilter((String[])new String[]{"runtime"}), (node, parents) -> {
            String scope = node.getDependency().getScope();
            if (scope != null && ("provided".equals(scope = StringUtils.toLowerCase((String)scope)) || "test".equals(scope) || "system".equals(scope))) {
                return false;
            }
            if (exclusions.contain(node.getArtifact())) {
                return false;
            }
            for (DependencyNode parent : parents) {
                if (!exclusions.contain(parent.getArtifact())) continue;
                return false;
            }
            return true;
        }}));
        try {
            log.info("Start downloading extension [%s]", new Object[]{versionedArtifact});
            if (this.repositorySystemSession == null) {
                this.repositorySystemSession = this.getRepositorySystemSession();
            }
            DependencyResult result = this.repositorySystem.resolveDependencies(this.repositorySystemSession, dependencyRequest);
            List artifacts = result.getArtifactResults().stream().map(ArtifactResult::getArtifact).collect(Collectors.toList());
            for (Artifact artifact : artifacts) {
                if (exclusions.contain(artifact)) {
                    log.debug("Skipped Artifact[%s]", new Object[]{artifact});
                    continue;
                }
                log.info("Adding file [%s] at [%s]", new Object[]{artifact.getFile().getName(), toLocation.getAbsolutePath()});
                org.apache.commons.io.FileUtils.copyFileToDirectory((File)artifact.getFile(), (File)toLocation);
            }
        }
        catch (DependencyResolutionException e) {
            if (e.getCause() instanceof ArtifactNotFoundException) {
                log.error("Artifact not found in any configured repositories: [%s]", new Object[]{versionedArtifact});
            } else {
                log.error((Throwable)e, "Unable to resolve artifacts for [%s].", new Object[]{dependencyRequest});
            }
        }
        catch (IOException e) {
            log.error((Throwable)e, "I/O error while processing artifact [%s].", new Object[]{versionedArtifact});
            throw new RuntimeException(e);
        }
        log.info("Finish downloading extension [%s]", new Object[]{versionedArtifact});
    }

    private void createExtensionDirectory(String coordinate, File atLocation) {
        if (atLocation.isDirectory()) {
            log.info("Directory [%s] already exists, skipping creating a directory", new Object[]{atLocation.getAbsolutePath()});
            return;
        }
        if (!atLocation.mkdir()) {
            throw new ISE("Unable to create directory at [%s] for coordinate [%s]", new Object[]{atLocation.getAbsolutePath(), coordinate});
        }
    }

    private boolean isBlank(String toCheck) {
        return toCheck == null || toCheck.isEmpty();
    }

    @VisibleForTesting
    static class Dependencies {
        private static final String ANY_ARTIFACT_ID = "*";
        private final SetMultimap<String, String> groupIdToArtifactIds;

        private Dependencies(Builder builder) {
            this.groupIdToArtifactIds = builder.groupIdToArtifactIdsBuilder.build();
        }

        static Builder builder() {
            return new Builder();
        }

        boolean contain(Artifact artifact) {
            Set artifactIds = this.groupIdToArtifactIds.get((Object)artifact.getGroupId());
            return artifactIds.contains(ANY_ARTIFACT_ID) || artifactIds.contains(artifact.getArtifactId());
        }

        static final class Builder {
            private final ImmutableSetMultimap.Builder<String, String> groupIdToArtifactIdsBuilder = ImmutableSetMultimap.builder();

            private Builder() {
            }

            Builder putAll(Dependencies dependencies) {
                this.groupIdToArtifactIdsBuilder.putAll(dependencies.groupIdToArtifactIds);
                return this;
            }

            Builder put(String groupId) {
                return this.put(groupId, Dependencies.ANY_ARTIFACT_ID);
            }

            Builder put(String groupId, String artifactId) {
                this.groupIdToArtifactIdsBuilder.put((Object)groupId, (Object)artifactId);
                return this;
            }

            Dependencies build() {
                return new Dependencies(this);
            }
        }
    }
}

