/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.temporal.GetTemporalCalendarWithISODefaultNode;
import com.oracle.truffle.js.nodes.temporal.TemporalCalendarDateFromFieldsNode;
import com.oracle.truffle.js.nodes.temporal.TemporalCalendarFieldsNode;
import com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalCalendarWithISODefaultNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalTimeZoneNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalZonedDateTimeNodeGen;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Boundaries;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDateTimeRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalZonedDateTimeRecord;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalErrors;
import com.oracle.truffle.js.runtime.util.TemporalUtil;
import java.util.List;

public abstract class ToTemporalZonedDateTimeNode
extends JavaScriptBaseNode {
    private final BranchProfile errorBranch = BranchProfile.create();
    private final ConditionProfile isObjectProfile = ConditionProfile.createBinaryProfile();
    private final ConditionProfile isZonedDateTimeProfile = ConditionProfile.createBinaryProfile();
    protected final JSContext ctx;

    protected ToTemporalZonedDateTimeNode(JSContext context) {
        this.ctx = context;
    }

    public static ToTemporalZonedDateTimeNode create(JSContext context) {
        return ToTemporalZonedDateTimeNodeGen.create(context);
    }

    public abstract JSDynamicObject executeDynamicObject(Object var1, JSDynamicObject var2);

    @Specialization
    public JSDynamicObject toTemporalZonedDateTime(Object item, JSDynamicObject options, @Cached(value="create()") IsObjectNode isObjectNode, @Cached(value="create()") JSToStringNode toStringNode, @Cached(value="create()") TemporalGetOptionNode getOptionNode, @Cached(value="create(ctx)") ToTemporalTimeZoneNode toTemporalTimeZone, @Cached(value="create(ctx)") GetTemporalCalendarWithISODefaultNode getTemporalCalendarNode, @Cached(value="create(ctx)") ToTemporalCalendarWithISODefaultNode toTemporalCalendarWithISODefaultNode, @Cached(value="create(ctx)") TemporalCalendarFieldsNode calendarFieldsNode, @Cached TruffleString.EqualNode equalNode, @Cached(value="create(ctx)") TemporalCalendarDateFromFieldsNode dateFromFieldsNode) {
        JSTemporalDateTimeRecord result;
        assert (options != null);
        TruffleString offsetString = null;
        JSDynamicObject timeZone = null;
        JSDynamicObject calendar = null;
        JSRealm realm = JSRealm.get(this);
        TemporalUtil.OffsetBehaviour offsetBehaviour = TemporalUtil.OffsetBehaviour.OPTION;
        TemporalUtil.MatchBehaviour matchBehaviour = TemporalUtil.MatchBehaviour.MATCH_EXACTLY;
        if (this.isObjectProfile.profile(isObjectNode.executeBoolean(item))) {
            JSDynamicObject itemObj = (JSDynamicObject)((Object)item);
            if (this.isZonedDateTimeProfile.profile(TemporalUtil.isTemporalZonedDateTime((Object)itemObj))) {
                return itemObj;
            }
            calendar = getTemporalCalendarNode.executeDynamicObject((Object)itemObj);
            List<TruffleString> fieldNames = calendarFieldsNode.execute(calendar, TemporalUtil.listDHMMMMMNSY);
            Boundaries.listAdd(fieldNames, TemporalConstants.TIME_ZONE);
            Boundaries.listAdd(fieldNames, TemporalConstants.OFFSET);
            JSDynamicObject fields = TemporalUtil.prepareTemporalFields(this.ctx, itemObj, fieldNames, TemporalUtil.listTimeZone);
            Object timeZoneObj = JSObject.get(fields, TemporalConstants.TIME_ZONE);
            timeZone = toTemporalTimeZone.executeDynamicObject(timeZoneObj);
            Object offsetStringObj = JSObject.get(fields, TemporalConstants.OFFSET);
            if (offsetStringObj == Undefined.instance) {
                offsetBehaviour = TemporalUtil.OffsetBehaviour.WALL;
            } else {
                offsetString = toStringNode.executeString(offsetStringObj);
            }
            result = TemporalUtil.interpretTemporalDateTimeFields(calendar, fields, options, getOptionNode, dateFromFieldsNode);
        } else {
            TemporalUtil.toTemporalOverflow(options, getOptionNode);
            TruffleString string = toStringNode.executeString(item);
            JSTemporalZonedDateTimeRecord resultZDT = TemporalUtil.parseTemporalZonedDateTimeString(string);
            result = resultZDT;
            TruffleString timeZoneName = resultZDT.getTimeZoneName();
            assert (timeZoneName != null);
            if (!TemporalUtil.canParseAsTimeZoneNumericUTCOffset(timeZoneName)) {
                if (!TemporalUtil.isValidTimeZoneName(timeZoneName)) {
                    this.errorBranch.enter();
                    throw TemporalErrors.createRangeErrorInvalidTimeZoneString();
                }
                timeZoneName = TemporalUtil.canonicalizeTimeZoneName(timeZoneName);
            }
            offsetString = resultZDT.getTimeZoneOffsetString();
            offsetBehaviour = resultZDT.getTimeZoneZ() ? TemporalUtil.OffsetBehaviour.EXACT : TemporalUtil.OffsetBehaviour.WALL;
            timeZone = TemporalUtil.createTemporalTimeZone(this.ctx, timeZoneName);
            calendar = toTemporalCalendarWithISODefaultNode.executeDynamicObject(result.getCalendar());
            matchBehaviour = TemporalUtil.MatchBehaviour.MATCH_MINUTES;
        }
        long offsetNanoseconds = 0L;
        if (offsetBehaviour == TemporalUtil.OffsetBehaviour.OPTION) {
            offsetNanoseconds = TemporalUtil.parseTimeZoneOffsetString(offsetString);
        }
        TemporalUtil.Disambiguation disambiguation = TemporalUtil.toTemporalDisambiguation(options, getOptionNode, equalNode);
        TemporalUtil.OffsetOption offset = TemporalUtil.toTemporalOffset(options, TemporalConstants.REJECT, getOptionNode, equalNode);
        BigInt epochNanoseconds = TemporalUtil.interpretISODateTimeOffset(this.ctx, realm, result.getYear(), result.getMonth(), result.getDay(), result.getHour(), result.getMinute(), result.getSecond(), result.getMillisecond(), result.getMicrosecond(), result.getNanosecond(), offsetBehaviour, offsetNanoseconds, timeZone, disambiguation, offset, matchBehaviour);
        return JSTemporalZonedDateTime.create(this.ctx, this.getRealm(), epochNanoseconds, timeZone, calendar);
    }
}

