/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.openapi.models.V1LocalObjectReference;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin.")
public class V1FlexVolumeSource {
    public static final String SERIALIZED_NAME_DRIVER = "driver";
    @SerializedName(value="driver")
    private String driver;
    public static final String SERIALIZED_NAME_FS_TYPE = "fsType";
    @SerializedName(value="fsType")
    private String fsType;
    public static final String SERIALIZED_NAME_OPTIONS = "options";
    @SerializedName(value="options")
    private Map<String, String> options = null;
    public static final String SERIALIZED_NAME_READ_ONLY = "readOnly";
    @SerializedName(value="readOnly")
    private Boolean readOnly;
    public static final String SERIALIZED_NAME_SECRET_REF = "secretRef";
    @SerializedName(value="secretRef")
    private V1LocalObjectReference secretRef;

    public V1FlexVolumeSource driver(String driver) {
        this.driver = driver;
        return this;
    }

    @ApiModelProperty(required=true, value="driver is the name of the driver to use for this volume.")
    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public V1FlexVolumeSource fsType(String fsType) {
        this.fsType = fsType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="fsType is the filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. \"ext4\", \"xfs\", \"ntfs\". The default filesystem depends on FlexVolume script.")
    public String getFsType() {
        return this.fsType;
    }

    public void setFsType(String fsType) {
        this.fsType = fsType;
    }

    public V1FlexVolumeSource options(Map<String, String> options) {
        this.options = options;
        return this;
    }

    public V1FlexVolumeSource putOptionsItem(String key, String optionsItem) {
        if (this.options == null) {
            this.options = new HashMap<String, String>();
        }
        this.options.put(key, optionsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="options is Optional: this field holds extra command options if any.")
    public Map<String, String> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, String> options) {
        this.options = options;
    }

    public V1FlexVolumeSource readOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="readOnly is Optional: defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.")
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public V1FlexVolumeSource secretRef(V1LocalObjectReference secretRef) {
        this.secretRef = secretRef;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public V1LocalObjectReference getSecretRef() {
        return this.secretRef;
    }

    public void setSecretRef(V1LocalObjectReference secretRef) {
        this.secretRef = secretRef;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1FlexVolumeSource v1FlexVolumeSource = (V1FlexVolumeSource)o;
        return Objects.equals(this.driver, v1FlexVolumeSource.driver) && Objects.equals(this.fsType, v1FlexVolumeSource.fsType) && Objects.equals(this.options, v1FlexVolumeSource.options) && Objects.equals(this.readOnly, v1FlexVolumeSource.readOnly) && Objects.equals(this.secretRef, v1FlexVolumeSource.secretRef);
    }

    public int hashCode() {
        return Objects.hash(this.driver, this.fsType, this.options, this.readOnly, this.secretRef);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1FlexVolumeSource {\n");
        sb.append("    driver: ").append(this.toIndentedString(this.driver)).append("\n");
        sb.append("    fsType: ").append(this.toIndentedString(this.fsType)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    readOnly: ").append(this.toIndentedString(this.readOnly)).append("\n");
        sb.append("    secretRef: ").append(this.toIndentedString(this.secretRef)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

