/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.discovery;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import javax.annotation.Nullable;
import org.apache.druid.annotations.SuppressFBWarnings;
import org.apache.druid.concurrent.LifecycleLock;
import org.apache.druid.discovery.DruidLeaderSelector;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.k8s.discovery.K8sDiscoveryConfig;
import org.apache.druid.k8s.discovery.K8sLeaderElectorFactory;
import org.apache.druid.k8s.discovery.LeaderElectorAsyncWrapper;
import org.apache.druid.server.DruidNode;
import org.apache.druid.utils.CloseableUtils;

public class K8sDruidLeaderSelector
implements DruidLeaderSelector {
    private static final EmittingLogger LOGGER = new EmittingLogger(K8sDruidLeaderSelector.class);
    private final LifecycleLock lifecycleLock = new LifecycleLock();
    private DruidLeaderSelector.Listener listener = null;
    private final LeaderElectorAsyncWrapper leaderLatch;
    private volatile boolean leader = false;
    @SuppressFBWarnings(value={"VO_VOLATILE_INCREMENT"}, justification="incremented but in single thread")
    private volatile int term = 0;

    public K8sDruidLeaderSelector(@Self DruidNode self, String lockResourceName, String lockResourceNamespace, K8sDiscoveryConfig discoveryConfig, K8sLeaderElectorFactory k8sLeaderElectorFactory) {
        this.leaderLatch = new LeaderElectorAsyncWrapper(self.getServiceScheme() + "://" + self.getHostAndPortToUse(), lockResourceName, lockResourceNamespace, discoveryConfig, k8sLeaderElectorFactory);
    }

    private void startLeaderElector(LeaderElectorAsyncWrapper leaderElector) {
        leaderElector.run(() -> {
            try {
                if (this.leader) {
                    LOGGER.warn("I'm being asked to become leader. But I am already the leader. Ignored event.", new Object[0]);
                    return;
                }
                this.leader = true;
                ++this.term;
                this.listener.becomeLeader();
            }
            catch (Throwable ex) {
                LOGGER.makeAlert(ex, "listener becomeLeader() failed. Unable to become leader", new Object[0]).emit();
                this.closeLeaderLatchQuietly();
                this.leader = false;
                System.exit(1);
            }
        }, () -> {
            try {
                if (!this.leader) {
                    LOGGER.warn("I'm being asked to stop being leader. But I am not the leader. Ignored event.", new Object[0]);
                    return;
                }
                this.leader = false;
                this.listener.stopBeingLeader();
            }
            catch (Throwable ex) {
                LOGGER.makeAlert(ex, "listener.stopBeingLeader() failed. Unable to stopBeingLeader", new Object[0]).emit();
            }
        });
    }

    @Nullable
    public String getCurrentLeader() {
        try {
            return this.leaderLatch.getCurrentLeader();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isLeader() {
        return this.leader;
    }

    public int localTerm() {
        return this.term;
    }

    public void registerListener(DruidLeaderSelector.Listener listener) {
        Preconditions.checkArgument((listener != null ? 1 : 0) != 0, (Object)"listener is null.");
        if (!this.lifecycleLock.canStart()) {
            throw new ISE("can't start.", new Object[0]);
        }
        try {
            this.listener = listener;
            this.startLeaderElector(this.leaderLatch);
            this.lifecycleLock.started();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.lifecycleLock.exitStart();
        }
    }

    public void unregisterListener() {
        if (!this.lifecycleLock.canStop()) {
            throw new ISE("can't stop.", new Object[0]);
        }
        this.closeLeaderLatchQuietly();
    }

    private void closeLeaderLatchQuietly() {
        CloseableUtils.closeAndSuppressExceptions((Closeable)this.leaderLatch, e -> LOGGER.warn("Exception caught while cleaning up leader latch", new Object[0]));
    }
}

