/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.k8s.discovery;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Map;
import org.apache.druid.discovery.DiscoveryDruidNode;
import org.apache.druid.discovery.DruidNodeAnnouncer;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.RetryUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.k8s.discovery.K8sApiClient;
import org.apache.druid.k8s.discovery.K8sDiscoveryConfig;
import org.apache.druid.k8s.discovery.PodInfo;
import org.apache.druid.server.DruidNode;

public class K8sDruidNodeAnnouncer
implements DruidNodeAnnouncer {
    private static final Logger LOGGER = new Logger(K8sDruidNodeAnnouncer.class);
    private static String POD_LABELS_PATH_PREFIX = "/metadata/labels";
    private static String POD_ANNOTATIONS_PATH_PREFIX = "/metadata/annotations";
    private static final String OP_ADD = "add";
    private static final String OP_REMOVE = "remove";
    public static final String ANNOUNCEMENT_DONE = "true";
    private final ObjectMapper jsonMapper;
    private final K8sDiscoveryConfig discoveryConfig;
    private final PodInfo podInfo;
    private final K8sApiClient k8sApiClient;

    @Inject
    public K8sDruidNodeAnnouncer(PodInfo podInfo, K8sDiscoveryConfig discoveryConfig, K8sApiClient k8sApiClient, @Json ObjectMapper jsonMapper) {
        this.discoveryConfig = discoveryConfig;
        this.podInfo = podInfo;
        this.k8sApiClient = k8sApiClient;
        this.jsonMapper = jsonMapper;
    }

    public void announce(DiscoveryDruidNode discoveryDruidNode) {
        LOGGER.info("Announcing DiscoveryDruidNode[%s]", new Object[]{discoveryDruidNode});
        String roleAnnouncementLabel = K8sDruidNodeAnnouncer.getRoleAnnouncementLabel(discoveryDruidNode.getNodeRole());
        String idAnnouncementLabel = K8sDruidNodeAnnouncer.getIdHashAnnouncementLabel();
        String clusterIdentifierAnnouncementLabel = K8sDruidNodeAnnouncer.getClusterIdentifierAnnouncementLabel();
        String infoAnnotation = K8sDruidNodeAnnouncer.getInfoAnnotation(discoveryDruidNode.getNodeRole());
        try {
            ArrayList<Map<String, Object>> patches = new ArrayList<Map<String, Object>>();
            patches.add(this.createPatchObj(OP_ADD, this.getPodDefLabelPath(roleAnnouncementLabel), ANNOUNCEMENT_DONE));
            patches.add(this.createPatchObj(OP_ADD, this.getPodDefLabelPath(idAnnouncementLabel), K8sDruidNodeAnnouncer.hashEncodeStringForLabelValue(discoveryDruidNode.getDruidNode().getHostAndPortToUse())));
            patches.add(this.createPatchObj(OP_ADD, this.getPodDefLabelPath(clusterIdentifierAnnouncementLabel), this.discoveryConfig.getClusterIdentifier()));
            patches.add(this.createPatchObj(OP_ADD, this.getPodDefAnnocationPath(infoAnnotation), this.jsonMapper.writeValueAsString((Object)discoveryDruidNode)));
            String jsonPatchStr = this.jsonMapper.writeValueAsString(patches);
            LOGGER.info("Json Patch For Node Announcement: [%s]", new Object[]{jsonPatchStr});
            RetryUtils.retry(() -> {
                this.k8sApiClient.patchPod(this.podInfo.getPodName(), this.podInfo.getPodNamespace(), jsonPatchStr);
                return "na";
            }, throwable -> true, (int)3);
            LOGGER.info("Announced DiscoveryDruidNode[%s]", new Object[]{discoveryDruidNode});
        }
        catch (Exception ex) {
            throw new RE((Throwable)ex, "Failed to announce DiscoveryDruidNode[%s]", new Object[]{discoveryDruidNode});
        }
    }

    public void unannounce(DiscoveryDruidNode discoveryDruidNode) {
        LOGGER.info("Unannouncing DiscoveryDruidNode[%s]", new Object[]{discoveryDruidNode});
        String roleAnnouncementLabel = K8sDruidNodeAnnouncer.getRoleAnnouncementLabel(discoveryDruidNode.getNodeRole());
        String idHashAnnouncementLabel = K8sDruidNodeAnnouncer.getIdHashAnnouncementLabel();
        String clusterIdentifierAnnouncementLabel = K8sDruidNodeAnnouncer.getClusterIdentifierAnnouncementLabel();
        String infoAnnotation = K8sDruidNodeAnnouncer.getInfoAnnotation(discoveryDruidNode.getNodeRole());
        try {
            ArrayList<Map<String, Object>> patches = new ArrayList<Map<String, Object>>();
            patches.add(this.createPatchObj(OP_REMOVE, this.getPodDefLabelPath(roleAnnouncementLabel), null));
            patches.add(this.createPatchObj(OP_REMOVE, this.getPodDefLabelPath(idHashAnnouncementLabel), null));
            patches.add(this.createPatchObj(OP_REMOVE, this.getPodDefLabelPath(clusterIdentifierAnnouncementLabel), null));
            patches.add(this.createPatchObj(OP_REMOVE, this.getPodDefAnnocationPath(infoAnnotation), null));
            String jsonPatchStr = this.jsonMapper.writeValueAsString(patches);
            RetryUtils.retry(() -> {
                this.k8sApiClient.patchPod(this.podInfo.getPodName(), this.podInfo.getPodNamespace(), jsonPatchStr);
                return "na";
            }, throwable -> true, (int)3);
            LOGGER.info("Unannounced DiscoveryDruidNode[%s]", new Object[]{discoveryDruidNode});
        }
        catch (Exception ex) {
            if (ex instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            LOGGER.error((Throwable)ex, "Failed to unannounce DiscoveryDruidNode[%s]", new Object[]{discoveryDruidNode});
        }
    }

    private Map<String, Object> createPatchObj(String op, String path, Object value) {
        if (value == null) {
            return ImmutableMap.of((Object)"op", (Object)op, (Object)"path", (Object)path);
        }
        return ImmutableMap.of((Object)"op", (Object)op, (Object)"path", (Object)path, (Object)"value", (Object)value);
    }

    public static String getRoleAnnouncementLabel(NodeRole nodeRole) {
        return StringUtils.format((String)"druidDiscoveryAnnouncement-%s", (Object[])new Object[]{nodeRole.getJsonName()});
    }

    private static String getIdHashAnnouncementLabel() {
        return "druidDiscoveryAnnouncement-id-hash";
    }

    public static String getClusterIdentifierAnnouncementLabel() {
        return "druidDiscoveryAnnouncement-cluster-identifier";
    }

    public static String getInfoAnnotation(NodeRole nodeRole) {
        return StringUtils.format((String)"druidNodeInfo-%s", (Object[])new Object[]{nodeRole.getJsonName()});
    }

    public static String getLabelSelectorForNodeRole(K8sDiscoveryConfig discoveryConfig, NodeRole nodeRole) {
        return StringUtils.format((String)"%s=%s,%s=%s", (Object[])new Object[]{K8sDruidNodeAnnouncer.getClusterIdentifierAnnouncementLabel(), discoveryConfig.getClusterIdentifier(), K8sDruidNodeAnnouncer.getRoleAnnouncementLabel(nodeRole), ANNOUNCEMENT_DONE});
    }

    public static String getLabelSelectorForNode(K8sDiscoveryConfig discoveryConfig, NodeRole nodeRole, DruidNode node) {
        return StringUtils.format((String)"%s=%s,%s=%s,%s=%s", (Object[])new Object[]{K8sDruidNodeAnnouncer.getClusterIdentifierAnnouncementLabel(), discoveryConfig.getClusterIdentifier(), K8sDruidNodeAnnouncer.getRoleAnnouncementLabel(nodeRole), ANNOUNCEMENT_DONE, K8sDruidNodeAnnouncer.getIdHashAnnouncementLabel(), K8sDruidNodeAnnouncer.hashEncodeStringForLabelValue(node.getHostAndPortToUse())});
    }

    private String getPodDefLabelPath(String label) {
        return StringUtils.format((String)"%s/%s", (Object[])new Object[]{POD_LABELS_PATH_PREFIX, label});
    }

    private String getPodDefAnnocationPath(String annotation) {
        return StringUtils.format((String)"%s/%s", (Object[])new Object[]{POD_ANNOTATIONS_PATH_PREFIX, annotation});
    }

    private static String hashEncodeStringForLabelValue(String str) {
        int hash = str.hashCode();
        if (hash < 0) {
            hash = -1 * hash;
        }
        return String.valueOf(hash);
    }
}

