/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.batch;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.IterableStream;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobServiceVersion;
import com.azure.storage.blob.batch.BlobBatch;
import com.azure.storage.blob.batch.BlobBatchClientBuilder;
import com.azure.storage.blob.batch.BlobBatchHelper;
import com.azure.storage.blob.implementation.AzureBlobStorageImpl;
import com.azure.storage.blob.implementation.AzureBlobStorageImplBuilder;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.DeleteSnapshotsOptionType;
import com.azure.storage.common.implementation.StorageImplUtils;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=BlobBatchClientBuilder.class, isAsync=true)
public final class BlobBatchAsyncClient {
    private static final ClientLogger LOGGER = new ClientLogger(BlobBatchAsyncClient.class);
    private final AzureBlobStorageImpl client;
    private final boolean containerScoped;
    private final BlobServiceVersion serviceVersion;

    BlobBatchAsyncClient(String clientUrl, HttpPipeline pipeline, BlobServiceVersion version, boolean containerScoped) {
        this.serviceVersion = version;
        this.client = new AzureBlobStorageImplBuilder().url(clientUrl).pipeline(pipeline).version(version.getVersion()).buildClient();
        this.containerScoped = containerScoped;
    }

    AzureBlobStorageImpl getClient() {
        return this.client;
    }

    public BlobBatch getBlobBatch() {
        return new BlobBatch(this.client.getUrl(), this.client.getHttpPipeline(), this.serviceVersion);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> submitBatch(BlobBatch batch) {
        try {
            return FluxUtil.withContext(context -> this.submitBatchWithResponse(batch, true, (Context)context)).flatMap(FluxUtil::toMono);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> submitBatchWithResponse(BlobBatch batch, boolean throwOnAnyFailure) {
        try {
            return FluxUtil.withContext(context -> this.submitBatchWithResponse(batch, throwOnAnyFailure, (Context)context));
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    Mono<Response<Void>> submitBatchWithResponse(BlobBatch batch, boolean throwOnAnyFailure, Context context) {
        Context finalContext = context == null ? Context.NONE : context;
        return batch.prepareBlobBatchSubmission().flatMap(batchOperationInfo -> this.containerScoped ? this.client.getContainers().submitBatchWithResponseAsync(null, batchOperationInfo.getContentLength(), batchOperationInfo.getContentType(), Flux.fromIterable(batchOperationInfo.getBody()), null, null, finalContext).flatMap(response -> BlobBatchHelper.mapBatchResponse(batchOperationInfo, (Response<Flux<ByteBuffer>>)response, throwOnAnyFailure, LOGGER)) : this.client.getServices().submitBatchWithResponseAsync(batchOperationInfo.getContentLength(), batchOperationInfo.getContentType(), Flux.fromIterable(batchOperationInfo.getBody()), null, null, finalContext).flatMap(response -> BlobBatchHelper.mapBatchResponse(batchOperationInfo, (Response<Flux<ByteBuffer>>)response, throwOnAnyFailure, LOGGER)));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<Response<Void>> deleteBlobs(List<String> blobUrls, DeleteSnapshotsOptionType deleteOptions) {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.submitDeleteBlobsBatch(blobUrls, deleteOptions, (Context)context)));
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    PagedFlux<Response<Void>> deleteBlobsWithTimeout(List<String> blobUrls, DeleteSnapshotsOptionType deleteOptions, Duration timeout, Context context) {
        return new PagedFlux(() -> StorageImplUtils.applyOptionalTimeout(this.submitDeleteBlobsBatch(blobUrls, deleteOptions, context), (Duration)timeout));
    }

    private Mono<PagedResponse<Response<Void>>> submitDeleteBlobsBatch(List<String> blobUrls, DeleteSnapshotsOptionType deleteOptions, Context context) {
        return this.submitBatchHelper(blobUrls, (batch, blobUrl) -> batch.deleteBlob((String)blobUrl, deleteOptions, null), context);
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<Response<Void>> setBlobsAccessTier(List<String> blobUrls, AccessTier accessTier) {
        try {
            return new PagedFlux(() -> FluxUtil.withContext(context -> this.submitSetTierBatch(blobUrls, accessTier, (Context)context)));
        }
        catch (RuntimeException ex) {
            return FluxUtil.pagedFluxError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    PagedFlux<Response<Void>> setBlobsAccessTierWithTimeout(List<String> blobUrls, AccessTier accessTier, Duration timeout, Context context) {
        return new PagedFlux(() -> StorageImplUtils.applyOptionalTimeout(this.submitSetTierBatch(blobUrls, accessTier, context), (Duration)timeout));
    }

    private Mono<PagedResponse<Response<Void>>> submitSetTierBatch(List<String> blobUrls, AccessTier accessTier, Context context) {
        return this.submitBatchHelper(blobUrls, (batch, blobUrl) -> batch.setBlobAccessTier((String)blobUrl, accessTier), context);
    }

    private <T> Mono<PagedResponse<Response<T>>> submitBatchHelper(List<String> blobUrls, BiFunction<BlobBatch, String, Response<T>> generator, Context context) {
        BlobBatch batch = this.getBlobBatch();
        ArrayList responses = new ArrayList();
        for (String blobUrl : blobUrls) {
            responses.add(generator.apply(batch, blobUrl));
        }
        return this.submitBatchWithResponse(batch, true, context).map(response -> this.initPagedResponse(responses, (Response<?>)response));
    }

    private <T> PagedResponse<Response<T>> initPagedResponse(final List<Response<T>> values, final Response<?> response) {
        return new PagedResponse<Response<T>>(){

            public IterableStream<Response<T>> getElements() {
                return new IterableStream((Iterable)values);
            }

            public String getContinuationToken() {
                return null;
            }

            public int getStatusCode() {
                return response.getStatusCode();
            }

            public HttpHeaders getHeaders() {
                return response.getHeaders();
            }

            public HttpRequest getRequest() {
                return response.getRequest();
            }

            public void close() {
            }
        };
    }
}

