/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.collections.spatial;

import java.nio.ByteBuffer;
import java.util.Iterator;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.ImmutableBitmap;
import org.apache.druid.collections.spatial.ImmutableFloatPoint;
import org.apache.druid.collections.spatial.ImmutableNode;

public class ImmutableFloatNode
implements ImmutableNode<float[]> {
    public static final int HEADER_NUM_BYTES = 2;
    private final int numDims;
    private final int initialOffset;
    private final int offsetFromInitial;
    private final short numChildren;
    private final boolean isLeaf;
    private final int childrenOffset;
    private final ByteBuffer data;
    private final BitmapFactory bitmapFactory;

    public ImmutableFloatNode(int numDims, int initialOffset, int offsetFromInitial, ByteBuffer data, BitmapFactory bitmapFactory) {
        this.bitmapFactory = bitmapFactory;
        this.numDims = numDims;
        this.initialOffset = initialOffset;
        this.offsetFromInitial = offsetFromInitial;
        short header = data.getShort(initialOffset + offsetFromInitial);
        this.isLeaf = (header & 0x8000) != 0;
        this.numChildren = (short)(header & Short.MAX_VALUE);
        int sizePosition = initialOffset + offsetFromInitial + 2 + 2 * numDims * 4;
        int bitmapSize = data.getInt(sizePosition);
        this.childrenOffset = sizePosition + 4 + bitmapSize;
        this.data = data;
    }

    public ImmutableFloatNode(int numDims, int initialOffset, int offsetFromInitial, short numChildren, boolean leaf, ByteBuffer data, BitmapFactory bitmapFactory) {
        this.bitmapFactory = bitmapFactory;
        this.numDims = numDims;
        this.initialOffset = initialOffset;
        this.offsetFromInitial = offsetFromInitial;
        this.numChildren = numChildren;
        this.isLeaf = leaf;
        int sizePosition = initialOffset + offsetFromInitial + 2 + 2 * numDims * 4;
        int bitmapSize = data.getInt(sizePosition);
        this.childrenOffset = sizePosition + 4 + bitmapSize;
        this.data = data;
    }

    @Override
    public BitmapFactory getBitmapFactory() {
        return this.bitmapFactory;
    }

    @Override
    public int getInitialOffset() {
        return this.initialOffset;
    }

    @Override
    public int getOffsetFromInitial() {
        return this.offsetFromInitial;
    }

    @Override
    public int getNumDims() {
        return this.numDims;
    }

    @Override
    public boolean isLeaf() {
        return this.isLeaf;
    }

    @Override
    public float[] getMinCoordinates() {
        return this.getCoords(this.initialOffset + this.offsetFromInitial + 2);
    }

    @Override
    public float[] getMaxCoordinates() {
        return this.getCoords(this.initialOffset + this.offsetFromInitial + 2 + this.numDims * 4);
    }

    @Override
    public ImmutableBitmap getImmutableBitmap() {
        int sizePosition = this.initialOffset + this.offsetFromInitial + 2 + 2 * this.numDims * 4;
        int numBytes = this.data.getInt(sizePosition);
        ByteBuffer readOnlyBuffer = this.data.asReadOnlyBuffer();
        readOnlyBuffer.position(sizePosition + 4);
        readOnlyBuffer.limit(readOnlyBuffer.position() + numBytes);
        return this.bitmapFactory.mapImmutableBitmap(readOnlyBuffer);
    }

    @Override
    public Iterable<ImmutableNode<float[]>> getChildren() {
        return new Iterable<ImmutableNode<float[]>>(){

            @Override
            public Iterator<ImmutableNode<float[]>> iterator() {
                return new Iterator<ImmutableNode<float[]>>(){
                    private int count = 0;

                    @Override
                    public boolean hasNext() {
                        return this.count < ImmutableFloatNode.this.numChildren;
                    }

                    @Override
                    public ImmutableNode<float[]> next() {
                        if (ImmutableFloatNode.this.isLeaf) {
                            return new ImmutableFloatPoint(ImmutableFloatNode.this.numDims, ImmutableFloatNode.this.initialOffset, ImmutableFloatNode.this.data.getInt(ImmutableFloatNode.this.childrenOffset + this.count++ * 4), ImmutableFloatNode.this.data, ImmutableFloatNode.this.bitmapFactory);
                        }
                        return new ImmutableFloatNode(ImmutableFloatNode.this.numDims, ImmutableFloatNode.this.initialOffset, ImmutableFloatNode.this.data.getInt(ImmutableFloatNode.this.childrenOffset + this.count++ * 4), ImmutableFloatNode.this.data, ImmutableFloatNode.this.bitmapFactory);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public ByteBuffer getData() {
        return this.data;
    }

    private float[] getCoords(int offset) {
        float[] retVal = new float[this.numDims];
        ByteBuffer readOnlyBuffer = this.data.asReadOnlyBuffer();
        readOnlyBuffer.position(offset);
        readOnlyBuffer.asFloatBuffer().get(retVal);
        return retVal;
    }
}

